/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MedicationAdministration;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.UriType;

public class MedicationAdministration30_50 {
    public static MedicationAdministration convertMedicationAdministration(org.hl7.fhir.r5.model.MedicationAdministration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration tgt = new MedicationAdministration();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (UriType uriType : src.getInstantiatesUri()) {
            tgt.addDefinition().setReference((String)uriType.getValue());
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationAdministration30_50.convertMedicationAdministrationStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.getMedication().hasConcept()) {
            tgt.setMedication(VersionConvertor_30_50.convertType(src.getMedication().getConcept()));
        }
        if (src.getMedication().hasReference()) {
            tgt.setMedication(VersionConvertor_30_50.convertType(src.getMedication().getReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasOccurence()) {
            tgt.setEffective(VersionConvertor_30_50.convertType(src.getOccurence()));
        }
        for (MedicationAdministration.MedicationAdministrationPerformerComponent medicationAdministrationPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(MedicationAdministration30_50.convertMedicationAdministrationPerformerComponent(medicationAdministrationPerformerComponent));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(VersionConvertor_30_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(VersionConvertor_30_50.convertReference(codeableReference.getReference()));
        }
        if (src.hasRequest()) {
            tgt.setPrescription(VersionConvertor_30_50.convertReference(src.getRequest()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getDevice()) {
            tgt.addDevice(VersionConvertor_30_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        if (src.hasDosage()) {
            tgt.setDosage(MedicationAdministration30_50.convertMedicationAdministrationDosageComponent(src.getDosage()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.MedicationAdministration convertMedicationAdministration(MedicationAdministration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.MedicationAdministration tgt = new org.hl7.fhir.r5.model.MedicationAdministration();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getDefinition()) {
            tgt.addInstantiatesUri(reference.getReference());
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationAdministration30_50.convertMedicationAdministrationStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_30_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedicationCodeableConcept()) {
            tgt.getMedication().setConcept(VersionConvertor_30_50.convertCodeableConcept(src.getMedicationCodeableConcept()));
        }
        if (src.hasMedicationReference()) {
            tgt.getMedication().setReference(VersionConvertor_30_50.convertReference(src.getMedicationReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getContext()));
        }
        for (Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasEffective()) {
            tgt.setOccurence(VersionConvertor_30_50.convertType(src.getEffective()));
        }
        for (MedicationAdministration.MedicationAdministrationPerformerComponent medicationAdministrationPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(MedicationAdministration30_50.convertMedicationAdministrationPerformerComponent(medicationAdministrationPerformerComponent));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(VersionConvertor_30_50.convertCodeableConceptToCodableReference(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReason(VersionConvertor_30_50.convertReferenceToCodableReference(reference));
        }
        if (src.hasPrescription()) {
            tgt.setRequest(VersionConvertor_30_50.convertReference(src.getPrescription()));
        }
        for (Reference reference : src.getDevice()) {
            tgt.addDevice(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        if (src.hasDosage()) {
            tgt.setDosage(MedicationAdministration30_50.convertMedicationAdministrationDosageComponent(src.getDosage()));
        }
        for (Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationDosageComponent convertMedicationAdministrationDosageComponent(MedicationAdministration.MedicationAdministrationDosageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationDosageComponent tgt = new MedicationAdministration.MedicationAdministrationDosageComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_50.convertString(src.getTextElement()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_30_50.convertSimpleQuantity(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_30_50.convertType(src.getRate()));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationDosageComponent convertMedicationAdministrationDosageComponent(MedicationAdministration.MedicationAdministrationDosageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationDosageComponent tgt = new MedicationAdministration.MedicationAdministrationDosageComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_50.convertString(src.getTextElement()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_30_50.convertSimpleQuantity(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_30_50.convertType(src.getRate()));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationPerformerComponent convertMedicationAdministrationPerformerComponent(MedicationAdministration.MedicationAdministrationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationPerformerComponent tgt = new MedicationAdministration.MedicationAdministrationPerformerComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationPerformerComponent convertMedicationAdministrationPerformerComponent(MedicationAdministration.MedicationAdministrationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationPerformerComponent tgt = new MedicationAdministration.MedicationAdministrationPerformerComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static Enumeration<MedicationAdministration.MedicationAdministrationStatusCodes> convertMedicationAdministrationStatus(org.hl7.fhir.dstu3.model.Enumeration<MedicationAdministration.MedicationAdministrationStatus> src) {
        if (src == null) {
            return null;
        }
        Enumeration<MedicationAdministration.MedicationAdministrationStatusCodes> tgt = new Enumeration<MedicationAdministration.MedicationAdministrationStatusCodes>(new MedicationAdministration.MedicationAdministrationStatusCodesEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatusCodes.fromCode(src.getValueAsString()));
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationAdministration.MedicationAdministrationStatus> convertMedicationAdministrationStatus(Enumeration<MedicationAdministration.MedicationAdministrationStatusCodes> src) {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationAdministration.MedicationAdministrationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationAdministration.MedicationAdministrationStatus>();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.fromCode(src.getValueAsString()));
        return tgt;
    }
}

