/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Immunization;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Immunization;

public class Immunization30_50 {
    public static org.hl7.fhir.r5.model.Immunization convertImmunization(Immunization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Immunization tgt = new org.hl7.fhir.r5.model.Immunization();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Immunization30_50.convertImmunizationStatus(src.getStatusElement()));
        }
        if (src.hasVaccineCode()) {
            tgt.setVaccineCode(VersionConvertor_30_50.convertCodeableConcept(src.getVaccineCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setOccurrence(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPrimarySource()) {
            tgt.setPrimarySourceElement(VersionConvertor_30_50.convertBoolean(src.getPrimarySourceElement()));
        }
        if (src.hasReportOrigin()) {
            tgt.setInformationSource(VersionConvertor_30_50.convertCodeableConcept(src.getReportOrigin()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_50.convertReference(src.getLocation()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(VersionConvertor_30_50.convertReference(src.getManufacturer()));
        }
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(VersionConvertor_30_50.convertString(src.getLotNumberElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(VersionConvertor_30_50.convertDate(src.getExpirationDateElement()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasDoseQuantity()) {
            tgt.setDoseQuantity(VersionConvertor_30_50.convertSimpleQuantity(src.getDoseQuantity()));
        }
        for (Immunization.ImmunizationPractitionerComponent immunizationPractitionerComponent : src.getPractitioner()) {
            tgt.addPerformer(Immunization30_50.convertImmunizationPractitionerComponent(immunizationPractitionerComponent));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (CodeableConcept codeableConcept : src.getExplanation().getReason()) {
            tgt.addReason(VersionConvertor_30_50.convertCodeableConceptToCodableReference(codeableConcept));
        }
        return tgt;
    }

    public static Immunization convertImmunization(org.hl7.fhir.r5.model.Immunization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization tgt = new Immunization();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Immunization30_50.convertImmunizationStatus(src.getStatusElement()));
        }
        if (src.hasVaccineCode()) {
            tgt.setVaccineCode(VersionConvertor_30_50.convertCodeableConcept(src.getVaccineCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrenceDateTimeType()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getOccurrenceDateTimeType()));
        }
        if (src.hasPrimarySource()) {
            tgt.setPrimarySourceElement(VersionConvertor_30_50.convertBoolean(src.getPrimarySourceElement()));
        }
        if (src.hasInformationSourceCodeableConcept()) {
            tgt.setReportOrigin(VersionConvertor_30_50.convertCodeableConcept(src.getInformationSourceCodeableConcept()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_50.convertReference(src.getLocation()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(VersionConvertor_30_50.convertReference(src.getManufacturer()));
        }
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(VersionConvertor_30_50.convertString(src.getLotNumberElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(VersionConvertor_30_50.convertDate(src.getExpirationDateElement()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasDoseQuantity()) {
            tgt.setDoseQuantity(VersionConvertor_30_50.convertSimpleQuantity(src.getDoseQuantity()));
        }
        for (Immunization.ImmunizationPerformerComponent immunizationPerformerComponent : src.getPerformer()) {
            tgt.addPractitioner(Immunization30_50.convertImmunizationPractitionerComponent(immunizationPerformerComponent));
        }
        for (org.hl7.fhir.r5.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.getExplanation().addReason(VersionConvertor_30_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        return tgt;
    }

    public static Immunization.ImmunizationPractitionerComponent convertImmunizationPractitionerComponent(Immunization.ImmunizationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationPractitionerComponent tgt = new Immunization.ImmunizationPractitionerComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setRole(VersionConvertor_30_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static Immunization.ImmunizationPerformerComponent convertImmunizationPractitionerComponent(Immunization.ImmunizationPractitionerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationPerformerComponent tgt = new Immunization.ImmunizationPerformerComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setFunction(VersionConvertor_30_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Immunization.ImmunizationStatus> convertImmunizationStatus(Enumeration<Immunization.ImmunizationStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Immunization.ImmunizationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Immunization.ImmunizationStatus>(new Immunization.ImmunizationStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Immunization.ImmunizationStatusCodes)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)Immunization.ImmunizationStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Immunization.ImmunizationStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Immunization.ImmunizationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Immunization.ImmunizationStatusCodes> convertImmunizationStatus(org.hl7.fhir.dstu3.model.Enumeration<Immunization.ImmunizationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Immunization.ImmunizationStatusCodes> tgt = new Enumeration<Immunization.ImmunizationStatusCodes>(new Immunization.ImmunizationStatusCodesEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Immunization.ImmunizationStatus)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)Immunization.ImmunizationStatusCodes.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Immunization.ImmunizationStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Immunization.ImmunizationStatusCodes.NULL);
            }
        }
        return tgt;
    }
}

