/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.HealthcareService;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.HealthcareService;

public class HealthcareService30_50 {
    public static org.hl7.fhir.r5.model.HealthcareService convertHealthcareService(HealthcareService src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.HealthcareService tgt = new org.hl7.fhir.r5.model.HealthcareService();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_30_50.convertReference(src.getProvidedBy()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_30_50.convertCodeableConcept(src.getCategory()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetails(src.getExtraDetails());
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_30_50.convertAttachment(src.getPhoto()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        for (Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasEligibility() || src.hasEligibilityNote()) {
            HealthcareService.HealthcareServiceEligibilityComponent t = tgt.addEligibility();
            t.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getEligibility()));
            if (src.hasEligibilityNote()) {
                t.setComment(src.getEligibilityNote());
            }
        }
        for (StringType stringType : src.getProgramName()) {
            tgt.addProgram().setText((String)stringType.getValue());
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentRequired()) {
            tgt.setAppointmentRequiredElement(VersionConvertor_30_50.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (HealthcareService.HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService30_50.convertHealthcareServiceAvailableTimeComponent(healthcareServiceAvailableTimeComponent));
        }
        for (HealthcareService.HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService30_50.convertHealthcareServiceNotAvailableComponent(healthcareServiceNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_30_50.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static HealthcareService convertHealthcareService(org.hl7.fhir.r5.model.HealthcareService src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService tgt = new HealthcareService();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_30_50.convertReference(src.getProvidedBy()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetails(src.getExtraDetails());
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_30_50.convertAttachment(src.getPhoto()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(contactPoint));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_30_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasEligibility()) {
            tgt.setEligibility(VersionConvertor_30_50.convertCodeableConcept(src.getEligibilityFirstRep().getCode()));
            if (src.getEligibilityFirstRep().hasComment()) {
                tgt.setEligibilityNoteElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
            }
        }
        for (CodeableConcept codeableConcept : src.getProgram()) {
            tgt.addProgramName(codeableConcept.getText());
        }
        for (CodeableConcept codeableConcept : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentRequired()) {
            tgt.setAppointmentRequiredElement(VersionConvertor_30_50.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (HealthcareService.HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService30_50.convertHealthcareServiceAvailableTimeComponent(healthcareServiceAvailableTimeComponent));
        }
        for (HealthcareService.HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService30_50.convertHealthcareServiceNotAvailableComponent(healthcareServiceNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_30_50.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService30_50::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(VersionConvertor_30_50.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_30_50.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_30_50.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService30_50::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(VersionConvertor_30_50.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_30_50.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_30_50.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek> convertDaysOfWeek(Enumeration<Enumerations.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek> tgt = new org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek>(new HealthcareService.DaysOfWeekEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.DaysOfWeek> convertDaysOfWeek(org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.DaysOfWeek> tgt = new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((HealthcareService.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_30_50.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_30_50.convertPeriod(src.getDuring()));
        }
        return tgt;
    }
}

