/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Flag;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Flag;

public class Flag30_50 {
    public static Flag convertFlag(org.hl7.fhir.dstu3.model.Flag src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Flag tgt = new Flag();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Flag30_50.convertFlagStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_30_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_50.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Flag convertFlag(Flag src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Flag tgt = new org.hl7.fhir.dstu3.model.Flag();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Flag30_50.convertFlagStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_50.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Flag.FlagStatus> convertFlagStatus(Enumeration<Flag.FlagStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Flag.FlagStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Flag.FlagStatus>(new Flag.FlagStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Flag.FlagStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Flag.FlagStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Flag.FlagStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Flag.FlagStatus> convertFlagStatus(org.hl7.fhir.dstu3.model.Enumeration<Flag.FlagStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Flag.FlagStatus> tgt = new Enumeration<Flag.FlagStatus>(new Flag.FlagStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Flag.FlagStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Flag.FlagStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Flag.FlagStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Flag.FlagStatus.NULL);
            }
        }
        return tgt;
    }
}

