/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;

public class EpisodeOfCare30_50 {
    public static EpisodeOfCare convertEpisodeOfCare(org.hl7.fhir.r5.model.EpisodeOfCare src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare tgt = new EpisodeOfCare();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare30_50.convertEpisodeOfCareStatus(src.getStatusElement()));
        }
        for (EpisodeOfCare.EpisodeOfCareStatusHistoryComponent episodeOfCareStatusHistoryComponent : src.getStatusHistory()) {
            tgt.addStatusHistory(EpisodeOfCare30_50.convertEpisodeOfCareStatusHistoryComponent(episodeOfCareStatusHistoryComponent));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (EpisodeOfCare.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(VersionConvertor_30_50.convertDiagnosisComponent(diagnosisComponent));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_50.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getReferralRequest()) {
            tgt.addReferralRequest(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasCareManager()) {
            tgt.setCareManager(VersionConvertor_30_50.convertReference(src.getCareManager()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getTeam()) {
            tgt.addTeam(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getAccount()) {
            tgt.addAccount(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.EpisodeOfCare convertEpisodeOfCare(EpisodeOfCare src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.EpisodeOfCare tgt = new org.hl7.fhir.r5.model.EpisodeOfCare();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare30_50.convertEpisodeOfCareStatus(src.getStatusElement()));
        }
        for (EpisodeOfCare.EpisodeOfCareStatusHistoryComponent episodeOfCareStatusHistoryComponent : src.getStatusHistory()) {
            tgt.addStatusHistory(EpisodeOfCare30_50.convertEpisodeOfCareStatusHistoryComponent(episodeOfCareStatusHistoryComponent));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (EpisodeOfCare.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(VersionConvertor_30_50.convertDiagnosisComponent(diagnosisComponent));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_50.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        for (Reference reference : src.getReferralRequest()) {
            tgt.addReferralRequest(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasCareManager()) {
            tgt.setCareManager(VersionConvertor_30_50.convertReference(src.getCareManager()));
        }
        for (Reference reference : src.getTeam()) {
            tgt.addTeam(VersionConvertor_30_50.convertReference(reference));
        }
        for (Reference reference : src.getAccount()) {
            tgt.addAccount(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static Enumeration<EpisodeOfCare.EpisodeOfCareStatus> convertEpisodeOfCareStatus(org.hl7.fhir.dstu3.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<EpisodeOfCare.EpisodeOfCareStatus> tgt = new Enumeration<EpisodeOfCare.EpisodeOfCareStatus>(new EpisodeOfCare.EpisodeOfCareStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((EpisodeOfCare.EpisodeOfCareStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.PLANNED);
                break;
            }
            case WAITLIST: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.WAITLIST);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ONHOLD);
                break;
            }
            case FINISHED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.FINISHED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus> convertEpisodeOfCareStatus(Enumeration<EpisodeOfCare.EpisodeOfCareStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus>(new EpisodeOfCare.EpisodeOfCareStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((EpisodeOfCare.EpisodeOfCareStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.PLANNED);
                break;
            }
            case WAITLIST: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.WAITLIST);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ONHOLD);
                break;
            }
            case FINISHED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.FINISHED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.NULL);
            }
        }
        return tgt;
    }

    public static EpisodeOfCare.EpisodeOfCareStatusHistoryComponent convertEpisodeOfCareStatusHistoryComponent(EpisodeOfCare.EpisodeOfCareStatusHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent tgt = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare30_50.convertEpisodeOfCareStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static EpisodeOfCare.EpisodeOfCareStatusHistoryComponent convertEpisodeOfCareStatusHistoryComponent(EpisodeOfCare.EpisodeOfCareStatusHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent tgt = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare30_50.convertEpisodeOfCareStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

