/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Enumeration;

public class Encounter30_50 {
    public static Encounter.ClassHistoryComponent convertClassHistoryComponent(Encounter.ClassHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.ClassHistoryComponent tgt = new Encounter.ClassHistoryComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_30_50.convertCoding(src.getClass_()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Encounter.ClassHistoryComponent convertClassHistoryComponent(Encounter.ClassHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.ClassHistoryComponent tgt = new Encounter.ClassHistoryComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_30_50.convertCoding(src.getClass_()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Encounter convertEncounter(Encounter src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Encounter tgt = new org.hl7.fhir.r5.model.Encounter();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Encounter30_50.convertEncounterStatus(src.getStatusElement()));
        }
        for (Encounter.StatusHistoryComponent statusHistoryComponent : src.getStatusHistory()) {
            tgt.addStatusHistory(Encounter30_50.convertStatusHistoryComponent(statusHistoryComponent));
        }
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_30_50.convertCoding(src.getClass_()));
        }
        for (Encounter.ClassHistoryComponent classHistoryComponent : src.getClassHistory()) {
            tgt.addClassHistory(Encounter30_50.convertClassHistoryComponent(classHistoryComponent));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getEpisodeOfCare()) {
            tgt.addEpisodeOfCare(VersionConvertor_30_50.convertReference(reference));
        }
        for (Reference reference : src.getIncomingReferral()) {
            tgt.addBasedOn(VersionConvertor_30_50.convertReference(reference));
        }
        for (Encounter.EncounterParticipantComponent encounterParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Encounter30_50.convertEncounterParticipantComponent(encounterParticipantComponent));
        }
        if (src.hasAppointment()) {
            tgt.addAppointment(VersionConvertor_30_50.convertReference(src.getAppointment()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasLength()) {
            tgt.setLength(VersionConvertor_30_50.convertDuration(src.getLength()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(VersionConvertor_30_50.convertCodeableConceptToCodableReference(codeableConcept));
        }
        for (Encounter.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(VersionConvertor_30_50.convertDiagnosisComponent(diagnosisComponent));
        }
        for (Reference reference : src.getAccount()) {
            tgt.addAccount(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasHospitalization()) {
            tgt.setHospitalization(Encounter30_50.convertEncounterHospitalizationComponent(src.getHospitalization()));
        }
        for (Encounter.EncounterLocationComponent encounterLocationComponent : src.getLocation()) {
            tgt.addLocation(Encounter30_50.convertEncounterLocationComponent(encounterLocationComponent));
        }
        if (src.hasServiceProvider()) {
            tgt.setServiceProvider(VersionConvertor_30_50.convertReference(src.getServiceProvider()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_30_50.convertReference(src.getPartOf()));
        }
        return tgt;
    }

    public static Encounter convertEncounter(org.hl7.fhir.r5.model.Encounter src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter tgt = new Encounter();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Encounter30_50.convertEncounterStatus(src.getStatusElement()));
        }
        for (Encounter.StatusHistoryComponent statusHistoryComponent : src.getStatusHistory()) {
            tgt.addStatusHistory(Encounter30_50.convertStatusHistoryComponent(statusHistoryComponent));
        }
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_30_50.convertCoding(src.getClass_()));
        }
        for (Encounter.ClassHistoryComponent classHistoryComponent : src.getClassHistory()) {
            tgt.addClassHistory(Encounter30_50.convertClassHistoryComponent(classHistoryComponent));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getEpisodeOfCare()) {
            tgt.addEpisodeOfCare(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getBasedOn()) {
            tgt.addIncomingReferral(VersionConvertor_30_50.convertReference(reference));
        }
        for (Encounter.EncounterParticipantComponent encounterParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Encounter30_50.convertEncounterParticipantComponent(encounterParticipantComponent));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(VersionConvertor_30_50.convertReference(src.getAppointmentFirstRep()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasLength()) {
            tgt.setLength(VersionConvertor_30_50.convertDuration(src.getLength()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReason(VersionConvertor_30_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (Encounter.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(VersionConvertor_30_50.convertDiagnosisComponent(diagnosisComponent));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getAccount()) {
            tgt.addAccount(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasHospitalization()) {
            tgt.setHospitalization(Encounter30_50.convertEncounterHospitalizationComponent(src.getHospitalization()));
        }
        for (Encounter.EncounterLocationComponent encounterLocationComponent : src.getLocation()) {
            tgt.addLocation(Encounter30_50.convertEncounterLocationComponent(encounterLocationComponent));
        }
        if (src.hasServiceProvider()) {
            tgt.setServiceProvider(VersionConvertor_30_50.convertReference(src.getServiceProvider()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_30_50.convertReference(src.getPartOf()));
        }
        return tgt;
    }

    public static Encounter.EncounterHospitalizationComponent convertEncounterHospitalizationComponent(Encounter.EncounterHospitalizationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterHospitalizationComponent tgt = new Encounter.EncounterHospitalizationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPreAdmissionIdentifier()) {
            tgt.setPreAdmissionIdentifier(VersionConvertor_30_50.convertIdentifier(src.getPreAdmissionIdentifier()));
        }
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_30_50.convertReference(src.getOrigin()));
        }
        if (src.hasAdmitSource()) {
            tgt.setAdmitSource(VersionConvertor_30_50.convertCodeableConcept(src.getAdmitSource()));
        }
        if (src.hasReAdmission()) {
            tgt.setReAdmission(VersionConvertor_30_50.convertCodeableConcept(src.getReAdmission()));
        }
        for (CodeableConcept t : src.getDietPreference()) {
            tgt.addDietPreference(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getSpecialCourtesy()) {
            tgt.addSpecialCourtesy(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getSpecialArrangement()) {
            tgt.addSpecialArrangement(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_50.convertReference(src.getDestination()));
        }
        if (src.hasDischargeDisposition()) {
            tgt.setDischargeDisposition(VersionConvertor_30_50.convertCodeableConcept(src.getDischargeDisposition()));
        }
        return tgt;
    }

    public static Encounter.EncounterHospitalizationComponent convertEncounterHospitalizationComponent(Encounter.EncounterHospitalizationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterHospitalizationComponent tgt = new Encounter.EncounterHospitalizationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPreAdmissionIdentifier()) {
            tgt.setPreAdmissionIdentifier(VersionConvertor_30_50.convertIdentifier(src.getPreAdmissionIdentifier()));
        }
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_30_50.convertReference(src.getOrigin()));
        }
        if (src.hasAdmitSource()) {
            tgt.setAdmitSource(VersionConvertor_30_50.convertCodeableConcept(src.getAdmitSource()));
        }
        if (src.hasReAdmission()) {
            tgt.setReAdmission(VersionConvertor_30_50.convertCodeableConcept(src.getReAdmission()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept t : src.getDietPreference()) {
            tgt.addDietPreference(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept t : src.getSpecialCourtesy()) {
            tgt.addSpecialCourtesy(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept t : src.getSpecialArrangement()) {
            tgt.addSpecialArrangement(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_50.convertReference(src.getDestination()));
        }
        if (src.hasDischargeDisposition()) {
            tgt.setDischargeDisposition(VersionConvertor_30_50.convertCodeableConcept(src.getDischargeDisposition()));
        }
        return tgt;
    }

    public static Encounter.EncounterLocationComponent convertEncounterLocationComponent(Encounter.EncounterLocationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterLocationComponent tgt = new Encounter.EncounterLocationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_50.convertReference(src.getLocation()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Encounter30_50.convertEncounterLocationStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Encounter.EncounterLocationComponent convertEncounterLocationComponent(Encounter.EncounterLocationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterLocationComponent tgt = new Encounter.EncounterLocationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_50.convertReference(src.getLocation()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Encounter30_50.convertEncounterLocationStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<Encounter.EncounterLocationStatus> convertEncounterLocationStatus(org.hl7.fhir.dstu3.model.Enumeration<Encounter.EncounterLocationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Encounter.EncounterLocationStatus> tgt = new Enumeration<Encounter.EncounterLocationStatus>(new Encounter.EncounterLocationStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Encounter.EncounterLocationStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.PLANNED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.ACTIVE);
                break;
            }
            case RESERVED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.RESERVED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.COMPLETED);
                break;
            }
            default: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Encounter.EncounterLocationStatus> convertEncounterLocationStatus(Enumeration<Encounter.EncounterLocationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Encounter.EncounterLocationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Encounter.EncounterLocationStatus>(new Encounter.EncounterLocationStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Encounter.EncounterLocationStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.PLANNED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.ACTIVE);
                break;
            }
            case RESERVED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.RESERVED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.COMPLETED);
                break;
            }
            default: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Encounter.EncounterParticipantComponent convertEncounterParticipantComponent(Encounter.EncounterParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterParticipantComponent tgt = new Encounter.EncounterParticipantComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasIndividual()) {
            tgt.setIndividual(VersionConvertor_30_50.convertReference(src.getIndividual()));
        }
        return tgt;
    }

    public static Encounter.EncounterParticipantComponent convertEncounterParticipantComponent(Encounter.EncounterParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterParticipantComponent tgt = new Encounter.EncounterParticipantComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasIndividual()) {
            tgt.setIndividual(VersionConvertor_30_50.convertReference(src.getIndividual()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Encounter.EncounterStatus> convertEncounterStatus(Enumeration<Encounter.EncounterStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Encounter.EncounterStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Encounter.EncounterStatus>(new Encounter.EncounterStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Encounter.EncounterStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)Encounter.EncounterStatus.PLANNED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Encounter.EncounterStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Encounter.EncounterStatus.FINISHED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Encounter.EncounterStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Encounter.EncounterStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Encounter.EncounterStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Encounter.EncounterStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Encounter.EncounterStatus> convertEncounterStatus(org.hl7.fhir.dstu3.model.Enumeration<Encounter.EncounterStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Encounter.EncounterStatus> tgt = new Enumeration<Encounter.EncounterStatus>(new Encounter.EncounterStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Encounter.EncounterStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)Encounter.EncounterStatus.PLANNED);
                break;
            }
            case ARRIVED: {
                tgt.setValue((Object)Encounter.EncounterStatus.INPROGRESS);
                break;
            }
            case TRIAGED: {
                tgt.setValue((Object)Encounter.EncounterStatus.INPROGRESS);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Encounter.EncounterStatus.INPROGRESS);
                break;
            }
            case ONLEAVE: {
                tgt.setValue((Object)Encounter.EncounterStatus.INPROGRESS);
                break;
            }
            case FINISHED: {
                tgt.setValue((Object)Encounter.EncounterStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Encounter.EncounterStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Encounter.EncounterStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Encounter.EncounterStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Encounter.EncounterStatus.NULL);
            }
        }
        return tgt;
    }

    public static Encounter.StatusHistoryComponent convertStatusHistoryComponent(Encounter.StatusHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.StatusHistoryComponent tgt = new Encounter.StatusHistoryComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(Encounter30_50.convertEncounterStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Encounter.StatusHistoryComponent convertStatusHistoryComponent(Encounter.StatusHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.StatusHistoryComponent tgt = new Encounter.StatusHistoryComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(Encounter30_50.convertEncounterStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

