/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UsageContext;

public class CapabilityStatement30_50 {
    public static CapabilityStatement convertCapabilityStatement(org.hl7.fhir.dstu3.model.CapabilityStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement tgt = new CapabilityStatement();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu3.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(CapabilityStatement30_50.convertCapabilityStatementKind(src.getKindElement()));
        }
        for (UriType uriType : src.getInstantiates()) {
            tgt.addInstantiates((String)uriType.getValue());
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(CapabilityStatement30_50.convertCapabilityStatementSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(CapabilityStatement30_50.convertCapabilityStatementImplementationComponent(src.getImplementation()));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(Enumerations.FHIRVersion.fromCode(src.getFhirVersion()));
        }
        if (src.hasAcceptUnknown()) {
            tgt.addExtension().setUrl("http://hl7.org/fhir/3.0/StructureDefinition/extension-CapabilityStatement.acceptUnknown").setValue(new org.hl7.fhir.r5.model.CodeType(src.getAcceptUnknownElement().asStringValue()));
        }
        for (CodeType codeType : src.getFormat()) {
            tgt.addFormat((String)codeType.getValue());
        }
        for (CodeType codeType : src.getPatchFormat()) {
            tgt.addPatchFormat((String)codeType.getValue());
        }
        for (UriType uriType : src.getImplementationGuide()) {
            tgt.addImplementationGuide((String)uriType.getValue());
        }
        for (CapabilityStatement.CapabilityStatementRestComponent capabilityStatementRestComponent : src.getRest()) {
            tgt.addRest(CapabilityStatement30_50.convertCapabilityStatementRestComponent(capabilityStatementRestComponent));
        }
        for (Reference reference : src.getProfile()) {
            tgt.addExtension("http://hl7.org/fhir/3.0/StructureDefinition/extension-CapabilityStatement.profile", VersionConvertor_30_50.convertReference(reference));
        }
        for (CapabilityStatement.CapabilityStatementMessagingComponent capabilityStatementMessagingComponent : src.getMessaging()) {
            tgt.addMessaging(CapabilityStatement30_50.convertCapabilityStatementMessagingComponent(capabilityStatementMessagingComponent));
        }
        for (CapabilityStatement.CapabilityStatementDocumentComponent capabilityStatementDocumentComponent : src.getDocument()) {
            tgt.addDocument(CapabilityStatement30_50.convertCapabilityStatementDocumentComponent(capabilityStatementDocumentComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.CapabilityStatement convertCapabilityStatement(CapabilityStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.CapabilityStatement tgt = new org.hl7.fhir.dstu3.model.CapabilityStatement();
        VersionConvertor_30_50.copyDomainResource(src, tgt, "http://hl7.org/fhir/3.0/StructureDefinition/extension-CapabilityStatement.acceptUnknown", "http://hl7.org/fhir/3.0/StructureDefinition/extension-CapabilityStatement.profile");
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(CapabilityStatement30_50.convertCapabilityStatementKind(src.getKindElement()));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiates()) {
            tgt.addInstantiates((String)uriType.getValue());
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(CapabilityStatement30_50.convertCapabilityStatementSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(CapabilityStatement30_50.convertCapabilityStatementImplementationComponent(src.getImplementation()));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion().toCode());
        }
        if (src.hasExtension("http://hl7.org/fhir/3.0/StructureDefinition/extension-CapabilityStatement.acceptUnknown")) {
            tgt.setAcceptUnknown(CapabilityStatement.UnknownContentCode.fromCode(src.getExtensionByUrl("http://hl7.org/fhir/3.0/StructureDefinition/extension-CapabilityStatement.acceptUnknown").getValue().primitiveValue()));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getFormat()) {
            tgt.addFormat((String)codeType.getValue());
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getPatchFormat()) {
            tgt.addPatchFormat((String)codeType.getValue());
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getImplementationGuide()) {
            tgt.addImplementationGuide((String)uriType.getValue());
        }
        for (CapabilityStatement.CapabilityStatementRestComponent capabilityStatementRestComponent : src.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent rr : capabilityStatementRestComponent.getResource()) {
                for (CanonicalType t : rr.getSupportedProfile()) {
                    tgt.addProfile(VersionConvertor_30_50.convertCanonicalToReference(t));
                }
            }
        }
        for (Extension extension : src.getExtension()) {
            if (!"http://hl7.org/fhir/3.0/StructureDefinition/extension-CapabilityStatement.profile".equals(extension.getUrl())) continue;
            tgt.addProfile(VersionConvertor_30_50.convertReference((org.hl7.fhir.r5.model.Reference)extension.getValue()));
        }
        for (CapabilityStatement.CapabilityStatementRestComponent capabilityStatementRestComponent : src.getRest()) {
            tgt.addRest(CapabilityStatement30_50.convertCapabilityStatementRestComponent(capabilityStatementRestComponent));
        }
        for (CapabilityStatement.CapabilityStatementMessagingComponent capabilityStatementMessagingComponent : src.getMessaging()) {
            tgt.addMessaging(CapabilityStatement30_50.convertCapabilityStatementMessagingComponent(capabilityStatementMessagingComponent));
        }
        for (CapabilityStatement.CapabilityStatementDocumentComponent capabilityStatementDocumentComponent : src.getDocument()) {
            tgt.addDocument(CapabilityStatement30_50.convertCapabilityStatementDocumentComponent(capabilityStatementDocumentComponent));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementDocumentComponent convertCapabilityStatementDocumentComponent(CapabilityStatement.CapabilityStatementDocumentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementDocumentComponent tgt = new CapabilityStatement.CapabilityStatementDocumentComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement30_50.convertDocumentMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_30_50.convertReferenceToCanonical(src.getProfile()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementDocumentComponent convertCapabilityStatementDocumentComponent(CapabilityStatement.CapabilityStatementDocumentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementDocumentComponent tgt = new CapabilityStatement.CapabilityStatementDocumentComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement30_50.convertDocumentMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_50.convertCanonicalToReference(src.getProfileElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementImplementationComponent convertCapabilityStatementImplementationComponent(CapabilityStatement.CapabilityStatementImplementationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementImplementationComponent tgt = new CapabilityStatement.CapabilityStatementImplementationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementImplementationComponent convertCapabilityStatementImplementationComponent(CapabilityStatement.CapabilityStatementImplementationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementImplementationComponent tgt = new CapabilityStatement.CapabilityStatementImplementationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.CapabilityStatementKind> convertCapabilityStatementKind(org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.CapabilityStatementKind> tgt = new Enumeration<CapabilityStatement.CapabilityStatementKind>(new CapabilityStatement.CapabilityStatementKindEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.CapabilityStatementKind)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.INSTANCE);
                break;
            }
            case CAPABILITY: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.CAPABILITY);
                break;
            }
            case REQUIREMENTS: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.REQUIREMENTS);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind> convertCapabilityStatementKind(Enumeration<CapabilityStatement.CapabilityStatementKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind>(new Enumerations.CapabilityStatementKindEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.CapabilityStatementKind)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.INSTANCE);
                break;
            }
            case CAPABILITY: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.CAPABILITY);
                break;
            }
            case REQUIREMENTS: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.REQUIREMENTS);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingComponent convertCapabilityStatementMessagingComponent(CapabilityStatement.CapabilityStatementMessagingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingComponent tgt = new CapabilityStatement.CapabilityStatementMessagingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent capabilityStatementMessagingEndpointComponent : src.getEndpoint()) {
            tgt.addEndpoint(CapabilityStatement30_50.convertCapabilityStatementMessagingEndpointComponent(capabilityStatementMessagingEndpointComponent));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCacheElement(VersionConvertor_30_50.convertUnsignedInt(src.getReliableCacheElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        for (CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent capabilityStatementMessagingSupportedMessageComponent : src.getSupportedMessage()) {
            tgt.addSupportedMessage(CapabilityStatement30_50.convertCapabilityStatementMessagingSupportedMessageComponent(capabilityStatementMessagingSupportedMessageComponent));
        }
        for (Extension extension : src.getExtensionsByUrl("http://hl7.org/fhir/1.0/StructureDefinition/extension-Conformance.messaging.event")) {
            CapabilityStatement.CapabilityStatementMessagingEventComponent event = new CapabilityStatement.CapabilityStatementMessagingEventComponent();
            tgt.addEvent(event);
            event.setCode(VersionConvertor_30_50.convertCoding((Coding)extension.getExtensionByUrl("code").getValue()));
            if (extension.hasExtension("category")) {
                event.setCategory(CapabilityStatement.MessageSignificanceCategory.fromCode(extension.getExtensionByUrl("category").getValue().toString()));
            }
            event.setMode(CapabilityStatement.EventCapabilityMode.fromCode(extension.getExtensionByUrl("mode").getValue().toString()));
            Extension focusE = extension.getExtensionByUrl("focus");
            if (focusE.getValue().hasPrimitiveValue()) {
                event.setFocus(focusE.getValue().toString());
            } else {
                event.setFocusElement(new CodeType());
                VersionConvertor_30_50.copyElement(focusE.getValue(), event.getFocusElement(), new String[0]);
            }
            event.setRequest(VersionConvertor_30_50.convertReference((org.hl7.fhir.r5.model.Reference)extension.getExtensionByUrl("request").getValue()));
            event.setResponse(VersionConvertor_30_50.convertReference((org.hl7.fhir.r5.model.Reference)extension.getExtensionByUrl("response").getValue()));
            if (!extension.hasExtension("documentation")) continue;
            event.setDocumentation(extension.getExtensionByUrl("documentation").getValue().toString());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingComponent convertCapabilityStatementMessagingComponent(CapabilityStatement.CapabilityStatementMessagingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingComponent tgt = new CapabilityStatement.CapabilityStatementMessagingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent capabilityStatementMessagingEndpointComponent : src.getEndpoint()) {
            tgt.addEndpoint(CapabilityStatement30_50.convertCapabilityStatementMessagingEndpointComponent(capabilityStatementMessagingEndpointComponent));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCacheElement(VersionConvertor_30_50.convertUnsignedInt(src.getReliableCacheElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        for (CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent capabilityStatementMessagingSupportedMessageComponent : src.getSupportedMessage()) {
            tgt.addSupportedMessage(CapabilityStatement30_50.convertCapabilityStatementMessagingSupportedMessageComponent(capabilityStatementMessagingSupportedMessageComponent));
        }
        for (CapabilityStatement.CapabilityStatementMessagingEventComponent capabilityStatementMessagingEventComponent : src.getEvent()) {
            Extension e = new Extension("http://hl7.org/fhir/1.0/StructureDefinition/extension-Conformance.messaging.event");
            e.addExtension(new Extension("code", VersionConvertor_30_50.convertCoding(capabilityStatementMessagingEventComponent.getCode())));
            if (capabilityStatementMessagingEventComponent.hasCategory()) {
                e.addExtension(new Extension("category", new org.hl7.fhir.r5.model.CodeType(capabilityStatementMessagingEventComponent.getCategory().toCode())));
            }
            e.addExtension(new Extension("mode", new org.hl7.fhir.r5.model.CodeType(capabilityStatementMessagingEventComponent.getMode().toCode())));
            if (capabilityStatementMessagingEventComponent.getFocusElement().hasValue()) {
                e.addExtension(new Extension("focus", new StringType(capabilityStatementMessagingEventComponent.getFocus())));
            } else {
                org.hl7.fhir.r5.model.CodeType focus = new org.hl7.fhir.r5.model.CodeType();
                Extension focusE = new Extension("focus", focus);
                VersionConvertor_30_50.copyElement(capabilityStatementMessagingEventComponent.getFocusElement(), focus, new String[0]);
                e.addExtension(focusE);
            }
            e.addExtension(new Extension("request", VersionConvertor_30_50.convertReference(capabilityStatementMessagingEventComponent.getRequest())));
            e.addExtension(new Extension("response", VersionConvertor_30_50.convertReference(capabilityStatementMessagingEventComponent.getResponse())));
            if (capabilityStatementMessagingEventComponent.hasDocumentation()) {
                e.addExtension(new Extension("documentation", new StringType(capabilityStatementMessagingEventComponent.getDocumentation())));
            }
            tgt.addExtension(e);
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingEndpointComponent convertCapabilityStatementMessagingEndpointComponent(CapabilityStatement.CapabilityStatementMessagingEndpointComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent tgt = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasProtocol()) {
            tgt.setProtocol(VersionConvertor_30_50.convertCoding(src.getProtocol()));
        }
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingEndpointComponent convertCapabilityStatementMessagingEndpointComponent(CapabilityStatement.CapabilityStatementMessagingEndpointComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent tgt = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasProtocol()) {
            tgt.setProtocol(VersionConvertor_30_50.convertCoding(src.getProtocol()));
        }
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent convertCapabilityStatementMessagingSupportedMessageComponent(CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent tgt = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement30_50.convertEventCapabilityMode(src.getModeElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(VersionConvertor_30_50.convertCanonicalToReference(src.getDefinitionElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent convertCapabilityStatementMessagingSupportedMessageComponent(CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent tgt = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement30_50.convertEventCapabilityMode(src.getModeElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_50.convertReferenceToCanonical(src.getDefinition()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestComponent convertCapabilityStatementRestComponent(CapabilityStatement.CapabilityStatementRestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestComponent tgt = new CapabilityStatement.CapabilityStatementRestComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement30_50.convertRestfulCapabilityMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasSecurity()) {
            tgt.setSecurity(CapabilityStatement30_50.convertCapabilityStatementRestSecurityComponent(src.getSecurity()));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent capabilityStatementRestResourceComponent : src.getResource()) {
            tgt.addResource(CapabilityStatement30_50.convertCapabilityStatementRestResourceComponent(capabilityStatementRestResourceComponent));
        }
        for (CapabilityStatement.SystemInteractionComponent systemInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(CapabilityStatement30_50.convertSystemInteractionComponent(systemInteractionComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(CapabilityStatement30_50.convertCapabilityStatementRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent capabilityStatementRestResourceOperationComponent : src.getOperation()) {
            tgt.addOperation(CapabilityStatement30_50.convertCapabilityStatementRestOperationComponent(capabilityStatementRestResourceOperationComponent));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getCompartment()) {
            tgt.addCompartment((String)uriType.getValue());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestComponent convertCapabilityStatementRestComponent(CapabilityStatement.CapabilityStatementRestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestComponent tgt = new CapabilityStatement.CapabilityStatementRestComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement30_50.convertRestfulCapabilityMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasSecurity()) {
            tgt.setSecurity(CapabilityStatement30_50.convertCapabilityStatementRestSecurityComponent(src.getSecurity()));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent capabilityStatementRestResourceComponent : src.getResource()) {
            tgt.addResource(CapabilityStatement30_50.convertCapabilityStatementRestResourceComponent(capabilityStatementRestResourceComponent));
        }
        for (CapabilityStatement.SystemInteractionComponent systemInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(CapabilityStatement30_50.convertSystemInteractionComponent(systemInteractionComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(CapabilityStatement30_50.convertCapabilityStatementRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestOperationComponent capabilityStatementRestOperationComponent : src.getOperation()) {
            tgt.addOperation(CapabilityStatement30_50.convertCapabilityStatementRestOperationComponent(capabilityStatementRestOperationComponent));
        }
        for (UriType uriType : src.getCompartment()) {
            tgt.addCompartment((String)uriType.getValue());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestOperationComponent convertCapabilityStatementRestOperationComponent(CapabilityStatement.CapabilityStatementRestResourceOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestOperationComponent tgt = new CapabilityStatement.CapabilityStatementRestOperationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(VersionConvertor_30_50.convertCanonicalToReference(src.getDefinitionElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceOperationComponent convertCapabilityStatementRestOperationComponent(CapabilityStatement.CapabilityStatementRestOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_50.convertReferenceToCanonical(src.getDefinition()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceComponent convertCapabilityStatementRestResourceComponent(CapabilityStatement.CapabilityStatementRestResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_50.convertCanonicalToReference(src.getProfileElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertMarkdown(src.getDocumentationElement()));
        }
        for (CapabilityStatement.ResourceInteractionComponent resourceInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(CapabilityStatement30_50.convertResourceInteractionComponent(resourceInteractionComponent));
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(CapabilityStatement30_50.convertResourceVersionPolicy(src.getVersioningElement()));
        }
        if (src.hasReadHistory()) {
            tgt.setReadHistoryElement(VersionConvertor_30_50.convertBoolean(src.getReadHistoryElement()));
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreateElement(VersionConvertor_30_50.convertBoolean(src.getUpdateCreateElement()));
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreateElement(VersionConvertor_30_50.convertBoolean(src.getConditionalCreateElement()));
        }
        if (src.hasConditionalRead()) {
            tgt.setConditionalReadElement(CapabilityStatement30_50.convertConditionalReadStatus(src.getConditionalReadElement()));
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdateElement(VersionConvertor_30_50.convertBoolean(src.getConditionalUpdateElement()));
        }
        if (src.hasConditionalDelete()) {
            tgt.setConditionalDeleteElement(CapabilityStatement30_50.convertConditionalDeleteStatus(src.getConditionalDeleteElement()));
        }
        tgt.setReferencePolicy(src.getReferencePolicy().stream().map(CapabilityStatement30_50::convertReferenceHandlingPolicy).collect(Collectors.toList()));
        for (StringType stringType : src.getSearchInclude()) {
            tgt.addSearchInclude((String)stringType.getValue());
        }
        for (StringType stringType : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)stringType.getValue());
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(CapabilityStatement30_50.convertCapabilityStatementRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceComponent convertCapabilityStatementRestResourceComponent(CapabilityStatement.CapabilityStatementRestResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_30_50.convertReferenceToCanonical(src.getProfile()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertMarkdown(src.getDocumentationElement()));
        }
        for (CapabilityStatement.ResourceInteractionComponent resourceInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(CapabilityStatement30_50.convertResourceInteractionComponent(resourceInteractionComponent));
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(CapabilityStatement30_50.convertResourceVersionPolicy(src.getVersioningElement()));
        }
        if (src.hasReadHistory()) {
            tgt.setReadHistoryElement(VersionConvertor_30_50.convertBoolean(src.getReadHistoryElement()));
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreateElement(VersionConvertor_30_50.convertBoolean(src.getUpdateCreateElement()));
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreateElement(VersionConvertor_30_50.convertBoolean(src.getConditionalCreateElement()));
        }
        if (src.hasConditionalRead()) {
            tgt.setConditionalReadElement(CapabilityStatement30_50.convertConditionalReadStatus(src.getConditionalReadElement()));
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdateElement(VersionConvertor_30_50.convertBoolean(src.getConditionalUpdateElement()));
        }
        if (src.hasConditionalDelete()) {
            tgt.setConditionalDeleteElement(CapabilityStatement30_50.convertConditionalDeleteStatus(src.getConditionalDeleteElement()));
        }
        tgt.setReferencePolicy(src.getReferencePolicy().stream().map(CapabilityStatement30_50::convertReferenceHandlingPolicy).collect(Collectors.toList()));
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getSearchInclude()) {
            tgt.addSearchInclude((String)stringType.getValue());
        }
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)stringType.getValue());
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(CapabilityStatement30_50.convertCapabilityStatementRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent convertCapabilityStatementRestResourceSearchParamComponent(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent convertCapabilityStatementRestResourceSearchParamComponent(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestSecurityComponent convertCapabilityStatementRestSecurityComponent(CapabilityStatement.CapabilityStatementRestSecurityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestSecurityComponent tgt = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCors()) {
            tgt.setCorsElement(VersionConvertor_30_50.convertBoolean(src.getCorsElement()));
        }
        for (CodeableConcept t : src.getService()) {
            tgt.addService(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestSecurityComponent convertCapabilityStatementRestSecurityComponent(CapabilityStatement.CapabilityStatementRestSecurityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestSecurityComponent tgt = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCors()) {
            tgt.setCorsElement(VersionConvertor_30_50.convertBoolean(src.getCorsElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept t : src.getService()) {
            tgt.addService(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementSoftwareComponent convertCapabilityStatementSoftwareComponent(CapabilityStatement.CapabilityStatementSoftwareComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementSoftwareComponent tgt = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDateElement(VersionConvertor_30_50.convertDateTime(src.getReleaseDateElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementSoftwareComponent convertCapabilityStatementSoftwareComponent(CapabilityStatement.CapabilityStatementSoftwareComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementSoftwareComponent tgt = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDateElement(VersionConvertor_30_50.convertDateTime(src.getReleaseDateElement()));
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.ConditionalDeleteStatus> convertConditionalDeleteStatus(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.ConditionalDeleteStatus> tgt = new Enumeration<CapabilityStatement.ConditionalDeleteStatus>(new CapabilityStatement.ConditionalDeleteStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ConditionalDeleteStatus)((Object)src.getValue())) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NOTSUPPORTED);
                break;
            }
            case SINGLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus> convertConditionalDeleteStatus(Enumeration<CapabilityStatement.ConditionalDeleteStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus>(new CapabilityStatement.ConditionalDeleteStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ConditionalDeleteStatus)((Object)src.getValue())) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NOTSUPPORTED);
                break;
            }
            case SINGLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.ConditionalReadStatus> convertConditionalReadStatus(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalReadStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.ConditionalReadStatus> tgt = new Enumeration<CapabilityStatement.ConditionalReadStatus>(new CapabilityStatement.ConditionalReadStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ConditionalReadStatus)((Object)src.getValue())) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NOTSUPPORTED);
                break;
            }
            case MODIFIEDSINCE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.MODIFIEDSINCE);
                break;
            }
            case NOTMATCH: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NOTMATCH);
                break;
            }
            case FULLSUPPORT: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.FULLSUPPORT);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalReadStatus> convertConditionalReadStatus(Enumeration<CapabilityStatement.ConditionalReadStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalReadStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalReadStatus>(new CapabilityStatement.ConditionalReadStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ConditionalReadStatus)((Object)src.getValue())) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NOTSUPPORTED);
                break;
            }
            case MODIFIEDSINCE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.MODIFIEDSINCE);
                break;
            }
            case NOTMATCH: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NOTMATCH);
                break;
            }
            case FULLSUPPORT: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.FULLSUPPORT);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.DocumentMode> convertDocumentMode(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.DocumentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.DocumentMode> tgt = new Enumeration<CapabilityStatement.DocumentMode>(new CapabilityStatement.DocumentModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.DocumentMode)((Object)src.getValue())) {
            case PRODUCER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.PRODUCER);
                break;
            }
            case CONSUMER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.CONSUMER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.DocumentMode> convertDocumentMode(Enumeration<CapabilityStatement.DocumentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.DocumentMode> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.DocumentMode>(new CapabilityStatement.DocumentModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.DocumentMode)((Object)src.getValue())) {
            case PRODUCER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.PRODUCER);
                break;
            }
            case CONSUMER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.CONSUMER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode> convertEventCapabilityMode(Enumeration<CapabilityStatement.EventCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode>(new CapabilityStatement.EventCapabilityModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.EventCapabilityMode)((Object)src.getValue())) {
            case SENDER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.SENDER);
                break;
            }
            case RECEIVER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.RECEIVER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.EventCapabilityMode> convertEventCapabilityMode(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.EventCapabilityMode> tgt = new Enumeration<CapabilityStatement.EventCapabilityMode>(new CapabilityStatement.EventCapabilityModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.EventCapabilityMode)((Object)src.getValue())) {
            case SENDER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.SENDER);
                break;
            }
            case RECEIVER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.RECEIVER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.ReferenceHandlingPolicy> convertReferenceHandlingPolicy(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ReferenceHandlingPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.ReferenceHandlingPolicy> tgt = new Enumeration<CapabilityStatement.ReferenceHandlingPolicy>(new CapabilityStatement.ReferenceHandlingPolicyEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ReferenceHandlingPolicy)((Object)src.getValue())) {
            case LITERAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LITERAL);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LOGICAL);
                break;
            }
            case RESOLVES: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.RESOLVES);
                break;
            }
            case ENFORCED: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.ENFORCED);
                break;
            }
            case LOCAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LOCAL);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ReferenceHandlingPolicy> convertReferenceHandlingPolicy(Enumeration<CapabilityStatement.ReferenceHandlingPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ReferenceHandlingPolicy> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ReferenceHandlingPolicy>(new CapabilityStatement.ReferenceHandlingPolicyEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ReferenceHandlingPolicy)((Object)src.getValue())) {
            case LITERAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LITERAL);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LOGICAL);
                break;
            }
            case RESOLVES: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.RESOLVES);
                break;
            }
            case ENFORCED: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.ENFORCED);
                break;
            }
            case LOCAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LOCAL);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement.ResourceInteractionComponent convertResourceInteractionComponent(CapabilityStatement.ResourceInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.ResourceInteractionComponent tgt = new CapabilityStatement.ResourceInteractionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CapabilityStatement30_50.convertTypeRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.ResourceInteractionComponent convertResourceInteractionComponent(CapabilityStatement.ResourceInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.ResourceInteractionComponent tgt = new CapabilityStatement.ResourceInteractionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CapabilityStatement30_50.convertTypeRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ResourceVersionPolicy> convertResourceVersionPolicy(Enumeration<CapabilityStatement.ResourceVersionPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ResourceVersionPolicy> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ResourceVersionPolicy>(new CapabilityStatement.ResourceVersionPolicyEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ResourceVersionPolicy)((Object)src.getValue())) {
            case NOVERSION: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NOVERSION);
                break;
            }
            case VERSIONED: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONED);
                break;
            }
            case VERSIONEDUPDATE: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.ResourceVersionPolicy> convertResourceVersionPolicy(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ResourceVersionPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.ResourceVersionPolicy> tgt = new Enumeration<CapabilityStatement.ResourceVersionPolicy>(new CapabilityStatement.ResourceVersionPolicyEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ResourceVersionPolicy)((Object)src.getValue())) {
            case NOVERSION: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NOVERSION);
                break;
            }
            case VERSIONED: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONED);
                break;
            }
            case VERSIONEDUPDATE: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.RestfulCapabilityMode> convertRestfulCapabilityMode(org.hl7.fhir.r5.model.Enumeration<Enumerations.RestfulCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.RestfulCapabilityMode> tgt = new Enumeration<CapabilityStatement.RestfulCapabilityMode>(new CapabilityStatement.RestfulCapabilityModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RestfulCapabilityMode)((Object)src.getValue())) {
            case CLIENT: {
                tgt.setValue((Object)CapabilityStatement.RestfulCapabilityMode.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)CapabilityStatement.RestfulCapabilityMode.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.RestfulCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RestfulCapabilityMode> convertRestfulCapabilityMode(Enumeration<CapabilityStatement.RestfulCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RestfulCapabilityMode> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RestfulCapabilityMode>(new Enumerations.RestfulCapabilityModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.RestfulCapabilityMode)((Object)src.getValue())) {
            case CLIENT: {
                tgt.setValue((Object)Enumerations.RestfulCapabilityMode.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)Enumerations.RestfulCapabilityMode.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RestfulCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement.SystemInteractionComponent convertSystemInteractionComponent(CapabilityStatement.SystemInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.SystemInteractionComponent tgt = new CapabilityStatement.SystemInteractionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CapabilityStatement30_50.convertSystemRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.SystemInteractionComponent convertSystemInteractionComponent(CapabilityStatement.SystemInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.SystemInteractionComponent tgt = new CapabilityStatement.SystemInteractionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CapabilityStatement30_50.convertSystemRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.SystemRestfulInteraction> convertSystemRestfulInteraction(Enumeration<CapabilityStatement.SystemRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.SystemRestfulInteraction> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.SystemRestfulInteraction>(new CapabilityStatement.SystemRestfulInteractionEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.SystemRestfulInteraction)((Object)src.getValue())) {
            case TRANSACTION: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.TRANSACTION);
                break;
            }
            case BATCH: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.BATCH);
                break;
            }
            case SEARCHSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM);
                break;
            }
            case HISTORYSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.SystemRestfulInteraction> convertSystemRestfulInteraction(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.SystemRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.SystemRestfulInteraction> tgt = new Enumeration<CapabilityStatement.SystemRestfulInteraction>(new CapabilityStatement.SystemRestfulInteractionEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.SystemRestfulInteraction)((Object)src.getValue())) {
            case TRANSACTION: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.TRANSACTION);
                break;
            }
            case BATCH: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.BATCH);
                break;
            }
            case SEARCHSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM);
                break;
            }
            case HISTORYSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.TypeRestfulInteraction> convertTypeRestfulInteraction(Enumeration<CapabilityStatement.TypeRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.TypeRestfulInteraction> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.TypeRestfulInteraction>(new CapabilityStatement.TypeRestfulInteractionEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.TypeRestfulInteraction)((Object)src.getValue())) {
            case READ: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.READ);
                break;
            }
            case VREAD: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.VREAD);
                break;
            }
            case UPDATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.UPDATE);
                break;
            }
            case PATCH: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.PATCH);
                break;
            }
            case DELETE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.DELETE);
                break;
            }
            case HISTORYINSTANCE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE);
                break;
            }
            case HISTORYTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE);
                break;
            }
            case CREATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.CREATE);
                break;
            }
            case SEARCHTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.TypeRestfulInteraction> convertTypeRestfulInteraction(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.TypeRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.TypeRestfulInteraction> tgt = new Enumeration<CapabilityStatement.TypeRestfulInteraction>(new CapabilityStatement.TypeRestfulInteractionEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.TypeRestfulInteraction)((Object)src.getValue())) {
            case READ: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.READ);
                break;
            }
            case VREAD: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.VREAD);
                break;
            }
            case UPDATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.UPDATE);
                break;
            }
            case PATCH: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.PATCH);
                break;
            }
            case DELETE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.DELETE);
                break;
            }
            case HISTORYINSTANCE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE);
                break;
            }
            case HISTORYTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE);
                break;
            }
            case CREATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.CREATE);
                break;
            }
            case SEARCHTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.NULL);
            }
        }
        return tgt;
    }
}

