/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumeration;

public class AuditEvent30_50 {
    public static AuditEvent convertAuditEvent(org.hl7.fhir.dstu3.model.AuditEvent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent tgt = new AuditEvent();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCoding(src.getType()));
        }
        for (org.hl7.fhir.dstu3.model.Coding coding : src.getSubtype()) {
            tgt.addSubtype(VersionConvertor_30_50.convertCoding(coding));
        }
        if (src.hasAction()) {
            tgt.setActionElement(AuditEvent30_50.convertAuditEventAction(src.getActionElement()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(VersionConvertor_30_50.convertInstant(src.getRecordedElement()));
        }
        if (src.hasOutcome()) {
            tgt.getOutcome().addCoding().setSystem("http://terminology.hl7.org/CodeSystem/audit-event-outcome").setCode(src.getOutcome().toCode());
        }
        if (src.hasOutcomeDesc()) {
            tgt.getOutcome().setTextElement(VersionConvertor_30_50.convertString(src.getOutcomeDescElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getPurposeOfEvent()) {
            tgt.addPurposeOfEvent(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (AuditEvent.AuditEventAgentComponent auditEventAgentComponent : src.getAgent()) {
            tgt.addAgent(AuditEvent30_50.convertAuditEventAgentComponent(auditEventAgentComponent));
        }
        if (src.hasSource()) {
            tgt.setSource(AuditEvent30_50.convertAuditEventSourceComponent(src.getSource()));
        }
        for (AuditEvent.AuditEventEntityComponent auditEventEntityComponent : src.getEntity()) {
            tgt.addEntity(AuditEvent30_50.convertAuditEventEntityComponent(auditEventEntityComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.AuditEvent convertAuditEvent(AuditEvent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.AuditEvent tgt = new org.hl7.fhir.dstu3.model.AuditEvent();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCoding(src.getType()));
        }
        for (Coding coding : src.getSubtype()) {
            tgt.addSubtype(VersionConvertor_30_50.convertCoding(coding));
        }
        if (src.hasAction()) {
            tgt.setActionElement(AuditEvent30_50.convertAuditEventAction(src.getActionElement()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(VersionConvertor_30_50.convertInstant(src.getRecordedElement()));
        }
        if (src.hasOutcome() && src.getOutcome().hasCoding("http://terminology.hl7.org/CodeSystem/audit-event-outcome")) {
            tgt.getOutcomeElement().setValueAsString(src.getOutcome().getCode("http://terminology.hl7.org/CodeSystem/audit-event-outcome"));
        }
        if (src.getOutcome().hasText()) {
            tgt.setOutcomeDescElement(VersionConvertor_30_50.convertString(src.getOutcome().getTextElement()));
        }
        for (CodeableConcept codeableConcept : src.getPurposeOfEvent()) {
            tgt.addPurposeOfEvent(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (AuditEvent.AuditEventAgentComponent auditEventAgentComponent : src.getAgent()) {
            tgt.addAgent(AuditEvent30_50.convertAuditEventAgentComponent(auditEventAgentComponent));
        }
        if (src.hasSource()) {
            tgt.setSource(AuditEvent30_50.convertAuditEventSourceComponent(src.getSource()));
        }
        for (AuditEvent.AuditEventEntityComponent auditEventEntityComponent : src.getEntity()) {
            tgt.addEntity(AuditEvent30_50.convertAuditEventEntityComponent(auditEventEntityComponent));
        }
        return tgt;
    }

    public static Enumeration<AuditEvent.AuditEventAction> convertAuditEventAction(org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AuditEvent.AuditEventAction> tgt = new Enumeration<AuditEvent.AuditEventAction>(new AuditEvent.AuditEventActionEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((AuditEvent.AuditEventAction)((Object)src.getValue())) {
            case C: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.C);
                break;
            }
            case R: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.R);
                break;
            }
            case U: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.U);
                break;
            }
            case D: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.D);
                break;
            }
            case E: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.E);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAction> convertAuditEventAction(Enumeration<AuditEvent.AuditEventAction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAction> tgt = new org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAction>(new AuditEvent.AuditEventActionEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((AuditEvent.AuditEventAction)((Object)src.getValue())) {
            case C: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.C);
                break;
            }
            case R: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.R);
                break;
            }
            case U: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.U);
                break;
            }
            case D: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.D);
                break;
            }
            case E: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.E);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventAction.NULL);
            }
        }
        return tgt;
    }

    public static AuditEvent.AuditEventAgentComponent convertAuditEventAgentComponent(AuditEvent.AuditEventAgentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventAgentComponent tgt = new AuditEvent.AuditEventAgentComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getRole()) {
            tgt.addRole(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasReference()) {
            tgt.setWho(VersionConvertor_30_50.convertReference(src.getReference()));
        }
        if (src.hasUserId()) {
            tgt.getWho().setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getUserId()));
        }
        if (src.hasAltId()) {
            tgt.setAltIdElement(VersionConvertor_30_50.convertString(src.getAltIdElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasRequestor()) {
            tgt.setRequestorElement(VersionConvertor_30_50.convertBoolean(src.getRequestorElement()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_50.convertReference(src.getLocation()));
        }
        for (UriType uriType : src.getPolicy()) {
            tgt.addPolicy((String)uriType.getValue());
        }
        if (src.hasMedia()) {
            tgt.setMedia(VersionConvertor_30_50.convertCoding(src.getMedia()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(AuditEvent30_50.convertAuditEventAgentNetworkComponent(src.getNetwork()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getPurposeOfUse()) {
            tgt.addPurposeOfUse(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventAgentComponent convertAuditEventAgentComponent(AuditEvent.AuditEventAgentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventAgentComponent tgt = new AuditEvent.AuditEventAgentComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getRole()) {
            tgt.addRole(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasWho()) {
            if (src.getWho().hasIdentifier()) {
                tgt.setUserId(VersionConvertor_30_50.convertIdentifier(src.getWho().getIdentifier()));
            }
            if (src.getWho().hasReference() || src.getWho().hasDisplay() || src.getWho().hasExtension() || src.getWho().hasId()) {
                tgt.setReference(VersionConvertor_30_50.convertReference(src.getWho()));
            }
        }
        if (src.hasAltId()) {
            tgt.setAltIdElement(VersionConvertor_30_50.convertString(src.getAltIdElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasRequestor()) {
            tgt.setRequestorElement(VersionConvertor_30_50.convertBoolean(src.getRequestorElement()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_50.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getPolicy()) {
            tgt.addPolicy((String)uriType.getValue());
        }
        if (src.hasMedia()) {
            tgt.setMedia(VersionConvertor_30_50.convertCoding(src.getMedia()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(AuditEvent30_50.convertAuditEventAgentNetworkComponent(src.getNetwork()));
        }
        for (CodeableConcept codeableConcept : src.getPurposeOfUse()) {
            tgt.addPurposeOfUse(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventAgentNetworkComponent convertAuditEventAgentNetworkComponent(AuditEvent.AuditEventAgentNetworkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventAgentNetworkComponent tgt = new AuditEvent.AuditEventAgentNetworkComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasAddress()) {
            tgt.setAddressElement(VersionConvertor_30_50.convertString(src.getAddressElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(AuditEvent30_50.convertAuditEventAgentNetworkType(src.getTypeElement()));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventAgentNetworkComponent convertAuditEventAgentNetworkComponent(AuditEvent.AuditEventAgentNetworkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventAgentNetworkComponent tgt = new AuditEvent.AuditEventAgentNetworkComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasAddress()) {
            tgt.setAddressElement(VersionConvertor_30_50.convertString(src.getAddressElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(AuditEvent30_50.convertAuditEventAgentNetworkType(src.getTypeElement()));
        }
        return tgt;
    }

    public static Enumeration<AuditEvent.AuditEventAgentNetworkType> convertAuditEventAgentNetworkType(org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAgentNetworkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AuditEvent.AuditEventAgentNetworkType> tgt = new Enumeration<AuditEvent.AuditEventAgentNetworkType>(new AuditEvent.AuditEventAgentNetworkTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((AuditEvent.AuditEventAgentNetworkType)((Object)src.getValue())) {
            case _1: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._1);
                break;
            }
            case _2: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._2);
                break;
            }
            case _3: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._3);
                break;
            }
            case _4: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._4);
                break;
            }
            case _5: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._5);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAgentNetworkType> convertAuditEventAgentNetworkType(Enumeration<AuditEvent.AuditEventAgentNetworkType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAgentNetworkType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<AuditEvent.AuditEventAgentNetworkType>(new AuditEvent.AuditEventAgentNetworkTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((AuditEvent.AuditEventAgentNetworkType)((Object)src.getValue())) {
            case _1: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._1);
                break;
            }
            case _2: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._2);
                break;
            }
            case _3: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._3);
                break;
            }
            case _4: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._4);
                break;
            }
            case _5: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType._5);
                break;
            }
            default: {
                tgt.setValue((Object)AuditEvent.AuditEventAgentNetworkType.NULL);
            }
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityComponent convertAuditEventEntityComponent(AuditEvent.AuditEventEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventEntityComponent tgt = new AuditEvent.AuditEventEntityComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.getWhat().setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasReference()) {
            tgt.setWhat(VersionConvertor_30_50.convertReference(src.getReference()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCoding(src.getType()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_50.convertCoding(src.getRole()));
        }
        if (src.hasLifecycle()) {
            tgt.setLifecycle(VersionConvertor_30_50.convertCoding(src.getLifecycle()));
        }
        for (org.hl7.fhir.dstu3.model.Coding coding : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_30_50.convertCoding(coding));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasQuery()) {
            tgt.setQueryElement(VersionConvertor_30_50.convertBase64Binary(src.getQueryElement()));
        }
        for (AuditEvent.AuditEventEntityDetailComponent auditEventEntityDetailComponent : src.getDetail()) {
            tgt.addDetail(AuditEvent30_50.convertAuditEventEntityDetailComponent(auditEventEntityDetailComponent));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityComponent convertAuditEventEntityComponent(AuditEvent.AuditEventEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventEntityComponent tgt = new AuditEvent.AuditEventEntityComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasWhat()) {
            if (src.getWhat().hasIdentifier()) {
                tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getWhat().getIdentifier()));
            }
            if (src.getWhat().hasReference() || src.getWhat().hasDisplay() || src.getWhat().hasExtension() || src.getWhat().hasId()) {
                tgt.setReference(VersionConvertor_30_50.convertReference(src.getWhat()));
            }
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCoding(src.getType()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_50.convertCoding(src.getRole()));
        }
        if (src.hasLifecycle()) {
            tgt.setLifecycle(VersionConvertor_30_50.convertCoding(src.getLifecycle()));
        }
        for (Coding coding : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_30_50.convertCoding(coding));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasQuery()) {
            tgt.setQueryElement(VersionConvertor_30_50.convertBase64Binary(src.getQueryElement()));
        }
        for (AuditEvent.AuditEventEntityDetailComponent auditEventEntityDetailComponent : src.getDetail()) {
            tgt.addDetail(AuditEvent30_50.convertAuditEventEntityDetailComponent(auditEventEntityDetailComponent));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityDetailComponent convertAuditEventEntityDetailComponent(AuditEvent.AuditEventEntityDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventEntityDetailComponent tgt = new AuditEvent.AuditEventEntityDetailComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertString(src.getTypeElement()));
        }
        if (src.hasValueStringType()) {
            tgt.setValue(((String)src.getValueStringType().getValue()).getBytes());
        } else if (src.hasValueBase64BinaryType()) {
            tgt.setValue(src.getValueBase64BinaryType().getValue());
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityDetailComponent convertAuditEventEntityDetailComponent(AuditEvent.AuditEventEntityDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventEntityDetailComponent tgt = new AuditEvent.AuditEventEntityDetailComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertString(src.getTypeElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(new Base64BinaryType(src.getValue()));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventSourceComponent convertAuditEventSourceComponent(AuditEvent.AuditEventSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventSourceComponent tgt = new AuditEvent.AuditEventSourceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSite()) {
            tgt.setSiteElement(VersionConvertor_30_50.convertString(src.getSiteElement()));
        }
        if (src.hasObserver()) {
            tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getObserver().getIdentifier()));
        }
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCoding(t));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventSourceComponent convertAuditEventSourceComponent(AuditEvent.AuditEventSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventSourceComponent tgt = new AuditEvent.AuditEventSourceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSite()) {
            tgt.setSiteElement(VersionConvertor_30_50.convertString(src.getSiteElement()));
        }
        if (src.hasIdentifier()) {
            tgt.getObserver().setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        for (org.hl7.fhir.dstu3.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCoding(t));
        }
        return tgt;
    }
}

