/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Contributor;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;

public class ActivityDefinition30_50 {
    public static org.hl7.fhir.r5.model.ActivityDefinition convertActivityDefinition(ActivityDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ActivityDefinition tgt = new org.hl7.fhir.r5.model.ActivityDefinition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(VersionConvertor_30_50.convertString(src.getUsageElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(VersionConvertor_30_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(VersionConvertor_30_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (Contributor contributor : src.getContributor()) {
            if (contributor.getType() == Contributor.ContributorType.AUTHOR) {
                for (org.hl7.fhir.dstu3.model.ContactDetail c : contributor.getContact()) {
                    tgt.addAuthor(VersionConvertor_30_50.convertContactDetail(c));
                }
            }
            if (contributor.getType() == Contributor.ContributorType.EDITOR) {
                for (org.hl7.fhir.dstu3.model.ContactDetail c : contributor.getContact()) {
                    tgt.addEditor(VersionConvertor_30_50.convertContactDetail(c));
                }
            }
            if (contributor.getType() == Contributor.ContributorType.REVIEWER) {
                for (org.hl7.fhir.dstu3.model.ContactDetail c : contributor.getContact()) {
                    tgt.addReviewer(VersionConvertor_30_50.convertContactDetail(c));
                }
            }
            if (contributor.getType() != Contributor.ContributorType.ENDORSER) continue;
            for (org.hl7.fhir.dstu3.model.ContactDetail c : contributor.getContact()) {
                tgt.addEndorser(VersionConvertor_30_50.convertContactDetail(c));
            }
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(VersionConvertor_30_50.convertRelatedArtifact(relatedArtifact));
        }
        for (Reference reference : src.getLibrary()) {
            tgt.getLibrary().add(VersionConvertor_30_50.convertReferenceToCanonical(reference));
        }
        if (src.hasKind()) {
            tgt.setKindElement(ActivityDefinition30_50.convertActivityDefinitionKind(src.getKindElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_50.convertType(src.getTiming()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_50.convertReference(src.getLocation()));
        }
        for (ActivityDefinition.ActivityDefinitionParticipantComponent activityDefinitionParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(ActivityDefinition30_50.convertActivityDefinitionParticipantComponent(activityDefinitionParticipantComponent));
        }
        if (src.hasProduct()) {
            tgt.setProduct(VersionConvertor_30_50.convertType(src.getProduct()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_50.convertSimpleQuantity(src.getQuantity()));
        }
        for (Dosage dosage : src.getDosage()) {
            tgt.addDosage(VersionConvertor_30_50.convertDosage(dosage));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(VersionConvertor_30_50.convertReferenceToCanonical(src.getTransform()));
        }
        for (ActivityDefinition.ActivityDefinitionDynamicValueComponent activityDefinitionDynamicValueComponent : src.getDynamicValue()) {
            tgt.addDynamicValue(ActivityDefinition30_50.convertActivityDefinitionDynamicValueComponent(activityDefinitionDynamicValueComponent));
        }
        return tgt;
    }

    public static ActivityDefinition convertActivityDefinition(org.hl7.fhir.r5.model.ActivityDefinition src) throws FHIRException {
        Contributor c;
        if (src == null) {
            return null;
        }
        ActivityDefinition tgt = new ActivityDefinition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(VersionConvertor_30_50.convertString(src.getUsageElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(VersionConvertor_30_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(VersionConvertor_30_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (ContactDetail contactDetail : src.getAuthor()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.AUTHOR);
            c.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
            tgt.addContributor(c);
        }
        for (ContactDetail contactDetail : src.getEditor()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.EDITOR);
            c.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
            tgt.addContributor(c);
        }
        for (ContactDetail contactDetail : src.getReviewer()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.REVIEWER);
            c.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
            tgt.addContributor(c);
        }
        for (ContactDetail contactDetail : src.getEndorser()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.ENDORSER);
            c.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
            tgt.addContributor(c);
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (org.hl7.fhir.r5.model.RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(VersionConvertor_30_50.convertRelatedArtifact(relatedArtifact));
        }
        for (CanonicalType canonicalType : src.getLibrary()) {
            tgt.addLibrary(VersionConvertor_30_50.convertCanonicalToReference(canonicalType));
        }
        if (src.hasKind()) {
            tgt.setKindElement(ActivityDefinition30_50.convertActivityDefinitionKind(src.getKindElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_50.convertType(src.getTiming()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_50.convertReference(src.getLocation()));
        }
        for (ActivityDefinition.ActivityDefinitionParticipantComponent activityDefinitionParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(ActivityDefinition30_50.convertActivityDefinitionParticipantComponent(activityDefinitionParticipantComponent));
        }
        if (src.hasProduct()) {
            tgt.setProduct(VersionConvertor_30_50.convertType(src.getProduct()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_50.convertSimpleQuantity(src.getQuantity()));
        }
        for (org.hl7.fhir.r5.model.Dosage dosage : src.getDosage()) {
            tgt.addDosage(VersionConvertor_30_50.convertDosage(dosage));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTransform()) {
            tgt.setTransform(VersionConvertor_30_50.convertCanonicalToReference(src.getTransformElement()));
        }
        for (ActivityDefinition.ActivityDefinitionDynamicValueComponent activityDefinitionDynamicValueComponent : src.getDynamicValue()) {
            tgt.addDynamicValue(ActivityDefinition30_50.convertActivityDefinitionDynamicValueComponent(activityDefinitionDynamicValueComponent));
        }
        return tgt;
    }

    public static ActivityDefinition.ActivityDefinitionDynamicValueComponent convertActivityDefinitionDynamicValueComponent(ActivityDefinition.ActivityDefinitionDynamicValueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionDynamicValueComponent tgt = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.getExpression().setDescription(src.getDescription());
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        if (src.hasLanguage()) {
            tgt.getExpression().setLanguage(src.getLanguage());
        }
        if (src.hasExpression()) {
            tgt.getExpression().setExpression(src.getExpression());
        }
        return tgt;
    }

    public static ActivityDefinition.ActivityDefinitionDynamicValueComponent convertActivityDefinitionDynamicValueComponent(ActivityDefinition.ActivityDefinitionDynamicValueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionDynamicValueComponent tgt = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        if (src.getExpression().hasDescription()) {
            tgt.setDescription(src.getExpression().getDescription());
        }
        if (src.getExpression().hasLanguage()) {
            tgt.setLanguage(src.getExpression().getLanguage());
        }
        if (src.getExpression().hasExpression()) {
            tgt.setExpression(src.getExpression().getExpression());
        }
        return tgt;
    }

    public static Enumeration<ActivityDefinition.RequestResourceType> convertActivityDefinitionKind(org.hl7.fhir.dstu3.model.Enumeration<ActivityDefinition.ActivityDefinitionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ActivityDefinition.RequestResourceType> tgt = new Enumeration<ActivityDefinition.RequestResourceType>(new ActivityDefinition.RequestResourceTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((ActivityDefinition.ActivityDefinitionKind)((Object)src.getValue())) {
            case APPOINTMENT: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.APPOINTMENT);
                break;
            }
            case APPOINTMENTRESPONSE: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.APPOINTMENTRESPONSE);
                break;
            }
            case CAREPLAN: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.CAREPLAN);
                break;
            }
            case CLAIM: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.CLAIM);
                break;
            }
            case COMMUNICATIONREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.COMMUNICATIONREQUEST);
                break;
            }
            case CONTRACT: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.CONTRACT);
                break;
            }
            case DEVICEREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.DEVICEREQUEST);
                break;
            }
            case ENROLLMENTREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.ENROLLMENTREQUEST);
                break;
            }
            case IMMUNIZATIONRECOMMENDATION: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.IMMUNIZATIONRECOMMENDATION);
                break;
            }
            case MEDICATIONREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.MEDICATIONREQUEST);
                break;
            }
            case NUTRITIONORDER: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.NUTRITIONORDER);
                break;
            }
            case PROCEDUREREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.SERVICEREQUEST);
                break;
            }
            case REFERRALREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.SERVICEREQUEST);
                break;
            }
            case SUPPLYREQUEST: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.SUPPLYREQUEST);
                break;
            }
            case TASK: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.TASK);
                break;
            }
            case VISIONPRESCRIPTION: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.VISIONPRESCRIPTION);
                break;
            }
            default: {
                tgt.setValue((Object)ActivityDefinition.RequestResourceType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ActivityDefinition.ActivityDefinitionKind> convertActivityDefinitionKind(Enumeration<ActivityDefinition.RequestResourceType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ActivityDefinition.ActivityDefinitionKind> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ActivityDefinition.ActivityDefinitionKind>(new ActivityDefinition.ActivityDefinitionKindEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((ActivityDefinition.RequestResourceType)((Object)src.getValue())) {
            case APPOINTMENT: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.APPOINTMENT);
                break;
            }
            case APPOINTMENTRESPONSE: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.APPOINTMENTRESPONSE);
                break;
            }
            case CAREPLAN: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.CAREPLAN);
                break;
            }
            case CLAIM: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.CLAIM);
                break;
            }
            case COMMUNICATIONREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.COMMUNICATIONREQUEST);
                break;
            }
            case CONTRACT: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.CONTRACT);
                break;
            }
            case DEVICEREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.DEVICEREQUEST);
                break;
            }
            case ENROLLMENTREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.ENROLLMENTREQUEST);
                break;
            }
            case IMMUNIZATIONRECOMMENDATION: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.IMMUNIZATIONRECOMMENDATION);
                break;
            }
            case MEDICATIONREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.MEDICATIONREQUEST);
                break;
            }
            case NUTRITIONORDER: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.NUTRITIONORDER);
                break;
            }
            case SERVICEREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.PROCEDUREREQUEST);
                break;
            }
            case SUPPLYREQUEST: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.SUPPLYREQUEST);
                break;
            }
            case TASK: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.TASK);
                break;
            }
            case VISIONPRESCRIPTION: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.VISIONPRESCRIPTION);
                break;
            }
            default: {
                tgt.setValue((Object)ActivityDefinition.ActivityDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static ActivityDefinition.ActivityDefinitionParticipantComponent convertActivityDefinitionParticipantComponent(ActivityDefinition.ActivityDefinitionParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionParticipantComponent tgt = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(ActivityDefinition30_50.convertActivityParticipantType(src.getTypeElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_50.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static ActivityDefinition.ActivityDefinitionParticipantComponent convertActivityDefinitionParticipantComponent(ActivityDefinition.ActivityDefinitionParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionParticipantComponent tgt = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(ActivityDefinition30_50.convertActivityParticipantType(src.getTypeElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_50.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ActionParticipantType> convertActivityParticipantType(org.hl7.fhir.dstu3.model.Enumeration<ActivityDefinition.ActivityParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ActionParticipantType> tgt = new Enumeration<Enumerations.ActionParticipantType>(new Enumerations.ActionParticipantTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((ActivityDefinition.ActivityParticipantType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.PATIENT);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.PRACTITIONER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.RELATEDPERSON);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ActionParticipantType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ActivityDefinition.ActivityParticipantType> convertActivityParticipantType(Enumeration<Enumerations.ActionParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ActivityDefinition.ActivityParticipantType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ActivityDefinition.ActivityParticipantType>(new ActivityDefinition.ActivityParticipantTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ActionParticipantType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)ActivityDefinition.ActivityParticipantType.PATIENT);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)ActivityDefinition.ActivityParticipantType.PRACTITIONER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)ActivityDefinition.ActivityParticipantType.RELATEDPERSON);
                break;
            }
            default: {
                tgt.setValue((Object)ActivityDefinition.ActivityParticipantType.NULL);
            }
        }
        return tgt;
    }
}

