/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.TestScript;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.TestScript;
import org.hl7.fhir.r4.model.UsageContext;

public class TestScript30_40 {
    public static TestScript convertTestScript(org.hl7.fhir.dstu3.model.TestScript src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript tgt = new TestScript();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu3.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_40.convertMarkdown(src.getCopyrightElement()));
        }
        for (TestScript.TestScriptOriginComponent testScriptOriginComponent : src.getOrigin()) {
            tgt.addOrigin(TestScript30_40.convertTestScriptOriginComponent(testScriptOriginComponent));
        }
        for (TestScript.TestScriptDestinationComponent testScriptDestinationComponent : src.getDestination()) {
            tgt.addDestination(TestScript30_40.convertTestScriptDestinationComponent(testScriptDestinationComponent));
        }
        if (src.hasMetadata()) {
            tgt.setMetadata(TestScript30_40.convertTestScriptMetadataComponent(src.getMetadata()));
        }
        for (TestScript.TestScriptFixtureComponent testScriptFixtureComponent : src.getFixture()) {
            tgt.addFixture(TestScript30_40.convertTestScriptFixtureComponent(testScriptFixtureComponent));
        }
        for (Reference reference : src.getProfile()) {
            tgt.addProfile(VersionConvertor_30_40.convertReference(reference));
        }
        for (TestScript.TestScriptVariableComponent testScriptVariableComponent : src.getVariable()) {
            tgt.addVariable(TestScript30_40.convertTestScriptVariableComponent(testScriptVariableComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestScript30_40.convertTestScriptSetupComponent(src.getSetup()));
        }
        for (TestScript.TestScriptTestComponent testScriptTestComponent : src.getTest()) {
            tgt.addTest(TestScript30_40.convertTestScriptTestComponent(testScriptTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestScript30_40.convertTestScriptTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.TestScript convertTestScript(TestScript src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.TestScript tgt = new org.hl7.fhir.dstu3.model.TestScript();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_40.convertMarkdown(src.getCopyrightElement()));
        }
        for (TestScript.TestScriptOriginComponent testScriptOriginComponent : src.getOrigin()) {
            tgt.addOrigin(TestScript30_40.convertTestScriptOriginComponent(testScriptOriginComponent));
        }
        for (TestScript.TestScriptDestinationComponent testScriptDestinationComponent : src.getDestination()) {
            tgt.addDestination(TestScript30_40.convertTestScriptDestinationComponent(testScriptDestinationComponent));
        }
        if (src.hasMetadata()) {
            tgt.setMetadata(TestScript30_40.convertTestScriptMetadataComponent(src.getMetadata()));
        }
        for (TestScript.TestScriptFixtureComponent testScriptFixtureComponent : src.getFixture()) {
            tgt.addFixture(TestScript30_40.convertTestScriptFixtureComponent(testScriptFixtureComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getProfile()) {
            tgt.addProfile(VersionConvertor_30_40.convertReference(reference));
        }
        for (TestScript.TestScriptVariableComponent testScriptVariableComponent : src.getVariable()) {
            tgt.addVariable(TestScript30_40.convertTestScriptVariableComponent(testScriptVariableComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestScript30_40.convertTestScriptSetupComponent(src.getSetup()));
        }
        for (TestScript.TestScriptTestComponent testScriptTestComponent : src.getTest()) {
            tgt.addTest(TestScript30_40.convertTestScriptTestComponent(testScriptTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestScript30_40.convertTestScriptTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static TestScript.TestScriptDestinationComponent convertTestScriptDestinationComponent(TestScript.TestScriptDestinationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptDestinationComponent tgt = new TestScript.TestScriptDestinationComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasIndex()) {
            tgt.setIndexElement(VersionConvertor_30_40.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_40.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptDestinationComponent convertTestScriptDestinationComponent(TestScript.TestScriptDestinationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptDestinationComponent tgt = new TestScript.TestScriptDestinationComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasIndex()) {
            tgt.setIndexElement(VersionConvertor_30_40.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_40.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAutocreate()) {
            tgt.setAutocreateElement(VersionConvertor_30_40.convertBoolean(src.getAutocreateElement()));
        }
        if (src.hasAutodelete()) {
            tgt.setAutodeleteElement(VersionConvertor_30_40.convertBoolean(src.getAutodeleteElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_30_40.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAutocreate()) {
            tgt.setAutocreateElement(VersionConvertor_30_40.convertBoolean(src.getAutocreateElement()));
        }
        if (src.hasAutodelete()) {
            tgt.setAutodeleteElement(VersionConvertor_30_40.convertBoolean(src.getAutodeleteElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_30_40.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasRequired()) {
            tgt.setRequiredElement(VersionConvertor_30_40.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasValidated()) {
            tgt.setValidatedElement(VersionConvertor_30_40.convertBoolean(src.getValidatedElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (IntegerType integerType : src.getOrigin()) {
            tgt.addOrigin((Integer)integerType.getValue());
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(VersionConvertor_30_40.convertInteger(src.getDestinationElement()));
        }
        for (UriType uriType : src.getLink()) {
            tgt.addLink((String)uriType.getValue());
        }
        if (src.hasCapabilities()) {
            tgt.setCapabilitiesElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getCapabilities()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasRequired()) {
            tgt.setRequiredElement(VersionConvertor_30_40.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasValidated()) {
            tgt.setValidatedElement(VersionConvertor_30_40.convertBoolean(src.getValidatedElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r4.model.IntegerType integerType : src.getOrigin()) {
            tgt.addOrigin((Integer)integerType.getValue());
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(VersionConvertor_30_40.convertInteger(src.getDestinationElement()));
        }
        for (org.hl7.fhir.r4.model.UriType uriType : src.getLink()) {
            tgt.addLink((String)uriType.getValue());
        }
        if (src.hasCapabilities()) {
            tgt.setCapabilities(VersionConvertor_30_40.convertCanonicalToReference(src.getCapabilitiesElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (TestScript.TestScriptMetadataLinkComponent testScriptMetadataLinkComponent : src.getLink()) {
            tgt.addLink(TestScript30_40.convertTestScriptMetadataLinkComponent(testScriptMetadataLinkComponent));
        }
        for (TestScript.TestScriptMetadataCapabilityComponent testScriptMetadataCapabilityComponent : src.getCapability()) {
            tgt.addCapability(TestScript30_40.convertTestScriptMetadataCapabilityComponent(testScriptMetadataCapabilityComponent));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (TestScript.TestScriptMetadataLinkComponent testScriptMetadataLinkComponent : src.getLink()) {
            tgt.addLink(TestScript30_40.convertTestScriptMetadataLinkComponent(testScriptMetadataLinkComponent));
        }
        for (TestScript.TestScriptMetadataCapabilityComponent testScriptMetadataCapabilityComponent : src.getCapability()) {
            tgt.addCapability(TestScript30_40.convertTestScriptMetadataCapabilityComponent(testScriptMetadataCapabilityComponent));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptOriginComponent convertTestScriptOriginComponent(TestScript.TestScriptOriginComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptOriginComponent tgt = new TestScript.TestScriptOriginComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasIndex()) {
            tgt.setIndexElement(VersionConvertor_30_40.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_40.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptOriginComponent convertTestScriptOriginComponent(TestScript.TestScriptOriginComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptOriginComponent tgt = new TestScript.TestScriptOriginComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasIndex()) {
            tgt.setIndexElement(VersionConvertor_30_40.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_40.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (TestScript.SetupActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (TestScript.SetupActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (TestScript.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (TestScript.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (TestScript.TestActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (TestScript.TestActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValueElement(VersionConvertor_30_40.convertString(src.getDefaultValueElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_40.convertString(src.getExpressionElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(VersionConvertor_30_40.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasHint()) {
            tgt.setHintElement(VersionConvertor_30_40.convertString(src.getHintElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_30_40.convertId(src.getSourceIdElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValueElement(VersionConvertor_30_40.convertString(src.getDefaultValueElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_40.convertString(src.getExpressionElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(VersionConvertor_30_40.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasHint()) {
            tgt.setHintElement(VersionConvertor_30_40.convertString(src.getHintElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_30_40.convertId(src.getSourceIdElement()));
        }
        return tgt;
    }
}

