/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.TestReport;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.TestReport;

public class TestReport30_40 {
    public static TestReport convertTestReport(org.hl7.fhir.dstu3.model.TestReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport tgt = new TestReport();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(TestReport30_40.convertTestReportStatus(src.getStatusElement()));
        }
        if (src.hasTestScript()) {
            tgt.setTestScript(VersionConvertor_30_40.convertReference(src.getTestScript()));
        }
        if (src.hasResult()) {
            tgt.setResultElement(TestReport30_40.convertTestReportResult(src.getResultElement()));
        }
        if (src.hasScore()) {
            tgt.setScoreElement(VersionConvertor_30_40.convertDecimal(src.getScoreElement()));
        }
        if (src.hasTester()) {
            tgt.setTesterElement(VersionConvertor_30_40.convertString(src.getTesterElement()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(VersionConvertor_30_40.convertDateTime(src.getIssuedElement()));
        }
        for (TestReport.TestReportParticipantComponent testReportParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(TestReport30_40.convertTestReportParticipantComponent(testReportParticipantComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestReport30_40.convertTestReportSetupComponent(src.getSetup()));
        }
        for (TestReport.TestReportTestComponent testReportTestComponent : src.getTest()) {
            tgt.addTest(TestReport30_40.convertTestReportTestComponent(testReportTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestReport30_40.convertTestReportTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.TestReport convertTestReport(TestReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.TestReport tgt = new org.hl7.fhir.dstu3.model.TestReport();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(TestReport30_40.convertTestReportStatus(src.getStatusElement()));
        }
        if (src.hasTestScript()) {
            tgt.setTestScript(VersionConvertor_30_40.convertReference(src.getTestScript()));
        }
        if (src.hasResult()) {
            tgt.setResultElement(TestReport30_40.convertTestReportResult(src.getResultElement()));
        }
        if (src.hasScore()) {
            tgt.setScoreElement(VersionConvertor_30_40.convertDecimal(src.getScoreElement()));
        }
        if (src.hasTester()) {
            tgt.setTesterElement(VersionConvertor_30_40.convertString(src.getTesterElement()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(VersionConvertor_30_40.convertDateTime(src.getIssuedElement()));
        }
        for (TestReport.TestReportParticipantComponent testReportParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(TestReport30_40.convertTestReportParticipantComponent(testReportParticipantComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestReport30_40.convertTestReportSetupComponent(src.getSetup()));
        }
        for (TestReport.TestReportTestComponent testReportTestComponent : src.getTest()) {
            tgt.addTest(TestReport30_40.convertTestReportTestComponent(testReportTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestReport30_40.convertTestReportTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static TestReport.TestReportParticipantComponent convertTestReportParticipantComponent(TestReport.TestReportParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportParticipantComponent tgt = new TestReport.TestReportParticipantComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(TestReport30_40.convertTestReportParticipantType(src.getTypeElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_30_40.convertUri(src.getUriElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_40.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static TestReport.TestReportParticipantComponent convertTestReportParticipantComponent(TestReport.TestReportParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportParticipantComponent tgt = new TestReport.TestReportParticipantComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(TestReport30_40.convertTestReportParticipantType(src.getTypeElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_30_40.convertUri(src.getUriElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_40.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportParticipantType> convertTestReportParticipantType(Enumeration<TestReport.TestReportParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportParticipantType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportParticipantType>(new TestReport.TestReportParticipantTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportParticipantType)((Object)src.getValue())) {
            case TESTENGINE: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.TESTENGINE);
                break;
            }
            case CLIENT: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestReport.TestReportParticipantType> convertTestReportParticipantType(org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportParticipantType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestReport.TestReportParticipantType> tgt = new Enumeration<TestReport.TestReportParticipantType>(new TestReport.TestReportParticipantTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportParticipantType)((Object)src.getValue())) {
            case TESTENGINE: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.TESTENGINE);
                break;
            }
            case CLIENT: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportParticipantType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestReport.TestReportResult> convertTestReportResult(org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportResult> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestReport.TestReportResult> tgt = new Enumeration<TestReport.TestReportResult>(new TestReport.TestReportResultEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportResult)((Object)src.getValue())) {
            case PASS: {
                tgt.setValue((Object)TestReport.TestReportResult.PASS);
                break;
            }
            case FAIL: {
                tgt.setValue((Object)TestReport.TestReportResult.FAIL);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)TestReport.TestReportResult.PENDING);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportResult.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportResult> convertTestReportResult(Enumeration<TestReport.TestReportResult> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportResult> tgt = new org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportResult>(new TestReport.TestReportResultEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportResult)((Object)src.getValue())) {
            case PASS: {
                tgt.setValue((Object)TestReport.TestReportResult.PASS);
                break;
            }
            case FAIL: {
                tgt.setValue((Object)TestReport.TestReportResult.FAIL);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)TestReport.TestReportResult.PENDING);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportResult.NULL);
            }
        }
        return tgt;
    }

    public static TestReport.TestReportSetupComponent convertTestReportSetupComponent(TestReport.TestReportSetupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportSetupComponent tgt = new TestReport.TestReportSetupComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (TestReport.SetupActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestReport.TestReportSetupComponent convertTestReportSetupComponent(TestReport.TestReportSetupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportSetupComponent tgt = new TestReport.TestReportSetupComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (TestReport.SetupActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static Enumeration<TestReport.TestReportStatus> convertTestReportStatus(org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestReport.TestReportStatus> tgt = new Enumeration<TestReport.TestReportStatus>(new TestReport.TestReportStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportStatus)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)TestReport.TestReportStatus.COMPLETED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)TestReport.TestReportStatus.INPROGRESS);
                break;
            }
            case WAITING: {
                tgt.setValue((Object)TestReport.TestReportStatus.WAITING);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)TestReport.TestReportStatus.STOPPED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)TestReport.TestReportStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportStatus> convertTestReportStatus(Enumeration<TestReport.TestReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<TestReport.TestReportStatus>(new TestReport.TestReportStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((TestReport.TestReportStatus)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)TestReport.TestReportStatus.COMPLETED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)TestReport.TestReportStatus.INPROGRESS);
                break;
            }
            case WAITING: {
                tgt.setValue((Object)TestReport.TestReportStatus.WAITING);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)TestReport.TestReportStatus.STOPPED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)TestReport.TestReportStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)TestReport.TestReportStatus.NULL);
            }
        }
        return tgt;
    }

    public static TestReport.TestReportTeardownComponent convertTestReportTeardownComponent(TestReport.TestReportTeardownComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportTeardownComponent tgt = new TestReport.TestReportTeardownComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (TestReport.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestReport.TestReportTeardownComponent convertTestReportTeardownComponent(TestReport.TestReportTeardownComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportTeardownComponent tgt = new TestReport.TestReportTeardownComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (TestReport.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestReport.TestReportTestComponent convertTestReportTestComponent(TestReport.TestReportTestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportTestComponent tgt = new TestReport.TestReportTestComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (TestReport.TestActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestReport.TestReportTestComponent convertTestReportTestComponent(TestReport.TestReportTestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportTestComponent tgt = new TestReport.TestReportTestComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (TestReport.TestActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertTestActionComponent(t));
        }
        return tgt;
    }
}

