/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.SupplyDelivery;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.SupplyDelivery;

public class SupplyDelivery30_40 {
    public static SupplyDelivery convertSupplyDelivery(org.hl7.fhir.dstu3.model.SupplyDelivery src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyDelivery tgt = new SupplyDelivery();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        for (org.hl7.fhir.dstu3.model.Reference t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(t));
        }
        for (org.hl7.fhir.dstu3.model.Reference t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(SupplyDelivery30_40.convertSupplyDeliveryStatus(src.getStatusElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSuppliedItem()) {
            tgt.setSuppliedItem(SupplyDelivery30_40.convertSupplyDeliverySuppliedItemComponent(src.getSuppliedItem()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_40.convertType(src.getOccurrence()));
        }
        if (src.hasSupplier()) {
            tgt.setSupplier(VersionConvertor_30_40.convertReference(src.getSupplier()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_40.convertReference(src.getDestination()));
        }
        for (org.hl7.fhir.dstu3.model.Reference t : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.SupplyDelivery convertSupplyDelivery(SupplyDelivery src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.SupplyDelivery tgt = new org.hl7.fhir.dstu3.model.SupplyDelivery();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifierFirstRep()));
        }
        for (Reference t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(t));
        }
        for (Reference t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(SupplyDelivery30_40.convertSupplyDeliveryStatus(src.getStatusElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSuppliedItem()) {
            tgt.setSuppliedItem(SupplyDelivery30_40.convertSupplyDeliverySuppliedItemComponent(src.getSuppliedItem()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_40.convertType(src.getOccurrence()));
        }
        if (src.hasSupplier()) {
            tgt.setSupplier(VersionConvertor_30_40.convertReference(src.getSupplier()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_40.convertReference(src.getDestination()));
        }
        for (Reference t : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    public static Enumeration<SupplyDelivery.SupplyDeliveryStatus> convertSupplyDeliveryStatus(org.hl7.fhir.dstu3.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SupplyDelivery.SupplyDeliveryStatus> tgt = new Enumeration<SupplyDelivery.SupplyDeliveryStatus>(new SupplyDelivery.SupplyDeliveryStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((SupplyDelivery.SupplyDeliveryStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.COMPLETED);
                break;
            }
            case ABANDONED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.ABANDONED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus> convertSupplyDeliveryStatus(Enumeration<SupplyDelivery.SupplyDeliveryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<SupplyDelivery.SupplyDeliveryStatus>(new SupplyDelivery.SupplyDeliveryStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((SupplyDelivery.SupplyDeliveryStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.COMPLETED);
                break;
            }
            case ABANDONED: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.ABANDONED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)SupplyDelivery.SupplyDeliveryStatus.NULL);
            }
        }
        return tgt;
    }

    public static SupplyDelivery.SupplyDeliverySuppliedItemComponent convertSupplyDeliverySuppliedItemComponent(SupplyDelivery.SupplyDeliverySuppliedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyDelivery.SupplyDeliverySuppliedItemComponent tgt = new SupplyDelivery.SupplyDeliverySuppliedItemComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_40.convertType(src.getItem()));
        }
        return tgt;
    }

    public static SupplyDelivery.SupplyDeliverySuppliedItemComponent convertSupplyDeliverySuppliedItemComponent(SupplyDelivery.SupplyDeliverySuppliedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyDelivery.SupplyDeliverySuppliedItemComponent tgt = new SupplyDelivery.SupplyDeliverySuppliedItemComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_40.convertType(src.getItem()));
        }
        return tgt;
    }
}

