/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Specimen;

public class Specimen30_40 {
    public static Specimen convertSpecimen(org.hl7.fhir.dstu3.model.Specimen src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen tgt = new Specimen();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasAccessionIdentifier()) {
            tgt.setAccessionIdentifier(VersionConvertor_30_40.convertIdentifier(src.getAccessionIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Specimen30_40.convertSpecimenStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasReceivedTime()) {
            tgt.setReceivedTimeElement(VersionConvertor_30_40.convertDateTime(src.getReceivedTimeElement()));
        }
        for (Reference reference : src.getParent()) {
            tgt.addParent(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getRequest()) {
            tgt.addRequest(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasCollection()) {
            tgt.setCollection(Specimen30_40.convertSpecimenCollectionComponent(src.getCollection()));
        }
        for (Specimen.SpecimenProcessingComponent specimenProcessingComponent : src.getProcessing()) {
            tgt.addProcessing(Specimen30_40.convertSpecimenProcessingComponent(specimenProcessingComponent));
        }
        for (Specimen.SpecimenContainerComponent specimenContainerComponent : src.getContainer()) {
            tgt.addContainer(Specimen30_40.convertSpecimenContainerComponent(specimenContainerComponent));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Specimen convertSpecimen(Specimen src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Specimen tgt = new org.hl7.fhir.dstu3.model.Specimen();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasAccessionIdentifier()) {
            tgt.setAccessionIdentifier(VersionConvertor_30_40.convertIdentifier(src.getAccessionIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Specimen30_40.convertSpecimenStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasReceivedTime()) {
            tgt.setReceivedTimeElement(VersionConvertor_30_40.convertDateTime(src.getReceivedTimeElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getParent()) {
            tgt.addParent(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRequest()) {
            tgt.addRequest(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasCollection()) {
            tgt.setCollection(Specimen30_40.convertSpecimenCollectionComponent(src.getCollection()));
        }
        for (Specimen.SpecimenProcessingComponent specimenProcessingComponent : src.getProcessing()) {
            tgt.addProcessing(Specimen30_40.convertSpecimenProcessingComponent(specimenProcessingComponent));
        }
        for (Specimen.SpecimenContainerComponent specimenContainerComponent : src.getContainer()) {
            tgt.addContainer(Specimen30_40.convertSpecimenContainerComponent(specimenContainerComponent));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static Specimen.SpecimenCollectionComponent convertSpecimenCollectionComponent(Specimen.SpecimenCollectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenCollectionComponent tgt = new Specimen.SpecimenCollectionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCollector()) {
            tgt.setCollector(VersionConvertor_30_40.convertReference(src.getCollector()));
        }
        if (src.hasCollected()) {
            tgt.setCollected(VersionConvertor_30_40.convertType(src.getCollected()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        return tgt;
    }

    public static Specimen.SpecimenCollectionComponent convertSpecimenCollectionComponent(Specimen.SpecimenCollectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenCollectionComponent tgt = new Specimen.SpecimenCollectionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCollector()) {
            tgt.setCollector(VersionConvertor_30_40.convertReference(src.getCollector()));
        }
        if (src.hasCollected()) {
            tgt.setCollected(VersionConvertor_30_40.convertType(src.getCollected()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        return tgt;
    }

    public static Specimen.SpecimenContainerComponent convertSpecimenContainerComponent(Specimen.SpecimenContainerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenContainerComponent tgt = new Specimen.SpecimenContainerComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasCapacity()) {
            tgt.setCapacity(VersionConvertor_30_40.convertSimpleQuantity(src.getCapacity()));
        }
        if (src.hasSpecimenQuantity()) {
            tgt.setSpecimenQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getSpecimenQuantity()));
        }
        if (src.hasAdditive()) {
            tgt.setAdditive(VersionConvertor_30_40.convertType(src.getAdditive()));
        }
        return tgt;
    }

    public static Specimen.SpecimenContainerComponent convertSpecimenContainerComponent(Specimen.SpecimenContainerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenContainerComponent tgt = new Specimen.SpecimenContainerComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasCapacity()) {
            tgt.setCapacity(VersionConvertor_30_40.convertSimpleQuantity(src.getCapacity()));
        }
        if (src.hasSpecimenQuantity()) {
            tgt.setSpecimenQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getSpecimenQuantity()));
        }
        if (src.hasAdditive()) {
            tgt.setAdditive(VersionConvertor_30_40.convertType(src.getAdditive()));
        }
        return tgt;
    }

    public static Specimen.SpecimenProcessingComponent convertSpecimenProcessingComponent(Specimen.SpecimenProcessingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenProcessingComponent tgt = new Specimen.SpecimenProcessingComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(VersionConvertor_30_40.convertCodeableConcept(src.getProcedure()));
        }
        for (Reference t : src.getAdditive()) {
            tgt.addAdditive(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasTime()) {
            tgt.setTime(VersionConvertor_30_40.convertType(src.getTime()));
        }
        return tgt;
    }

    public static Specimen.SpecimenProcessingComponent convertSpecimenProcessingComponent(Specimen.SpecimenProcessingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenProcessingComponent tgt = new Specimen.SpecimenProcessingComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(VersionConvertor_30_40.convertCodeableConcept(src.getProcedure()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getAdditive()) {
            tgt.addAdditive(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasTime()) {
            tgt.setTime(VersionConvertor_30_40.convertType(src.getTime()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Specimen.SpecimenStatus> convertSpecimenStatus(Enumeration<Specimen.SpecimenStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Specimen.SpecimenStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Specimen.SpecimenStatus>(new Specimen.SpecimenStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Specimen.SpecimenStatus)((Object)src.getValue())) {
            case AVAILABLE: {
                tgt.setValue((Object)Specimen.SpecimenStatus.AVAILABLE);
                break;
            }
            case UNAVAILABLE: {
                tgt.setValue((Object)Specimen.SpecimenStatus.UNAVAILABLE);
                break;
            }
            case UNSATISFACTORY: {
                tgt.setValue((Object)Specimen.SpecimenStatus.UNSATISFACTORY);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Specimen.SpecimenStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Specimen.SpecimenStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Specimen.SpecimenStatus> convertSpecimenStatus(org.hl7.fhir.dstu3.model.Enumeration<Specimen.SpecimenStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Specimen.SpecimenStatus> tgt = new Enumeration<Specimen.SpecimenStatus>(new Specimen.SpecimenStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Specimen.SpecimenStatus)((Object)src.getValue())) {
            case AVAILABLE: {
                tgt.setValue((Object)Specimen.SpecimenStatus.AVAILABLE);
                break;
            }
            case UNAVAILABLE: {
                tgt.setValue((Object)Specimen.SpecimenStatus.UNAVAILABLE);
                break;
            }
            case UNSATISFACTORY: {
                tgt.setValue((Object)Specimen.SpecimenStatus.UNSATISFACTORY);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Specimen.SpecimenStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Specimen.SpecimenStatus.NULL);
            }
        }
        return tgt;
    }
}

