/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.RiskAssessment;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RiskAssessment;
import org.hl7.fhir.r4.model.Type;

public class RiskAssessment30_40 {
    public static org.hl7.fhir.dstu3.model.RiskAssessment convertRiskAssessment(RiskAssessment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.RiskAssessment tgt = new org.hl7.fhir.dstu3.model.RiskAssessment();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasBasedOn()) {
            tgt.setBasedOn(VersionConvertor_30_40.convertReference(src.getBasedOn()));
        }
        if (src.hasParent()) {
            tgt.setParent(VersionConvertor_30_40.convertReference(src.getParent()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(RiskAssessment30_40.convertRiskAssessmentStatus(src.getStatusElement()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_40.convertType(src.getOccurrence()));
        }
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        if (src.hasReasonCode()) {
            tgt.setReason(VersionConvertor_30_40.convertType(src.getReasonCodeFirstRep()));
        }
        if (src.hasReasonReference()) {
            tgt.setReason(VersionConvertor_30_40.convertType(src.getReasonReferenceFirstRep()));
        }
        for (Reference reference : src.getBasis()) {
            tgt.addBasis(VersionConvertor_30_40.convertReference(reference));
        }
        for (RiskAssessment.RiskAssessmentPredictionComponent riskAssessmentPredictionComponent : src.getPrediction()) {
            tgt.addPrediction(RiskAssessment30_40.convertRiskAssessmentPredictionComponent(riskAssessmentPredictionComponent));
        }
        if (src.hasMitigation()) {
            tgt.setMitigationElement(VersionConvertor_30_40.convertString(src.getMitigationElement()));
        }
        if (src.hasNote()) {
            tgt.setComment(src.getNoteFirstRep().getText());
        }
        return tgt;
    }

    public static RiskAssessment convertRiskAssessment(org.hl7.fhir.dstu3.model.RiskAssessment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment tgt = new RiskAssessment();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasBasedOn()) {
            tgt.setBasedOn(VersionConvertor_30_40.convertReference(src.getBasedOn()));
        }
        if (src.hasParent()) {
            tgt.setParent(VersionConvertor_30_40.convertReference(src.getParent()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(RiskAssessment30_40.convertRiskAssessmentStatus(src.getStatusElement()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_40.convertType(src.getOccurrence()));
        }
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        if (src.hasReason()) {
            Type t = VersionConvertor_30_40.convertType(src.getReason());
            if (t instanceof CodeableConcept) {
                tgt.addReasonCode((CodeableConcept)t);
            } else {
                tgt.addReasonReference((Reference)t);
            }
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getBasis()) {
            tgt.addBasis(VersionConvertor_30_40.convertReference(reference));
        }
        for (RiskAssessment.RiskAssessmentPredictionComponent riskAssessmentPredictionComponent : src.getPrediction()) {
            tgt.addPrediction(RiskAssessment30_40.convertRiskAssessmentPredictionComponent(riskAssessmentPredictionComponent));
        }
        if (src.hasMitigation()) {
            tgt.setMitigationElement(VersionConvertor_30_40.convertString(src.getMitigationElement()));
        }
        if (src.hasComment()) {
            tgt.addNote().setText(src.getComment());
        }
        return tgt;
    }

    public static RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasProbability()) {
            tgt.setProbability(VersionConvertor_30_40.convertType(src.getProbability()));
        }
        if (src.hasQualitativeRisk()) {
            tgt.setQualitativeRisk(VersionConvertor_30_40.convertCodeableConcept(src.getQualitativeRisk()));
        }
        if (src.hasRelativeRisk()) {
            tgt.setRelativeRiskElement(VersionConvertor_30_40.convertDecimal(src.getRelativeRiskElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhen(VersionConvertor_30_40.convertType(src.getWhen()));
        }
        if (src.hasRationale()) {
            tgt.setRationaleElement(VersionConvertor_30_40.convertString(src.getRationaleElement()));
        }
        return tgt;
    }

    public static RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasProbability()) {
            tgt.setProbability(VersionConvertor_30_40.convertType(src.getProbability()));
        }
        if (src.hasQualitativeRisk()) {
            tgt.setQualitativeRisk(VersionConvertor_30_40.convertCodeableConcept(src.getQualitativeRisk()));
        }
        if (src.hasRelativeRisk()) {
            tgt.setRelativeRiskElement(VersionConvertor_30_40.convertDecimal(src.getRelativeRiskElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhen(VersionConvertor_30_40.convertType(src.getWhen()));
        }
        if (src.hasRationale()) {
            tgt.setRationaleElement(VersionConvertor_30_40.convertString(src.getRationaleElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<RiskAssessment.RiskAssessmentStatus> convertRiskAssessmentStatus(Enumeration<RiskAssessment.RiskAssessmentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<RiskAssessment.RiskAssessmentStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<RiskAssessment.RiskAssessmentStatus>(new RiskAssessment.RiskAssessmentStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((RiskAssessment.RiskAssessmentStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RiskAssessment.RiskAssessmentStatus> convertRiskAssessmentStatus(org.hl7.fhir.dstu3.model.Enumeration<RiskAssessment.RiskAssessmentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RiskAssessment.RiskAssessmentStatus> tgt = new Enumeration<RiskAssessment.RiskAssessmentStatus>(new RiskAssessment.RiskAssessmentStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((RiskAssessment.RiskAssessmentStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.NULL);
            }
        }
        return tgt;
    }
}

