/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.Type;

public class Provenance30_40 {
    public static CodeableConcept convertCodingToCodeableConcept(org.hl7.fhir.dstu3.model.Coding src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeableConcept tgt = new CodeableConcept();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.getCodingFirstRep().setSystem(src.getSystem());
        }
        if (src.hasVersion()) {
            tgt.getCodingFirstRep().setVersion(src.getVersion());
        }
        if (src.hasCode()) {
            tgt.getCodingFirstRep().setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.getCodingFirstRep().setDisplay(src.getDisplay());
        }
        if (src.hasUserSelected()) {
            tgt.getCodingFirstRep().setUserSelected(src.getUserSelected());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Provenance convertProvenance(Provenance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Provenance tgt = new org.hl7.fhir.dstu3.model.Provenance();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Reference reference : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasOccurredPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getOccurredPeriod()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(VersionConvertor_30_40.convertInstant(src.getRecordedElement()));
        }
        for (org.hl7.fhir.r4.model.UriType uriType : src.getPolicy()) {
            tgt.addPolicy((String)uriType.getValue());
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (CodeableConcept codeableConcept : src.getReason()) {
            for (Coding tc : codeableConcept.getCoding()) {
                tgt.addReason(VersionConvertor_30_40.convertCoding(tc));
            }
        }
        if (src.hasActivity()) {
            tgt.setActivity(VersionConvertor_30_40.convertCoding(src.getActivity()));
        }
        for (Provenance.ProvenanceAgentComponent provenanceAgentComponent : src.getAgent()) {
            tgt.addAgent(Provenance30_40.convertProvenanceAgentComponent(provenanceAgentComponent));
        }
        for (Provenance.ProvenanceEntityComponent provenanceEntityComponent : src.getEntity()) {
            tgt.addEntity(Provenance30_40.convertProvenanceEntityComponent(provenanceEntityComponent));
        }
        for (Signature signature : src.getSignature()) {
            tgt.addSignature(VersionConvertor_30_40.convertSignature(signature));
        }
        return tgt;
    }

    public static Provenance convertProvenance(org.hl7.fhir.dstu3.model.Provenance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance tgt = new Provenance();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Reference reference : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasPeriod()) {
            tgt.setOccurred(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(VersionConvertor_30_40.convertInstant(src.getRecordedElement()));
        }
        for (UriType uriType : src.getPolicy()) {
            tgt.addPolicy((String)uriType.getValue());
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.dstu3.model.Coding coding : src.getReason()) {
            tgt.addReason(Provenance30_40.convertCodingToCodeableConcept(coding));
        }
        if (src.hasActivity()) {
            tgt.setActivity(Provenance30_40.convertCodingToCodeableConcept(src.getActivity()));
        }
        for (Provenance.ProvenanceAgentComponent provenanceAgentComponent : src.getAgent()) {
            tgt.addAgent(Provenance30_40.convertProvenanceAgentComponent(provenanceAgentComponent));
        }
        for (Provenance.ProvenanceEntityComponent provenanceEntityComponent : src.getEntity()) {
            tgt.addEntity(Provenance30_40.convertProvenanceEntityComponent(provenanceEntityComponent));
        }
        for (org.hl7.fhir.dstu3.model.Signature signature : src.getSignature()) {
            tgt.addSignature(VersionConvertor_30_40.convertSignature(signature));
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (CodeableConcept t : src.getRole()) {
            tgt.addRole(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_30_40.convertType(src.getWho()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_40.convertType(src.getOnBehalfOf()));
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        Type t;
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.CodeableConcept t2 : src.getRole()) {
            tgt.addRole(VersionConvertor_30_40.convertCodeableConcept(t2));
        }
        if (src.hasWho()) {
            t = VersionConvertor_30_40.convertType(src.getWho());
            if (t instanceof org.hl7.fhir.r4.model.Reference) {
                tgt.setWho((org.hl7.fhir.r4.model.Reference)t);
            }
            if (t instanceof org.hl7.fhir.r4.model.UriType) {
                tgt.getWho().setReference(t.primitiveValue());
            }
        }
        if (src.hasOnBehalfOf()) {
            t = VersionConvertor_30_40.convertType(src.getOnBehalfOf());
            if (t instanceof org.hl7.fhir.r4.model.Reference) {
                tgt.setOnBehalfOf((org.hl7.fhir.r4.model.Reference)t);
            }
            if (t instanceof org.hl7.fhir.r4.model.UriType) {
                tgt.getOnBehalfOf().setReference(t.primitiveValue());
            }
        }
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRoleElement(Provenance30_40.convertProvenanceEntityRole(src.getRoleElement()));
        }
        if (src.hasWhat()) {
            tgt.setWhat(VersionConvertor_30_40.convertType(src.getWhat()));
        }
        for (Provenance.ProvenanceAgentComponent t : src.getAgent()) {
            tgt.addAgent(Provenance30_40.convertProvenanceAgentComponent(t));
        }
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRoleElement(Provenance30_40.convertProvenanceEntityRole(src.getRoleElement()));
        }
        if (src.hasWhat()) {
            Type t = VersionConvertor_30_40.convertType(src.getWhat());
            if (t instanceof org.hl7.fhir.r4.model.Reference) {
                tgt.setWhat((org.hl7.fhir.r4.model.Reference)t);
            } else if (t instanceof Identifier) {
                tgt.getWhat().setIdentifier((Identifier)t);
            } else if (t instanceof org.hl7.fhir.r4.model.UriType) {
                tgt.getWhat().setReference(t.primitiveValue());
            }
        }
        for (Provenance.ProvenanceAgentComponent t : src.getAgent()) {
            tgt.addAgent(Provenance30_40.convertProvenanceAgentComponent(t));
        }
        return tgt;
    }

    public static Enumeration<Provenance.ProvenanceEntityRole> convertProvenanceEntityRole(org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Provenance.ProvenanceEntityRole> tgt = new Enumeration<Provenance.ProvenanceEntityRole>(new Provenance.ProvenanceEntityRoleEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Provenance.ProvenanceEntityRole)((Object)src.getValue())) {
            case DERIVATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.DERIVATION);
                break;
            }
            case REVISION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REVISION);
                break;
            }
            case QUOTATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.QUOTATION);
                break;
            }
            case SOURCE: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.SOURCE);
                break;
            }
            case REMOVAL: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REMOVAL);
                break;
            }
            default: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole> convertProvenanceEntityRole(Enumeration<Provenance.ProvenanceEntityRole> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole>(new Provenance.ProvenanceEntityRoleEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Provenance.ProvenanceEntityRole)((Object)src.getValue())) {
            case DERIVATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.DERIVATION);
                break;
            }
            case REVISION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REVISION);
                break;
            }
            case QUOTATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.QUOTATION);
                break;
            }
            case SOURCE: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.SOURCE);
                break;
            }
            case REMOVAL: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REMOVAL);
                break;
            }
            default: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
            }
        }
        return tgt;
    }
}

