/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.ServiceRequest;

public class ProcedureRequest30_40 {
    public static ServiceRequest convertProcedureRequest(ProcedureRequest src) throws FHIRException {
        ProcedureRequest.ProcedureRequestRequesterComponent requester;
        if (src == null) {
            return null;
        }
        ServiceRequest tgt = new ServiceRequest();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getReplaces()) {
            tgt.addReplaces(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasRequisition() && src.hasRequisition()) {
            tgt.setRequisition(VersionConvertor_30_40.convertIdentifier(src.getRequisition()));
        }
        if (src.hasStatus() && src.hasStatus()) {
            tgt.setStatusElement(ProcedureRequest30_40.convertProcedureRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent() && src.hasIntent()) {
            tgt.setIntentElement(ProcedureRequest30_40.convertProcedureRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority() && src.hasPriority()) {
            tgt.setPriorityElement(ProcedureRequest30_40.convertProcedureRequestPriority(src.getPriorityElement()));
        }
        if (src.hasDoNotPerform() && src.hasDoNotPerformElement()) {
            tgt.setDoNotPerformElement(VersionConvertor_30_40.convertBoolean(src.getDoNotPerformElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode() && src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject() && src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext() && src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasOccurrence() && src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_40.convertType(src.getOccurrence()));
        }
        if (src.hasAsNeeded() && src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_30_40.convertType(src.getAsNeeded()));
        }
        if (src.hasAuthoredOn() && src.hasAuthoredOnElement()) {
            tgt.setAuthoredOnElement(VersionConvertor_30_40.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester() && (requester = src.getRequester()).hasAgent()) {
            tgt.setRequester(VersionConvertor_30_40.convertReference(requester.getAgent()));
        }
        if (src.hasPerformerType() && src.hasPerformerType()) {
            tgt.setPerformerType(VersionConvertor_30_40.convertCodeableConcept(src.getPerformerType()));
        }
        if (src.hasPerformer() && src.hasPerformer()) {
            tgt.addPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (Reference reference : src.getRelevantHistory()) {
            tgt.addRelevantHistory(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static ProcedureRequest convertProcedureRequest(ServiceRequest src) throws FHIRException {
        List<org.hl7.fhir.r4.model.Reference> performers;
        if (src == null) {
            return null;
        }
        ProcedureRequest tgt = new ProcedureRequest();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReplaces()) {
            tgt.addReplaces(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasRequisition() && src.hasRequisition()) {
            tgt.setRequisition(VersionConvertor_30_40.convertIdentifier(src.getRequisition()));
        }
        if (src.hasStatus() && src.hasStatus()) {
            tgt.setStatusElement(ProcedureRequest30_40.convertProcedureRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent() && src.hasIntent()) {
            tgt.setIntentElement(ProcedureRequest30_40.convertProcedureRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority() && src.hasPriority()) {
            tgt.setPriorityElement(ProcedureRequest30_40.convertProcedureRequestPriority(src.getPriorityElement()));
        }
        if (src.hasDoNotPerform() && src.hasDoNotPerformElement()) {
            tgt.setDoNotPerformElement(VersionConvertor_30_40.convertBoolean(src.getDoNotPerformElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode() && src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject() && src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter() && src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence() && src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_40.convertType(src.getOccurrence()));
        }
        if (src.hasAsNeeded() && src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_30_40.convertType(src.getAsNeeded()));
        }
        if (src.hasAuthoredOn() && src.hasAuthoredOnElement()) {
            tgt.setAuthoredOnElement(VersionConvertor_30_40.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(new ProcedureRequest.ProcedureRequestRequesterComponent(VersionConvertor_30_40.convertReference(src.getRequester())));
        }
        if (src.hasPerformerType() && src.hasPerformerType()) {
            tgt.setPerformerType(VersionConvertor_30_40.convertCodeableConcept(src.getPerformerType()));
        }
        if ((performers = src.getPerformer()).size() > 0) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(performers.get(0)));
            if (performers.size() > 1) {
                // empty if block
            }
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(VersionConvertor_30_40.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRelevantHistory()) {
            tgt.addRelevantHistory(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static Enumeration<ServiceRequest.ServiceRequestIntent> convertProcedureRequestIntent(org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ServiceRequest.ServiceRequestIntent> tgt = new Enumeration<ServiceRequest.ServiceRequestIntent>(new ServiceRequest.ServiceRequestIntentEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ProcedureRequest.ProcedureRequestIntent)((Object)src.getValue())) {
            case FILLERORDER: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.OPTION);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.ORIGINALORDER);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.PLAN);
                break;
            }
            case PROPOSAL: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.PROPOSAL);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.REFLEXORDER);
                break;
            }
            default: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestIntent> convertProcedureRequestIntent(Enumeration<ServiceRequest.ServiceRequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestIntent> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestIntent>(new ProcedureRequest.ProcedureRequestIntentEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ServiceRequest.ServiceRequestIntent)((Object)src.getValue())) {
            case DIRECTIVE: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestIntent.NULL);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestIntent.OPTION);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestIntent.ORIGINALORDER);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestIntent.PLAN);
                break;
            }
            case PROPOSAL: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestIntent.PROPOSAL);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestIntent.REFLEXORDER);
                break;
            }
            default: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestPriority> convertProcedureRequestPriority(Enumeration<ServiceRequest.ServiceRequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestPriority> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestPriority>(new ProcedureRequest.ProcedureRequestPriorityEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ServiceRequest.ServiceRequestPriority)((Object)src.getValue())) {
            case ASAP: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.ASAP);
                break;
            }
            case ROUTINE: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.ROUTINE);
                break;
            }
            case STAT: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.STAT);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.URGENT);
                break;
            }
            default: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ServiceRequest.ServiceRequestPriority> convertProcedureRequestPriority(org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ServiceRequest.ServiceRequestPriority> tgt = new Enumeration<ServiceRequest.ServiceRequestPriority>(new ServiceRequest.ServiceRequestPriorityEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ProcedureRequest.ProcedureRequestPriority)((Object)src.getValue())) {
            case ASAP: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestPriority.ASAP);
                break;
            }
            case ROUTINE: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestPriority.ROUTINE);
                break;
            }
            case STAT: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestPriority.STAT);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestPriority.URGENT);
                break;
            }
            default: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestStatus> convertProcedureRequestStatus(Enumeration<ServiceRequest.ServiceRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestStatus>(new ProcedureRequest.ProcedureRequestStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ServiceRequest.ServiceRequestStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.COMPLETED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.ENTEREDINERROR);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.SUSPENDED);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.CANCELLED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)ProcedureRequest.ProcedureRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ServiceRequest.ServiceRequestStatus> convertProcedureRequestStatus(org.hl7.fhir.dstu3.model.Enumeration<ProcedureRequest.ProcedureRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ServiceRequest.ServiceRequestStatus> tgt = new Enumeration<ServiceRequest.ServiceRequestStatus>(new ServiceRequest.ServiceRequestStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ProcedureRequest.ProcedureRequestStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.COMPLETED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.ENTEREDINERROR);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.ONHOLD);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)ServiceRequest.ServiceRequestStatus.NULL);
            }
        }
        return tgt;
    }
}

