/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Observation;

public class Observation30_40 {
    public static org.hl7.fhir.r4.model.Observation convertObservation(Observation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Observation tgt = new org.hl7.fhir.r4.model.Observation();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Observation30_40.convertObservationStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(VersionConvertor_30_40.convertInstant(src.getIssuedElement()));
        }
        for (Reference reference : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_30_40.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.addInterpretation(VersionConvertor_30_40.convertCodeableConcept(src.getInterpretation()));
        }
        if (src.hasComment()) {
            tgt.addNote().setText(src.getComment());
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_30_40.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation30_40.convertObservationReferenceRangeComponent(observationReferenceRangeComponent));
        }
        for (Observation.ObservationRelatedComponent observationRelatedComponent : src.getRelated()) {
            if (observationRelatedComponent.getType() == Observation.ObservationRelationshipType.HASMEMBER) {
                tgt.addHasMember(VersionConvertor_30_40.convertReference(observationRelatedComponent.getTarget()));
                continue;
            }
            if (observationRelatedComponent.getType() != Observation.ObservationRelationshipType.DERIVEDFROM) continue;
            tgt.addDerivedFrom(VersionConvertor_30_40.convertReference(observationRelatedComponent.getTarget()));
        }
        for (Observation.ObservationComponentComponent observationComponentComponent : src.getComponent()) {
            tgt.addComponent(Observation30_40.convertObservationComponentComponent(observationComponentComponent));
        }
        return tgt;
    }

    public static Observation convertObservation(org.hl7.fhir.r4.model.Observation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation tgt = new Observation();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Observation30_40.convertObservationStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(VersionConvertor_30_40.convertInstant(src.getIssuedElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_30_40.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.setInterpretation(VersionConvertor_30_40.convertCodeableConcept(src.getInterpretationFirstRep()));
        }
        if (src.hasNote()) {
            tgt.setComment(src.getNoteFirstRep().getText());
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_30_40.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation30_40.convertObservationReferenceRangeComponent(observationReferenceRangeComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getHasMember()) {
            tgt.addRelated(Observation30_40.convertObservationRelatedComponent(reference, Observation.ObservationRelationshipType.HASMEMBER));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getDerivedFrom()) {
            tgt.addRelated(Observation30_40.convertObservationRelatedComponent(reference, Observation.ObservationRelationshipType.DERIVEDFROM));
        }
        for (Observation.ObservationComponentComponent observationComponentComponent : src.getComponent()) {
            tgt.addComponent(Observation30_40.convertObservationComponentComponent(observationComponentComponent));
        }
        return tgt;
    }

    public static Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_30_40.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.setInterpretation(VersionConvertor_30_40.convertCodeableConcept(src.getInterpretationFirstRep()));
        }
        for (Observation.ObservationReferenceRangeComponent t : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation30_40.convertObservationReferenceRangeComponent(t));
        }
        return tgt;
    }

    public static Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_30_40.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.addInterpretation(VersionConvertor_30_40.convertCodeableConcept(src.getInterpretation()));
        }
        for (Observation.ObservationReferenceRangeComponent t : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation30_40.convertObservationReferenceRangeComponent(t));
        }
        return tgt;
    }

    public static Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_30_40.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_30_40.convertSimpleQuantity(src.getHigh()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept t : src.getAppliesTo()) {
            tgt.addAppliesTo(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_30_40.convertRange(src.getAge()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_30_40.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_30_40.convertSimpleQuantity(src.getHigh()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept t : src.getAppliesTo()) {
            tgt.addAppliesTo(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_30_40.convertRange(src.getAge()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Observation.ObservationRelatedComponent convertObservationRelatedComponent(org.hl7.fhir.r4.model.Reference src, Observation.ObservationRelationshipType type) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationRelatedComponent tgt = new Observation.ObservationRelatedComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        tgt.setType(type);
        tgt.setTarget(VersionConvertor_30_40.convertReference(src));
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationStatus> convertObservationStatus(Enumeration<Observation.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationStatus>(new Observation.ObservationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Observation.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Observation.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Observation.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Observation.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Observation.ObservationStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)Observation.ObservationStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Observation.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Observation.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Observation.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Observation.ObservationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Observation.ObservationStatus> convertObservationStatus(org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Observation.ObservationStatus> tgt = new Enumeration<Observation.ObservationStatus>(new Observation.ObservationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Observation.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Observation.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Observation.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Observation.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Observation.ObservationStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)Observation.ObservationStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Observation.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Observation.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Observation.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Observation.ObservationStatus.NULL);
            }
        }
        return tgt;
    }
}

