/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.HealthcareService;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.HealthcareService;

public class HealthcareService30_40 {
    public static HealthcareService convertHealthcareService(org.hl7.fhir.r4.model.HealthcareService src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService tgt = new HealthcareService();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_40.convertBoolean(src.getActiveElement()));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_30_40.convertReference(src.getProvidedBy()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_40.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetails(src.getExtraDetails());
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_30_40.convertAttachment(src.getPhoto()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint(contactPoint));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_30_40.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasEligibility()) {
            tgt.setEligibility(VersionConvertor_30_40.convertCodeableConcept(src.getEligibilityFirstRep().getCode()));
            if (src.getEligibilityFirstRep().hasComment()) {
                tgt.setEligibilityNoteElement(VersionConvertor_30_40.convertString(src.getCommentElement()));
            }
        }
        for (CodeableConcept codeableConcept : src.getProgram()) {
            tgt.addProgramName(codeableConcept.getText());
        }
        for (CodeableConcept codeableConcept : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentRequired()) {
            tgt.setAppointmentRequiredElement(VersionConvertor_30_40.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (HealthcareService.HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService30_40.convertHealthcareServiceAvailableTimeComponent(healthcareServiceAvailableTimeComponent));
        }
        for (HealthcareService.HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService30_40.convertHealthcareServiceNotAvailableComponent(healthcareServiceNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_30_40.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.HealthcareService convertHealthcareService(HealthcareService src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.HealthcareService tgt = new org.hl7.fhir.r4.model.HealthcareService();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_40.convertBoolean(src.getActiveElement()));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_30_40.convertReference(src.getProvidedBy()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_40.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetails(src.getExtraDetails());
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_30_40.convertAttachment(src.getPhoto()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint(contactPoint));
        }
        for (Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasEligibility() || src.hasEligibilityNote()) {
            HealthcareService.HealthcareServiceEligibilityComponent t = tgt.addEligibility();
            t.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getEligibility()));
            if (src.hasEligibilityNote()) {
                t.setComment(src.getEligibilityNote());
            }
        }
        for (StringType stringType : src.getProgramName()) {
            tgt.addProgram().setText((String)stringType.getValue());
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentRequired()) {
            tgt.setAppointmentRequiredElement(VersionConvertor_30_40.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (HealthcareService.HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService30_40.convertHealthcareServiceAvailableTimeComponent(healthcareServiceAvailableTimeComponent));
        }
        for (HealthcareService.HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService30_40.convertHealthcareServiceNotAvailableComponent(healthcareServiceNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_30_40.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService30_40::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(VersionConvertor_30_40.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_30_40.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_30_40.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService30_40::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(VersionConvertor_30_40.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_30_40.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_30_40.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_30_40.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_30_40.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static Enumeration<HealthcareService.DaysOfWeek> convertDaysOfWeek(org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<HealthcareService.DaysOfWeek> tgt = new Enumeration<HealthcareService.DaysOfWeek>(new HealthcareService.DaysOfWeekEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((HealthcareService.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek> convertDaysOfWeek(Enumeration<HealthcareService.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek> tgt = new org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek>(new HealthcareService.DaysOfWeekEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((HealthcareService.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }
}

