/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.GraphDefinition;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.GraphDefinition;
import org.hl7.fhir.r4.model.UsageContext;

public class GraphDefinition30_40 {
    public static Enumeration<GraphDefinition.CompartmentCode> convertCompartmentCode(org.hl7.fhir.dstu3.model.Enumeration<GraphDefinition.CompartmentCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<GraphDefinition.CompartmentCode> tgt = new Enumeration<GraphDefinition.CompartmentCode>(new GraphDefinition.CompartmentCodeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((GraphDefinition.CompartmentCode)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<GraphDefinition.CompartmentCode> convertCompartmentCode(Enumeration<GraphDefinition.CompartmentCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<GraphDefinition.CompartmentCode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<GraphDefinition.CompartmentCode>(new GraphDefinition.CompartmentCodeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((GraphDefinition.CompartmentCode)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)GraphDefinition.CompartmentCode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<GraphDefinition.GraphCompartmentRule> convertGraphCompartmentRule(org.hl7.fhir.dstu3.model.Enumeration<GraphDefinition.GraphCompartmentRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<GraphDefinition.GraphCompartmentRule> tgt = new Enumeration<GraphDefinition.GraphCompartmentRule>(new GraphDefinition.GraphCompartmentRuleEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((GraphDefinition.GraphCompartmentRule)((Object)src.getValue())) {
            case IDENTICAL: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.IDENTICAL);
                break;
            }
            case MATCHING: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.MATCHING);
                break;
            }
            case DIFFERENT: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.DIFFERENT);
                break;
            }
            case CUSTOM: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.CUSTOM);
                break;
            }
            default: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<GraphDefinition.GraphCompartmentRule> convertGraphCompartmentRule(Enumeration<GraphDefinition.GraphCompartmentRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<GraphDefinition.GraphCompartmentRule> tgt = new org.hl7.fhir.dstu3.model.Enumeration<GraphDefinition.GraphCompartmentRule>(new GraphDefinition.GraphCompartmentRuleEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((GraphDefinition.GraphCompartmentRule)((Object)src.getValue())) {
            case IDENTICAL: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.IDENTICAL);
                break;
            }
            case MATCHING: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.MATCHING);
                break;
            }
            case DIFFERENT: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.DIFFERENT);
                break;
            }
            case CUSTOM: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.CUSTOM);
                break;
            }
            default: {
                tgt.setValue((Object)GraphDefinition.GraphCompartmentRule.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.GraphDefinition convertGraphDefinition(GraphDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.GraphDefinition tgt = new org.hl7.fhir.dstu3.model.GraphDefinition();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_40.convertCode(src.getStartElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(src.getProfile());
        }
        for (GraphDefinition.GraphDefinitionLinkComponent graphDefinitionLinkComponent : src.getLink()) {
            tgt.addLink(GraphDefinition30_40.convertGraphDefinitionLinkComponent(graphDefinitionLinkComponent));
        }
        return tgt;
    }

    public static GraphDefinition convertGraphDefinition(org.hl7.fhir.dstu3.model.GraphDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition tgt = new GraphDefinition();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu3.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_40.convertCode(src.getStartElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(src.getProfile());
        }
        for (GraphDefinition.GraphDefinitionLinkComponent graphDefinitionLinkComponent : src.getLink()) {
            tgt.addLink(GraphDefinition30_40.convertGraphDefinitionLinkComponent(graphDefinitionLinkComponent));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkComponent convertGraphDefinitionLinkComponent(GraphDefinition.GraphDefinitionLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkComponent tgt = new GraphDefinition.GraphDefinitionLinkComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasSliceName()) {
            tgt.setSliceNameElement(VersionConvertor_30_40.convertString(src.getSliceNameElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_40.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_40.convertString(src.getMaxElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (GraphDefinition.GraphDefinitionLinkTargetComponent t : src.getTarget()) {
            tgt.addTarget(GraphDefinition30_40.convertGraphDefinitionLinkTargetComponent(t));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkComponent convertGraphDefinitionLinkComponent(GraphDefinition.GraphDefinitionLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkComponent tgt = new GraphDefinition.GraphDefinitionLinkComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_40.convertString(src.getPathElement()));
        }
        if (src.hasSliceName()) {
            tgt.setSliceNameElement(VersionConvertor_30_40.convertString(src.getSliceNameElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_40.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_40.convertString(src.getMaxElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (GraphDefinition.GraphDefinitionLinkTargetComponent t : src.getTarget()) {
            tgt.addTarget(GraphDefinition30_40.convertGraphDefinitionLinkTargetComponent(t));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent convertGraphDefinitionLinkTargetCompartmentComponent(GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(GraphDefinition30_40.convertCompartmentCode(src.getCodeElement()));
        }
        if (src.hasRule()) {
            tgt.setRuleElement(GraphDefinition30_40.convertGraphCompartmentRule(src.getRuleElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_40.convertString(src.getExpressionElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent convertGraphDefinitionLinkTargetCompartmentComponent(GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(GraphDefinition30_40.convertCompartmentCode(src.getCodeElement()));
        }
        if (src.hasRule()) {
            tgt.setRuleElement(GraphDefinition30_40.convertGraphCompartmentRule(src.getRuleElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_40.convertString(src.getExpressionElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetComponent convertGraphDefinitionLinkTargetComponent(GraphDefinition.GraphDefinitionLinkTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(src.getProfile());
        }
        for (GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent graphDefinitionLinkTargetCompartmentComponent : src.getCompartment()) {
            tgt.addCompartment(GraphDefinition30_40.convertGraphDefinitionLinkTargetCompartmentComponent(graphDefinitionLinkTargetCompartmentComponent));
        }
        for (GraphDefinition.GraphDefinitionLinkComponent graphDefinitionLinkComponent : src.getLink()) {
            tgt.addLink(GraphDefinition30_40.convertGraphDefinitionLinkComponent(graphDefinitionLinkComponent));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetComponent convertGraphDefinitionLinkTargetComponent(GraphDefinition.GraphDefinitionLinkTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_40.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(src.getProfile());
        }
        for (GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent graphDefinitionLinkTargetCompartmentComponent : src.getCompartment()) {
            tgt.addCompartment(GraphDefinition30_40.convertGraphDefinitionLinkTargetCompartmentComponent(graphDefinitionLinkTargetCompartmentComponent));
        }
        for (GraphDefinition.GraphDefinitionLinkComponent graphDefinitionLinkComponent : src.getLink()) {
            tgt.addLink(GraphDefinition30_40.convertGraphDefinitionLinkComponent(graphDefinitionLinkComponent));
        }
        return tgt;
    }
}

