/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Goal;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.Reference;

public class Goal30_40 {
    public static Goal convertGoal(org.hl7.fhir.r4.model.Goal src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Goal tgt = new Goal();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasLifecycleStatus()) {
            tgt.setStatusElement(Goal30_40.convertGoalStatus(src.getLifecycleStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_40.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(VersionConvertor_30_40.convertCodeableConcept(src.getDescription()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasStart()) {
            tgt.setStart(VersionConvertor_30_40.convertType(src.getStart()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(Goal30_40.convertGoalTargetComponent(src.getTargetFirstRep()));
        }
        if (src.hasStatusDate()) {
            tgt.setStatusDateElement(VersionConvertor_30_40.convertDate(src.getStatusDateElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReasonElement(VersionConvertor_30_40.convertString(src.getStatusReasonElement()));
        }
        if (src.hasExpressedBy()) {
            tgt.setExpressedBy(VersionConvertor_30_40.convertReference(src.getExpressedBy()));
        }
        for (Reference reference : src.getAddresses()) {
            tgt.addAddresses(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (CodeableConcept codeableConcept : src.getOutcomeCode()) {
            tgt.addOutcomeCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getOutcomeReference()) {
            tgt.addOutcomeReference(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Goal convertGoal(Goal src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Goal tgt = new org.hl7.fhir.r4.model.Goal();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setLifecycleStatusElement(Goal30_40.convertGoalStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_40.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(VersionConvertor_30_40.convertCodeableConcept(src.getDescription()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasStart()) {
            tgt.setStart(VersionConvertor_30_40.convertType(src.getStart()));
        }
        if (src.hasTarget()) {
            tgt.addTarget(Goal30_40.convertGoalTargetComponent(src.getTarget()));
        }
        if (src.hasStatusDate()) {
            tgt.setStatusDateElement(VersionConvertor_30_40.convertDate(src.getStatusDateElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReasonElement(VersionConvertor_30_40.convertString(src.getStatusReasonElement()));
        }
        if (src.hasExpressedBy()) {
            tgt.setExpressedBy(VersionConvertor_30_40.convertReference(src.getExpressedBy()));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getAddresses()) {
            tgt.addAddresses(VersionConvertor_30_40.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getOutcomeCode()) {
            tgt.addOutcomeCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getOutcomeReference()) {
            tgt.addOutcomeReference(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static Enumeration<Goal.GoalLifecycleStatus> convertGoalStatus(org.hl7.fhir.dstu3.model.Enumeration<Goal.GoalStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Goal.GoalLifecycleStatus> tgt = new Enumeration<Goal.GoalLifecycleStatus>(new Goal.GoalLifecycleStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Goal.GoalStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.PROPOSED);
                break;
            }
            case ACCEPTED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ACCEPTED);
                break;
            }
            case PLANNED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.PLANNED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ACTIVE);
                break;
            }
            case ONTARGET: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ACTIVE);
                break;
            }
            case AHEADOFTARGET: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ACTIVE);
                break;
            }
            case BEHINDTARGET: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ACTIVE);
                break;
            }
            case SUSTAINING: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ACTIVE);
                break;
            }
            case ACHIEVED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.COMPLETED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ONHOLD);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ENTEREDINERROR);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.REJECTED);
                break;
            }
            default: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Goal.GoalStatus> convertGoalStatus(Enumeration<Goal.GoalLifecycleStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Goal.GoalStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Goal.GoalStatus>(new Goal.GoalStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Goal.GoalLifecycleStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)Goal.GoalStatus.PROPOSED);
                break;
            }
            case ACCEPTED: {
                tgt.setValue((Object)Goal.GoalStatus.ACCEPTED);
                break;
            }
            case PLANNED: {
                tgt.setValue((Object)Goal.GoalStatus.PLANNED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Goal.GoalStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Goal.GoalStatus.ACHIEVED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Goal.GoalStatus.ONHOLD);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Goal.GoalStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Goal.GoalStatus.ENTEREDINERROR);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Goal.GoalStatus.REJECTED);
                break;
            }
            default: {
                tgt.setValue((Object)Goal.GoalStatus.NULL);
            }
        }
        return tgt;
    }

    public static Goal.GoalTargetComponent convertGoalTargetComponent(Goal.GoalTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Goal.GoalTargetComponent tgt = new Goal.GoalTargetComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasMeasure()) {
            tgt.setMeasure(VersionConvertor_30_40.convertCodeableConcept(src.getMeasure()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(VersionConvertor_30_40.convertType(src.getDetail()));
        }
        if (src.hasDue()) {
            tgt.setDue(VersionConvertor_30_40.convertType(src.getDue()));
        }
        return tgt;
    }

    public static Goal.GoalTargetComponent convertGoalTargetComponent(Goal.GoalTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Goal.GoalTargetComponent tgt = new Goal.GoalTargetComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasMeasure()) {
            tgt.setMeasure(VersionConvertor_30_40.convertCodeableConcept(src.getMeasure()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(VersionConvertor_30_40.convertType(src.getDetail()));
        }
        if (src.hasDue()) {
            tgt.setDue(VersionConvertor_30_40.convertType(src.getDue()));
        }
        return tgt;
    }
}

