/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Reference;

public class DocumentReference30_40 {
    public static org.hl7.fhir.r4.model.InstantType convertDateTimeToInstant(DateTimeType src) throws FHIRException {
        org.hl7.fhir.r4.model.InstantType tgt = new org.hl7.fhir.r4.model.InstantType(src.getValueAsString());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DocumentReference convertDocumentReference(org.hl7.fhir.r4.model.DocumentReference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference tgt = new DocumentReference();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_30_40.convertIdentifier(src.getMasterIdentifier()));
        }
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DocumentReference30_40.convertDocumentReferenceStatus(src.getStatusElement()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatusElement(DocumentReference30_40.convertReferredDocumentStatus(src.getDocStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasCategory()) {
            tgt.setClass_(VersionConvertor_30_40.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasDateElement()) {
            tgt.setCreatedElement(DocumentReference30_40.convertInstantToDateTime(src.getDateElement()));
        }
        if (src.hasAuthenticator()) {
            tgt.setAuthenticator(VersionConvertor_30_40.convertReference(src.getAuthenticator()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_30_40.convertReference(src.getCustodian()));
        }
        for (DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(DocumentReference30_40.convertDocumentReferenceRelatesToComponent(documentReferenceRelatesToComponent));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (CodeableConcept codeableConcept : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (DocumentReference.DocumentReferenceContentComponent documentReferenceContentComponent : src.getContent()) {
            tgt.addContent(DocumentReference30_40.convertDocumentReferenceContentComponent(documentReferenceContentComponent));
        }
        if (src.hasContext()) {
            tgt.setContext(DocumentReference30_40.convertDocumentReferenceContextComponent(src.getContext()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.DocumentReference convertDocumentReference(DocumentReference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.DocumentReference tgt = new org.hl7.fhir.r4.model.DocumentReference();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_30_40.convertIdentifier(src.getMasterIdentifier()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DocumentReference30_40.convertDocumentReferenceStatus(src.getStatusElement()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatusElement(DocumentReference30_40.convertReferredDocumentStatus(src.getDocStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasClass_()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(src.getClass_()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasCreated()) {
            tgt.setDateElement(DocumentReference30_40.convertDateTimeToInstant(src.getCreatedElement()));
        }
        if (src.hasAuthenticator()) {
            tgt.setAuthenticator(VersionConvertor_30_40.convertReference(src.getAuthenticator()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_30_40.convertReference(src.getCustodian()));
        }
        for (DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(DocumentReference30_40.convertDocumentReferenceRelatesToComponent(documentReferenceRelatesToComponent));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (DocumentReference.DocumentReferenceContentComponent documentReferenceContentComponent : src.getContent()) {
            tgt.addContent(DocumentReference30_40.convertDocumentReferenceContentComponent(documentReferenceContentComponent));
        }
        if (src.hasContext()) {
            tgt.setContext(DocumentReference30_40.convertDocumentReferenceContextComponent(src.getContext()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAttachment()) {
            tgt.setAttachment(VersionConvertor_30_40.convertAttachment(src.getAttachment()));
        }
        if (src.hasFormat()) {
            tgt.setFormat(VersionConvertor_30_40.convertCoding(src.getFormat()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAttachment()) {
            tgt.setAttachment(VersionConvertor_30_40.convertAttachment(src.getAttachment()));
        }
        if (src.hasFormat()) {
            tgt.setFormat(VersionConvertor_30_40.convertCoding(src.getFormat()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getEncounterFirstRep()));
        }
        for (CodeableConcept codeableConcept : src.getEvent()) {
            tgt.addEvent(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(VersionConvertor_30_40.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(VersionConvertor_30_40.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(VersionConvertor_30_40.convertReference(src.getSourcePatientInfo()));
        }
        for (Reference reference : src.getRelated()) {
            tgt.addRelated(DocumentReference30_40.convertDocumentReferenceContextRelatedComponent(reference));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasEncounter()) {
            tgt.addEncounter(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getEvent()) {
            tgt.addEvent(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(VersionConvertor_30_40.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(VersionConvertor_30_40.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(VersionConvertor_30_40.convertReference(src.getSourcePatientInfo()));
        }
        for (DocumentReference.DocumentReferenceContextRelatedComponent documentReferenceContextRelatedComponent : src.getRelated()) {
            tgt.addRelated(DocumentReference30_40.convertDocumentReferenceContextRelatedComponent(documentReferenceContextRelatedComponent));
        }
        return tgt;
    }

    public static Reference convertDocumentReferenceContextRelatedComponent(DocumentReference.DocumentReferenceContextRelatedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Reference tgt = VersionConvertor_30_40.convertReference(src.getRef());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextRelatedComponent convertDocumentReferenceContextRelatedComponent(Reference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContextRelatedComponent tgt = new DocumentReference.DocumentReferenceContextRelatedComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        tgt.setRef(VersionConvertor_30_40.convertReference(src));
        return tgt;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_40.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Enumerations.DocumentReferenceStatus> convertDocumentReferenceStatus(Enumeration<Enumerations.DocumentReferenceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Enumerations.DocumentReferenceStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DocumentReferenceStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.CURRENT);
                break;
            }
            case SUPERSEDED: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.SUPERSEDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.DocumentReferenceStatus> convertDocumentReferenceStatus(org.hl7.fhir.dstu3.model.Enumeration<Enumerations.DocumentReferenceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.DocumentReferenceStatus> tgt = new Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DocumentReferenceStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.CURRENT);
                break;
            }
            case SUPERSEDED: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.SUPERSEDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DocumentReferenceStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.DateTimeType convertInstantToDateTime(InstantType src) throws FHIRException {
        org.hl7.fhir.r4.model.DateTimeType tgt = new org.hl7.fhir.r4.model.DateTimeType(src.getValueAsString());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateTimeType convertInstantToDateTime(org.hl7.fhir.r4.model.InstantType src) throws FHIRException {
        DateTimeType tgt = new DateTimeType(src.getValueAsString());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<DocumentReference.ReferredDocumentStatus> convertReferredDocumentStatus(Enumeration<DocumentReference.ReferredDocumentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<DocumentReference.ReferredDocumentStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<DocumentReference.ReferredDocumentStatus>(new DocumentReference.ReferredDocumentStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((DocumentReference.ReferredDocumentStatus)((Object)src.getValue())) {
            case PRELIMINARY: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DocumentReference.ReferredDocumentStatus> convertReferredDocumentStatus(org.hl7.fhir.dstu3.model.Enumeration<DocumentReference.ReferredDocumentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DocumentReference.ReferredDocumentStatus> tgt = new Enumeration<DocumentReference.ReferredDocumentStatus>(new DocumentReference.ReferredDocumentStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((DocumentReference.ReferredDocumentStatus)((Object)src.getValue())) {
            case PRELIMINARY: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.NULL);
            }
        }
        return tgt;
    }
}

