/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.DiagnosticReport;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Reference;

public class DiagnosticReport30_40 {
    public static DiagnosticReport convertDiagnosticReport(org.hl7.fhir.dstu3.model.DiagnosticReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DiagnosticReport tgt = new DiagnosticReport();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DiagnosticReport30_40.convertDiagnosticReportStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(VersionConvertor_30_40.convertInstant(src.getIssuedElement()));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getResult()) {
            tgt.addResult(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getImagingStudy()) {
            tgt.addImagingStudy(VersionConvertor_30_40.convertReference(reference));
        }
        for (DiagnosticReport.DiagnosticReportImageComponent diagnosticReportImageComponent : src.getImage()) {
            tgt.addMedia(DiagnosticReport30_40.convertDiagnosticReportImageComponent(diagnosticReportImageComponent));
        }
        if (src.hasConclusion()) {
            tgt.setConclusionElement(VersionConvertor_30_40.convertString(src.getConclusionElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCodedDiagnosis()) {
            tgt.addConclusionCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Attachment attachment : src.getPresentedForm()) {
            tgt.addPresentedForm(VersionConvertor_30_40.convertAttachment(attachment));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DiagnosticReport convertDiagnosticReport(DiagnosticReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.DiagnosticReport tgt = new org.hl7.fhir.dstu3.model.DiagnosticReport();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DiagnosticReport30_40.convertDiagnosticReportStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(VersionConvertor_30_40.convertInstant(src.getIssuedElement()));
        }
        for (Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getResult()) {
            tgt.addResult(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getImagingStudy()) {
            tgt.addImagingStudy(VersionConvertor_30_40.convertReference(reference));
        }
        for (DiagnosticReport.DiagnosticReportMediaComponent diagnosticReportMediaComponent : src.getMedia()) {
            tgt.addImage(DiagnosticReport30_40.convertDiagnosticReportImageComponent(diagnosticReportMediaComponent));
        }
        if (src.hasConclusion()) {
            tgt.setConclusionElement(VersionConvertor_30_40.convertString(src.getConclusionElement()));
        }
        for (CodeableConcept codeableConcept : src.getConclusionCode()) {
            tgt.addCodedDiagnosis(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Attachment attachment : src.getPresentedForm()) {
            tgt.addPresentedForm(VersionConvertor_30_40.convertAttachment(attachment));
        }
        return tgt;
    }

    public static DiagnosticReport.DiagnosticReportMediaComponent convertDiagnosticReportImageComponent(DiagnosticReport.DiagnosticReportImageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DiagnosticReport.DiagnosticReportMediaComponent tgt = new DiagnosticReport.DiagnosticReportMediaComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_40.convertString(src.getCommentElement()));
        }
        if (src.hasLink()) {
            tgt.setLink(VersionConvertor_30_40.convertReference(src.getLink()));
        }
        return tgt;
    }

    public static DiagnosticReport.DiagnosticReportImageComponent convertDiagnosticReportImageComponent(DiagnosticReport.DiagnosticReportMediaComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DiagnosticReport.DiagnosticReportImageComponent tgt = new DiagnosticReport.DiagnosticReportImageComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_40.convertString(src.getCommentElement()));
        }
        if (src.hasLink()) {
            tgt.setLink(VersionConvertor_30_40.convertReference(src.getLink()));
        }
        return tgt;
    }

    public static Enumeration<DiagnosticReport.DiagnosticReportStatus> convertDiagnosticReportStatus(org.hl7.fhir.dstu3.model.Enumeration<DiagnosticReport.DiagnosticReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DiagnosticReport.DiagnosticReportStatus> tgt = new Enumeration<DiagnosticReport.DiagnosticReportStatus>(new DiagnosticReport.DiagnosticReportStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((DiagnosticReport.DiagnosticReportStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.REGISTERED);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.PARTIAL);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CORRECTED);
                break;
            }
            case APPENDED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.APPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<DiagnosticReport.DiagnosticReportStatus> convertDiagnosticReportStatus(Enumeration<DiagnosticReport.DiagnosticReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<DiagnosticReport.DiagnosticReportStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<DiagnosticReport.DiagnosticReportStatus>(new DiagnosticReport.DiagnosticReportStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((DiagnosticReport.DiagnosticReportStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.REGISTERED);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.PARTIAL);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CORRECTED);
                break;
            }
            case APPENDED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.APPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.NULL);
            }
        }
        return tgt;
    }
}

