/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Consent;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Consent;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;

public class Consent30_40 {
    public static org.hl7.fhir.r4.model.Consent convertConsent(Consent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Consent tgt = new org.hl7.fhir.r4.model.Consent();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Consent30_40.convertConsentState(src.getStatusElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasDateTime()) {
            tgt.setDateTimeElement(VersionConvertor_30_40.convertDateTime(src.getDateTimeElement()));
        }
        for (Reference reference : src.getConsentingParty()) {
            tgt.addPerformer(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getOrganization()) {
            tgt.addOrganization(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertType(src.getSource()));
        }
        for (Consent.ConsentPolicyComponent consentPolicyComponent : src.getPolicy()) {
            tgt.addPolicy(Consent30_40.convertConsentPolicyComponent(consentPolicyComponent));
        }
        if (src.hasPolicyRule()) {
            Coding c = new Coding();
            c.setSystem("urn:ietf:rfc:3986");
            c.setCode(src.getPolicyRule());
            tgt.setPolicyRule(new CodeableConcept(c));
        }
        if (src.hasSecurityLabel() || src.hasPeriod() || src.hasActor() || src.hasAction() || src.hasPurpose() || src.hasDataPeriod() || src.hasData() || src.hasExcept()) {
            Consent.provisionComponent pc = new Consent.provisionComponent();
            if (src.hasPeriod()) {
                pc.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
            }
            for (Consent.ConsentActorComponent consentActorComponent : src.getActor()) {
                pc.addActor(Consent30_40.convertConsentActorComponent(consentActorComponent));
            }
            for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getAction()) {
                pc.addAction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
            }
            for (org.hl7.fhir.dstu3.model.Coding coding : src.getSecurityLabel()) {
                pc.addSecurityLabel(VersionConvertor_30_40.convertCoding(coding));
            }
            for (org.hl7.fhir.dstu3.model.Coding coding : src.getPurpose()) {
                pc.addPurpose(VersionConvertor_30_40.convertCoding(coding));
            }
            if (src.hasDataPeriod()) {
                pc.setDataPeriod(VersionConvertor_30_40.convertPeriod(src.getDataPeriod()));
            }
            for (Consent.ConsentDataComponent consentDataComponent : src.getData()) {
                pc.addData(Consent30_40.convertConsentDataComponent(consentDataComponent));
            }
            for (Consent.ExceptComponent exceptComponent : src.getExcept()) {
                pc.addProvision(Consent30_40.convertExceptComponent(exceptComponent));
            }
            tgt.setProvision(pc);
        }
        return tgt;
    }

    public static Consent convertConsent(org.hl7.fhir.r4.model.Consent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent tgt = new Consent();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        List<Identifier> identifier = src.getIdentifier();
        if (identifier.size() > 0) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(identifier.get(0)));
            if (identifier.size() > 1) {
                // empty if block
            }
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Consent30_40.convertConsentState(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasDateTime()) {
            tgt.setDateTimeElement(VersionConvertor_30_40.convertDateTime(src.getDateTimeElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPerformer()) {
            tgt.addConsentingParty(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getOrganization()) {
            tgt.addOrganization(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertType(src.getSource()));
        }
        for (Consent.ConsentPolicyComponent consentPolicyComponent : src.getPolicy()) {
            tgt.addPolicy(Consent30_40.convertConsentPolicyComponent(consentPolicyComponent));
        }
        if (src.hasPolicyRule()) {
            for (Coding coding : src.getPolicyRule().getCoding()) {
                if (!"urn:ietf:rfc:3986".equals(coding.getSystem())) continue;
                tgt.setPolicyRule(coding.getCode());
                break;
            }
        }
        if (src.hasProvision()) {
            Consent.provisionComponent p = src.getProvision();
            if (p.hasPeriod()) {
                tgt.setPeriod(VersionConvertor_30_40.convertPeriod(p.getPeriod()));
            }
            for (Consent.provisionActorComponent provisionActorComponent2 : p.getActor()) {
                tgt.addActor(Consent30_40.convertConsentActorComponent(provisionActorComponent2));
            }
            for (CodeableConcept codeableConcept : p.getAction()) {
                tgt.addAction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
            }
            for (Coding coding : p.getSecurityLabel()) {
                tgt.addSecurityLabel(VersionConvertor_30_40.convertCoding(coding));
            }
            for (Coding coding : p.getPurpose()) {
                tgt.addPurpose(VersionConvertor_30_40.convertCoding(coding));
            }
            if (p.hasDataPeriod()) {
                tgt.setDataPeriod(VersionConvertor_30_40.convertPeriod(p.getDataPeriod()));
            }
            for (Consent.provisionDataComponent provisionDataComponent2 : p.getData()) {
                tgt.addData(Consent30_40.convertConsentDataComponent(provisionDataComponent2));
            }
            for (Consent.provisionComponent provisionComponent2 : p.getProvision()) {
                tgt.addExcept(Consent30_40.convertExceptComponent(provisionComponent2));
            }
        }
        return tgt;
    }

    public static Consent.ConsentActorComponent convertConsentActorComponent(Consent.provisionActorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentActorComponent tgt = new Consent.ConsentActorComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static Consent.provisionActorComponent convertConsentActorComponent(Consent.ConsentActorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.provisionActorComponent tgt = new Consent.provisionActorComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static Consent.provisionDataComponent convertConsentDataComponent(Consent.ConsentDataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.provisionDataComponent tgt = new Consent.provisionDataComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasMeaning()) {
            tgt.setMeaningElement(Consent30_40.convertConsentDataMeaning(src.getMeaningElement()));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static Consent.ConsentDataComponent convertConsentDataComponent(Consent.provisionDataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentDataComponent tgt = new Consent.ConsentDataComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasMeaning()) {
            tgt.setMeaningElement(Consent30_40.convertConsentDataMeaning(src.getMeaningElement()));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static Enumeration<Consent.ConsentDataMeaning> convertConsentDataMeaning(org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentDataMeaning> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Consent.ConsentDataMeaning> tgt = new Enumeration<Consent.ConsentDataMeaning>(new Consent.ConsentDataMeaningEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentDataMeaning)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.INSTANCE);
                break;
            }
            case RELATED: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.RELATED);
                break;
            }
            case DEPENDENTS: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.DEPENDENTS);
                break;
            }
            case AUTHOREDBY: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.AUTHOREDBY);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentDataMeaning> convertConsentDataMeaning(Enumeration<Consent.ConsentDataMeaning> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentDataMeaning> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentDataMeaning>(new Consent.ConsentDataMeaningEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentDataMeaning)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.INSTANCE);
                break;
            }
            case RELATED: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.RELATED);
                break;
            }
            case DEPENDENTS: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.DEPENDENTS);
                break;
            }
            case AUTHOREDBY: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.AUTHOREDBY);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Consent.ConsentProvisionType> convertConsentExceptType(org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentExceptType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Consent.ConsentProvisionType> tgt = new Enumeration<Consent.ConsentProvisionType>(new Consent.ConsentProvisionTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentExceptType)((Object)src.getValue())) {
            case DENY: {
                tgt.setValue((Object)Consent.ConsentProvisionType.DENY);
                break;
            }
            case PERMIT: {
                tgt.setValue((Object)Consent.ConsentProvisionType.PERMIT);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentProvisionType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentExceptType> convertConsentExceptType(Enumeration<Consent.ConsentProvisionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentExceptType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentExceptType>(new Consent.ConsentExceptTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentProvisionType)((Object)src.getValue())) {
            case DENY: {
                tgt.setValue((Object)Consent.ConsentExceptType.DENY);
                break;
            }
            case PERMIT: {
                tgt.setValue((Object)Consent.ConsentExceptType.PERMIT);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentExceptType.NULL);
            }
        }
        return tgt;
    }

    public static Consent.ConsentPolicyComponent convertConsentPolicyComponent(Consent.ConsentPolicyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentPolicyComponent tgt = new Consent.ConsentPolicyComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAuthority()) {
            tgt.setAuthorityElement(VersionConvertor_30_40.convertUri(src.getAuthorityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_30_40.convertUri(src.getUriElement()));
        }
        return tgt;
    }

    public static Consent.ConsentPolicyComponent convertConsentPolicyComponent(Consent.ConsentPolicyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentPolicyComponent tgt = new Consent.ConsentPolicyComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasAuthority()) {
            tgt.setAuthorityElement(VersionConvertor_30_40.convertUri(src.getAuthorityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_30_40.convertUri(src.getUriElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentState> convertConsentState(Enumeration<Consent.ConsentState> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentState> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentState>(new Consent.ConsentStateEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentState)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Consent.ConsentState.DRAFT);
                break;
            }
            case PROPOSED: {
                tgt.setValue((Object)Consent.ConsentState.PROPOSED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Consent.ConsentState.ACTIVE);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Consent.ConsentState.REJECTED);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Consent.ConsentState.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Consent.ConsentState.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentState.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Consent.ConsentState> convertConsentState(org.hl7.fhir.dstu3.model.Enumeration<Consent.ConsentState> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Consent.ConsentState> tgt = new Enumeration<Consent.ConsentState>(new Consent.ConsentStateEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentState)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Consent.ConsentState.DRAFT);
                break;
            }
            case PROPOSED: {
                tgt.setValue((Object)Consent.ConsentState.PROPOSED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Consent.ConsentState.ACTIVE);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Consent.ConsentState.REJECTED);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Consent.ConsentState.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Consent.ConsentState.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentState.NULL);
            }
        }
        return tgt;
    }

    public static Consent.ExceptActorComponent convertExceptActorComponent(Consent.provisionActorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ExceptActorComponent tgt = new Consent.ExceptActorComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static Consent.provisionActorComponent convertExceptActorComponent(Consent.ExceptActorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.provisionActorComponent tgt = new Consent.provisionActorComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static Consent.ExceptComponent convertExceptComponent(Consent.provisionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ExceptComponent tgt = new Consent.ExceptComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Consent30_40.convertConsentExceptType(src.getTypeElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (Consent.provisionActorComponent provisionActorComponent2 : src.getActor()) {
            tgt.addActor(Consent30_40.convertExceptActorComponent(provisionActorComponent2));
        }
        for (CodeableConcept codeableConcept : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Coding coding : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_30_40.convertCoding(coding));
        }
        for (Coding coding : src.getPurpose()) {
            tgt.addPurpose(VersionConvertor_30_40.convertCoding(coding));
        }
        for (Coding coding : src.getClass_()) {
            tgt.addClass_(VersionConvertor_30_40.convertCoding(coding));
        }
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(codeableConcept));
        }
        if (src.hasDataPeriod()) {
            tgt.setDataPeriod(VersionConvertor_30_40.convertPeriod(src.getDataPeriod()));
        }
        for (Consent.provisionDataComponent provisionDataComponent2 : src.getData()) {
            tgt.addData(Consent30_40.convertExceptDataComponent(provisionDataComponent2));
        }
        return tgt;
    }

    public static Consent.provisionComponent convertExceptComponent(Consent.ExceptComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.provisionComponent tgt = new Consent.provisionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Consent30_40.convertConsentExceptType(src.getTypeElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (Consent.ExceptActorComponent exceptActorComponent : src.getActor()) {
            tgt.addActor(Consent30_40.convertExceptActorComponent(exceptActorComponent));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getAction()) {
            tgt.addAction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.Coding coding : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_30_40.convertCoding(coding));
        }
        for (org.hl7.fhir.dstu3.model.Coding coding : src.getPurpose()) {
            tgt.addPurpose(VersionConvertor_30_40.convertCoding(coding));
        }
        for (org.hl7.fhir.dstu3.model.Coding coding : src.getClass_()) {
            tgt.addClass_(VersionConvertor_30_40.convertCoding(coding));
        }
        for (org.hl7.fhir.dstu3.model.Coding coding : src.getCode()) {
            tgt.addCode(new CodeableConcept(VersionConvertor_30_40.convertCoding(coding)));
        }
        if (src.hasDataPeriod()) {
            tgt.setDataPeriod(VersionConvertor_30_40.convertPeriod(src.getDataPeriod()));
        }
        for (Consent.ExceptDataComponent exceptDataComponent : src.getData()) {
            tgt.addData(Consent30_40.convertExceptDataComponent(exceptDataComponent));
        }
        return tgt;
    }

    public static Consent.ExceptDataComponent convertExceptDataComponent(Consent.provisionDataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ExceptDataComponent tgt = new Consent.ExceptDataComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasMeaning()) {
            tgt.setMeaningElement(Consent30_40.convertConsentDataMeaning(src.getMeaningElement()));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static Consent.provisionDataComponent convertExceptDataComponent(Consent.ExceptDataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.provisionDataComponent tgt = new Consent.provisionDataComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasMeaning()) {
            tgt.setMeaningElement(Consent30_40.convertConsentDataMeaning(src.getMeaningElement()));
        }
        if (src.hasReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        return tgt;
    }
}

