/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.ClinicalImpression;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.ClinicalImpression;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;

public class ClinicalImpression30_40 {
    public static org.hl7.fhir.dstu3.model.ClinicalImpression convertClinicalImpression(ClinicalImpression src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ClinicalImpression tgt = new org.hl7.fhir.dstu3.model.ClinicalImpression();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ClinicalImpression30_40.convertClinicalImpressionStatus(src.getStatusElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasAssessor()) {
            tgt.setAssessor(VersionConvertor_30_40.convertReference(src.getAssessor()));
        }
        if (src.hasPrevious()) {
            tgt.setPrevious(VersionConvertor_30_40.convertReference(src.getPrevious()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getProblem()) {
            tgt.addProblem(VersionConvertor_30_40.convertReference(reference));
        }
        for (ClinicalImpression.ClinicalImpressionInvestigationComponent clinicalImpressionInvestigationComponent : src.getInvestigation()) {
            tgt.addInvestigation(ClinicalImpression30_40.convertClinicalImpressionInvestigationComponent(clinicalImpressionInvestigationComponent));
        }
        for (org.hl7.fhir.r4.model.UriType uriType : src.getProtocol()) {
            tgt.addProtocol((String)uriType.getValue());
        }
        if (src.hasSummary()) {
            tgt.setSummaryElement(VersionConvertor_30_40.convertString(src.getSummaryElement()));
        }
        for (ClinicalImpression.ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : src.getFinding()) {
            tgt.addFinding(ClinicalImpression30_40.convertClinicalImpressionFindingComponent(clinicalImpressionFindingComponent));
        }
        for (CodeableConcept codeableConcept : src.getPrognosisCodeableConcept()) {
            tgt.addPrognosisCodeableConcept(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPrognosisReference()) {
            tgt.addPrognosisReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static ClinicalImpression convertClinicalImpression(org.hl7.fhir.dstu3.model.ClinicalImpression src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression tgt = new ClinicalImpression();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ClinicalImpression30_40.convertClinicalImpressionStatus(src.getStatusElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasAssessor()) {
            tgt.setAssessor(VersionConvertor_30_40.convertReference(src.getAssessor()));
        }
        if (src.hasPrevious()) {
            tgt.setPrevious(VersionConvertor_30_40.convertReference(src.getPrevious()));
        }
        for (Reference reference : src.getProblem()) {
            tgt.addProblem(VersionConvertor_30_40.convertReference(reference));
        }
        for (ClinicalImpression.ClinicalImpressionInvestigationComponent clinicalImpressionInvestigationComponent : src.getInvestigation()) {
            tgt.addInvestigation(ClinicalImpression30_40.convertClinicalImpressionInvestigationComponent(clinicalImpressionInvestigationComponent));
        }
        for (UriType uriType : src.getProtocol()) {
            tgt.addProtocol((String)uriType.getValue());
        }
        if (src.hasSummary()) {
            tgt.setSummaryElement(VersionConvertor_30_40.convertString(src.getSummaryElement()));
        }
        for (ClinicalImpression.ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : src.getFinding()) {
            tgt.addFinding(ClinicalImpression30_40.convertClinicalImpressionFindingComponent(clinicalImpressionFindingComponent));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getPrognosisCodeableConcept()) {
            tgt.addPrognosisCodeableConcept(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getPrognosisReference()) {
            tgt.addPrognosisReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionFindingComponent convertClinicalImpressionFindingComponent(ClinicalImpression.ClinicalImpressionFindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionFindingComponent tgt = new ClinicalImpression.ClinicalImpressionFindingComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasItemCodeableConcept()) {
            tgt.setItemCodeableConcept(VersionConvertor_30_40.convertCodeableConcept(src.getItemCodeableConcept()));
        }
        if (src.hasItemReference()) {
            tgt.setItemReference(VersionConvertor_30_40.convertReference(src.getItemReference()));
        }
        if (src.hasBasis()) {
            tgt.setBasisElement(VersionConvertor_30_40.convertString(src.getBasisElement()));
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionFindingComponent convertClinicalImpressionFindingComponent(ClinicalImpression.ClinicalImpressionFindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionFindingComponent tgt = new ClinicalImpression.ClinicalImpressionFindingComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasItemCodeableConcept()) {
            tgt.setItem(VersionConvertor_30_40.convertType(src.getItemCodeableConcept()));
        } else if (src.hasItemReference()) {
            tgt.setItem(VersionConvertor_30_40.convertType(src.getItemReference()));
        }
        if (src.hasBasis()) {
            tgt.setBasisElement(VersionConvertor_30_40.convertString(src.getBasisElement()));
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionInvestigationComponent convertClinicalImpressionInvestigationComponent(ClinicalImpression.ClinicalImpressionInvestigationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionInvestigationComponent tgt = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        for (Reference t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionInvestigationComponent convertClinicalImpressionInvestigationComponent(ClinicalImpression.ClinicalImpressionInvestigationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionInvestigationComponent tgt = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    public static Enumeration<ClinicalImpression.ClinicalImpressionStatus> convertClinicalImpressionStatus(org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ClinicalImpression.ClinicalImpressionStatus> tgt = new Enumeration<ClinicalImpression.ClinicalImpressionStatus>(new ClinicalImpression.ClinicalImpressionStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ClinicalImpression.ClinicalImpressionStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus> convertClinicalImpressionStatus(Enumeration<ClinicalImpression.ClinicalImpressionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus>(new ClinicalImpression.ClinicalImpressionStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((ClinicalImpression.ClinicalImpressionStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.DRAFT);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.NULL);
            }
        }
        return tgt;
    }
}

