/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Appointment;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Period;

public class Appointment30_40 {
    public static org.hl7.fhir.r4.model.Appointment convertAppointment(Appointment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Appointment tgt = new org.hl7.fhir.r4.model.Appointment();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment30_40.convertAppointmentStatus(src.getStatusElement()));
        }
        if (src.hasServiceCategory()) {
            tgt.addServiceCategory(VersionConvertor_30_40.convertCodeableConcept(src.getServiceCategory()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(VersionConvertor_30_40.convertCodeableConcept(src.getAppointmentType()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getIndication()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(VersionConvertor_30_40.convertUnsignedInt(src.getPriorityElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_40.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_40.convertInstant(src.getEndElement()));
        }
        if (src.hasMinutesDuration()) {
            tgt.setMinutesDurationElement(VersionConvertor_30_40.convertPositiveInt(src.getMinutesDurationElement()));
        }
        for (Reference reference : src.getSlot()) {
            tgt.addSlot(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(VersionConvertor_30_40.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_40.convertString(src.getCommentElement()));
        }
        for (Reference reference : src.getIncomingReferral()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        for (Appointment.AppointmentParticipantComponent appointmentParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Appointment30_40.convertAppointmentParticipantComponent(appointmentParticipantComponent));
        }
        for (org.hl7.fhir.dstu3.model.Period period : src.getRequestedPeriod()) {
            tgt.addRequestedPeriod(VersionConvertor_30_40.convertPeriod(period));
        }
        return tgt;
    }

    public static Appointment convertAppointment(org.hl7.fhir.r4.model.Appointment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Appointment tgt = new Appointment();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment30_40.convertAppointmentStatus(src.getStatusElement()));
        }
        if (src.hasServiceCategory()) {
            tgt.setServiceCategory(VersionConvertor_30_40.convertCodeableConcept(src.getServiceCategoryFirstRep()));
        }
        for (CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(VersionConvertor_30_40.convertCodeableConcept(src.getAppointmentType()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addIndication(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(VersionConvertor_30_40.convertUnsignedInt(src.getPriorityElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_40.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_40.convertInstant(src.getEndElement()));
        }
        if (src.hasMinutesDuration()) {
            tgt.setMinutesDurationElement(VersionConvertor_30_40.convertPositiveInt(src.getMinutesDurationElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSlot()) {
            tgt.addSlot(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(VersionConvertor_30_40.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_40.convertString(src.getCommentElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addIncomingReferral(VersionConvertor_30_40.convertReference(reference));
        }
        for (Appointment.AppointmentParticipantComponent appointmentParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Appointment30_40.convertAppointmentParticipantComponent(appointmentParticipantComponent));
        }
        for (Period period : src.getRequestedPeriod()) {
            tgt.addRequestedPeriod(VersionConvertor_30_40.convertPeriod(period));
        }
        return tgt;
    }

    public static Appointment.AppointmentParticipantComponent convertAppointmentParticipantComponent(Appointment.AppointmentParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Appointment.AppointmentParticipantComponent tgt = new Appointment.AppointmentParticipantComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(Appointment30_40.convertParticipantRequired(src.getRequiredElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment30_40.convertParticipationStatus(src.getStatusElement()));
        }
        return tgt;
    }

    public static Appointment.AppointmentParticipantComponent convertAppointmentParticipantComponent(Appointment.AppointmentParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Appointment.AppointmentParticipantComponent tgt = new Appointment.AppointmentParticipantComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(Appointment30_40.convertParticipantRequired(src.getRequiredElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment30_40.convertParticipationStatus(src.getStatusElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Appointment.AppointmentStatus> convertAppointmentStatus(Enumeration<Appointment.AppointmentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Appointment.AppointmentStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Appointment.AppointmentStatus>(new Appointment.AppointmentStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Appointment.AppointmentStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PROPOSED);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PENDING);
                break;
            }
            case BOOKED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.BOOKED);
                break;
            }
            case ARRIVED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.ARRIVED);
                break;
            }
            case FULFILLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.FULFILLED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.CANCELLED);
                break;
            }
            case NOSHOW: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NOSHOW);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Appointment.AppointmentStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Appointment.AppointmentStatus> convertAppointmentStatus(org.hl7.fhir.dstu3.model.Enumeration<Appointment.AppointmentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Appointment.AppointmentStatus> tgt = new Enumeration<Appointment.AppointmentStatus>(new Appointment.AppointmentStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Appointment.AppointmentStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PROPOSED);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PENDING);
                break;
            }
            case BOOKED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.BOOKED);
                break;
            }
            case ARRIVED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.ARRIVED);
                break;
            }
            case FULFILLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.FULFILLED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.CANCELLED);
                break;
            }
            case NOSHOW: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NOSHOW);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Appointment.AppointmentStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Appointment.ParticipantRequired> convertParticipantRequired(Enumeration<Appointment.ParticipantRequired> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Appointment.ParticipantRequired> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Appointment.ParticipantRequired>(new Appointment.ParticipantRequiredEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Appointment.ParticipantRequired)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Appointment.ParticipantRequired.REQUIRED);
                break;
            }
            case OPTIONAL: {
                tgt.setValue((Object)Appointment.ParticipantRequired.OPTIONAL);
                break;
            }
            case INFORMATIONONLY: {
                tgt.setValue((Object)Appointment.ParticipantRequired.INFORMATIONONLY);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.ParticipantRequired.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Appointment.ParticipantRequired> convertParticipantRequired(org.hl7.fhir.dstu3.model.Enumeration<Appointment.ParticipantRequired> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Appointment.ParticipantRequired> tgt = new Enumeration<Appointment.ParticipantRequired>(new Appointment.ParticipantRequiredEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Appointment.ParticipantRequired)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Appointment.ParticipantRequired.REQUIRED);
                break;
            }
            case OPTIONAL: {
                tgt.setValue((Object)Appointment.ParticipantRequired.OPTIONAL);
                break;
            }
            case INFORMATIONONLY: {
                tgt.setValue((Object)Appointment.ParticipantRequired.INFORMATIONONLY);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.ParticipantRequired.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Appointment.ParticipationStatus> convertParticipationStatus(org.hl7.fhir.dstu3.model.Enumeration<Appointment.ParticipationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Appointment.ParticipationStatus> tgt = new Enumeration<Appointment.ParticipationStatus>(new Appointment.ParticipationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Appointment.ParticipationStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)Appointment.ParticipationStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)Appointment.ParticipationStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)Appointment.ParticipationStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)Appointment.ParticipationStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.ParticipationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Appointment.ParticipationStatus> convertParticipationStatus(Enumeration<Appointment.ParticipationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Appointment.ParticipationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Appointment.ParticipationStatus>(new Appointment.ParticipationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Appointment.ParticipationStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)Appointment.ParticipationStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)Appointment.ParticipationStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)Appointment.ParticipationStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)Appointment.ParticipationStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.ParticipationStatus.NULL);
            }
        }
        return tgt;
    }
}

