/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_50;

import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.SearchParameter;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.UsageContext;

public class SearchParameter14_50 {
    public static org.hl7.fhir.dstu2016may.model.SearchParameter convertSearchParameter(SearchParameter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.SearchParameter tgt = new org.hl7.fhir.dstu2016may.model.SearchParameter();
        VersionConvertor_14_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(SearchParameter14_50.convertSearchParameterContactComponent(contactDetail));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_50.convertCode(src.getCodeElement()));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getBase()) {
            tgt.setBase(codeType.asStringValue());
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasExpression()) {
            tgt.setExpression(VersionConvertor_14_50.convertTo2016MayExpression(src.getExpression()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_14_50.convertString(src.getXpathElement()));
        }
        if (src.hasXpathUsage()) {
            tgt.setXpathUsageElement(SearchParameter14_50.convertXPathUsageType(src.getXpathUsageElement()));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getTarget()) {
            tgt.addTarget((String)codeType.getValue());
        }
        return tgt;
    }

    public static SearchParameter convertSearchParameter(org.hl7.fhir.dstu2016may.model.SearchParameter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SearchParameter tgt = new SearchParameter();
        VersionConvertor_14_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)VersionConvertor_14_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (SearchParameter.SearchParameterContactComponent searchParameterContactComponent : src.getContact()) {
            tgt.addContact(SearchParameter14_50.convertSearchParameterContactComponent(searchParameterContactComponent));
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_14_50.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_14_50.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_50.convertCode(src.getCodeElement()));
        }
        tgt.addBase(src.getBase());
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasExpression()) {
            tgt.setExpression(VersionConvertor_14_50.convertToR4Expression(src.getExpression()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_14_50.convertString(src.getXpathElement()));
        }
        if (src.hasXpathUsage()) {
            tgt.setXpathUsageElement(SearchParameter14_50.convertXPathUsageType(src.getXpathUsageElement()));
        }
        for (CodeType codeType : src.getTarget()) {
            tgt.addTarget((String)codeType.getValue());
        }
        return tgt;
    }

    public static ContactDetail convertSearchParameterContactComponent(SearchParameter.SearchParameterContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static SearchParameter.SearchParameterContactComponent convertSearchParameterContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SearchParameter.SearchParameterContactComponent tgt = new SearchParameter.SearchParameterContactComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static Enumeration<SearchParameter.XPathUsageType> convertXPathUsageType(org.hl7.fhir.r5.model.Enumeration<SearchParameter.XPathUsageType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SearchParameter.XPathUsageType> tgt = new Enumeration<SearchParameter.XPathUsageType>(new SearchParameter.XPathUsageTypeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((SearchParameter.XPathUsageType)((Object)src.getValue())) {
            case NORMAL: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NORMAL);
                break;
            }
            case PHONETIC: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.PHONETIC);
                break;
            }
            case NEARBY: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NEARBY);
                break;
            }
            case DISTANCE: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.DISTANCE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<SearchParameter.XPathUsageType> convertXPathUsageType(Enumeration<SearchParameter.XPathUsageType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<SearchParameter.XPathUsageType> tgt = new org.hl7.fhir.r5.model.Enumeration<SearchParameter.XPathUsageType>(new SearchParameter.XPathUsageTypeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((SearchParameter.XPathUsageType)((Object)src.getValue())) {
            case NORMAL: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NORMAL);
                break;
            }
            case PHONETIC: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.PHONETIC);
                break;
            }
            case NEARBY: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NEARBY);
                break;
            }
            case DISTANCE: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.DISTANCE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NULL);
            }
        }
        return tgt;
    }
}

