/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_50;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.utils.ToolingExtensions;

public class ConceptMap14_50 {
    public static org.hl7.fhir.r5.model.ConceptMap convertConceptMap(ConceptMap src) throws FHIRException {
        DataType tt;
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.ConceptMap tgt = new org.hl7.fhir.r5.model.ConceptMap();
        VersionConvertor_14_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (ConceptMap.ConceptMapContactComponent conceptMapContactComponent : src.getContact()) {
            tgt.addContact(ConceptMap14_50.convertConceptMapContactComponent(conceptMapContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu2016may.model.CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_14_50.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_14_50.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        tgt.setSource((tt = VersionConvertor_14_50.convertType(src.getSource())) instanceof Reference ? new CanonicalType(((Reference)tt).getReference()) : tt);
        tt = VersionConvertor_14_50.convertType(src.getTarget());
        tgt.setTarget(tt instanceof Reference ? new CanonicalType(((Reference)tt).getReference()) : tt);
        for (ConceptMap.SourceElementComponent t : src.getElement()) {
            List<VersionConvertor_14_50.SourceElementComponentWrapper> ws = ConceptMap14_50.convertSourceElementComponent(t);
            for (VersionConvertor_14_50.SourceElementComponentWrapper w : ws) {
                ConceptMap14_50.getGroup(tgt, w.source, w.target).addElement(w.comp);
            }
        }
        return tgt;
    }

    public static ConceptMap convertConceptMap(org.hl7.fhir.r5.model.ConceptMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap tgt = new ConceptMap();
        VersionConvertor_14_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier() && src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_14_50.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ConceptMap14_50.convertConceptMapContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.getSource() instanceof CanonicalType) {
            tgt.setSource(VersionConvertor_14_50.convertCanonicalToReference((CanonicalType)src.getSource()));
        } else if (src.hasSource()) {
            tgt.setSource(VersionConvertor_14_50.convertType(src.getSource()));
        }
        if (src.getTarget() instanceof CanonicalType) {
            tgt.setTarget(VersionConvertor_14_50.convertCanonicalToReference((CanonicalType)src.getTarget()));
        } else if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_14_50.convertType(src.getTarget()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_14_50.convertType(src.getSource()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_14_50.convertType(src.getTarget()));
        }
        for (ConceptMap.ConceptMapGroupComponent conceptMapGroupComponent : src.getGroup()) {
            for (ConceptMap.SourceElementComponent t : conceptMapGroupComponent.getElement()) {
                tgt.addElement(ConceptMap14_50.convertSourceElementComponent(t, conceptMapGroupComponent));
            }
        }
        return tgt;
    }

    public static ContactDetail convertConceptMapContactComponent(ConceptMap.ConceptMapContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapContactComponent convertConceptMapContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.ConceptMapContactComponent tgt = new ConceptMap.ConceptMapContactComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConceptMapEquivalence> convertConceptMapEquivalence(Enumeration<Enumerations.ConceptMapRelationship> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConceptMapEquivalence> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence");
        if (src.hasExtension("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence")) {
            tgt.setValueAsString(src.getExtensionString("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence"));
        } else {
            switch ((Enumerations.ConceptMapRelationship)((Object)src.getValue())) {
                case EQUIVALENT: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUIVALENT);
                    break;
                }
                case SOURCEISNARROWERTHANTARGET: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.WIDER);
                    break;
                }
                case SOURCEISBROADERTHANTARGET: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NARROWER);
                    break;
                }
                case NOTRELATEDTO: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.DISJOINT);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ConceptMapRelationship> convertConceptMapRelationship(org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConceptMapEquivalence> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ConceptMapRelationship> tgt = new Enumeration<Enumerations.ConceptMapRelationship>(new Enumerations.ConceptMapRelationshipEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        ToolingExtensions.setCodeExtension(tgt, "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence", src.getValueAsString());
        switch ((Enumerations.ConceptMapEquivalence)((Object)src.getValue())) {
            case EQUIVALENT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.EQUIVALENT);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.EQUIVALENT);
                break;
            }
            case WIDER: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET);
                break;
            }
            case SUBSUMES: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET);
                break;
            }
            case NARROWER: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET);
                break;
            }
            case SPECIALIZES: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET);
                break;
            }
            case INEXACT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.RELATEDTO);
                break;
            }
            case UNMATCHED: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NULL);
                break;
            }
            case DISJOINT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NOTRELATEDTO);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NULL);
            }
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasPropertyElement()) {
            tgt.setElementElement(VersionConvertor_14_50.convertUri(src.getPropertyElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasValueElement()) {
            tgt.setCodeElement(VersionConvertor_14_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasElementElement()) {
            tgt.setPropertyElement(VersionConvertor_14_50.convertUri(src.getElementElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCodeElement()) {
            tgt.setValueElement(VersionConvertor_14_50.convertString(src.getCodeElement()));
        }
        return tgt;
    }

    public static List<VersionConvertor_14_50.SourceElementComponentWrapper> convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        ArrayList<VersionConvertor_14_50.SourceElementComponentWrapper> res = new ArrayList<VersionConvertor_14_50.SourceElementComponentWrapper>();
        if (src == null || src.isEmpty()) {
            return res;
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
            VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
            if (src.hasCode()) {
                tgt.setCode(src.getCode());
            }
            if (t.getEquivalence() == Enumerations.ConceptMapEquivalence.UNMATCHED) {
                tgt.setNoMap(true);
            } else {
                tgt.addTarget(ConceptMap14_50.convertTargetElementComponent(t));
            }
            res.add(new VersionConvertor_14_50.SourceElementComponentWrapper(tgt, src.getSystem(), t.getSystem()));
        }
        return res;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src, ConceptMap.ConceptMapGroupComponent g2) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (g2.hasSource()) {
            tgt.setSystem(g2.getSource());
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_50.convertCode(src.getCodeElement()));
        }
        if (src.hasNoMap() && src.getNoMap()) {
            tgt.addTarget(new ConceptMap.TargetElementComponent().setEquivalence(Enumerations.ConceptMapEquivalence.UNMATCHED));
        } else {
            for (ConceptMap.TargetElementComponent t : src.getTarget()) {
                tgt.addTarget(ConceptMap14_50.convertTargetElementComponent(t, g2));
            }
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src, ConceptMap.ConceptMapGroupComponent g2) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (g2.hasTarget()) {
            tgt.setSystem(g2.getTarget());
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_50.convertCode(src.getCodeElement()));
        }
        if (src.hasRelationship()) {
            tgt.setEquivalenceElement(ConceptMap14_50.convertConceptMapEquivalence(src.getRelationshipElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentsElement(VersionConvertor_14_50.convertString(src.getCommentElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap14_50.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap14_50.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_50.convertCode(src.getCodeElement()));
        }
        if (src.hasEquivalence()) {
            tgt.setRelationshipElement(ConceptMap14_50.convertConceptMapRelationship(src.getEquivalenceElement()));
        }
        if (src.hasComments()) {
            tgt.setCommentElement(VersionConvertor_14_50.convertString(src.getCommentsElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap14_50.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap14_50.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupComponent getGroup(org.hl7.fhir.r5.model.ConceptMap map, String srcs, String tgts) {
        for (ConceptMap.ConceptMapGroupComponent grp : map.getGroup()) {
            if (!grp.getSource().equals(srcs) || !grp.getTarget().equals(tgts)) continue;
            return grp;
        }
        ConceptMap.ConceptMapGroupComponent grp = map.addGroup();
        grp.setSource(srcs);
        grp.setTarget(tgts);
        return grp;
    }
}

