/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_40;

import org.hl7.fhir.convertors.VersionConvertorConstants;
import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.OperationDefinition;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;

public class OperationDefinition14_40 {
    public static org.hl7.fhir.r4.model.OperationDefinition convertOperationDefinition(OperationDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.OperationDefinition tgt = new org.hl7.fhir.r4.model.OperationDefinition();
        VersionConvertor_14_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(OperationDefinition14_40.convertOperationKind(src.getKindElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_40.convertString(src.getPublisherElement()));
        }
        for (OperationDefinition.OperationDefinitionContactComponent operationDefinitionContactComponent : src.getContact()) {
            tgt.addContact(OperationDefinition14_40.convertOperationDefinitionContactComponent(operationDefinitionContactComponent));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasIdempotent()) {
            tgt.setAffectsState(!src.getIdempotent());
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasBase()) {
            tgt.setBaseElement(VersionConvertor_14_40.convertReferenceToCanonical(src.getBase()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertBoolean(src.getSystemElement()));
        }
        for (CodeType codeType : src.getType()) {
            tgt.addResource((String)codeType.getValue());
        }
        tgt.setType(tgt.hasResource());
        if (src.hasInstanceElement()) {
            tgt.setInstanceElement(VersionConvertor_14_40.convertBoolean(src.getInstanceElement()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getParameter()) {
            tgt.addParameter(OperationDefinition14_40.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        return tgt;
    }

    public static OperationDefinition convertOperationDefinition(org.hl7.fhir.r4.model.OperationDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition tgt = new OperationDefinition();
        VersionConvertor_14_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_40.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(OperationDefinition14_40.convertOperationKind(src.getKindElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(OperationDefinition14_40.convertOperationDefinitionContactComponent(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasAffectsState()) {
            tgt.setIdempotent(!src.getAffectsState());
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_40.convertCode(src.getCodeElement()));
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasBaseElement()) {
            tgt.setBase(VersionConvertor_14_40.convertCanonicalToReference(src.getBaseElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_14_40.convertBoolean(src.getSystemElement()));
        }
        if (src.getType()) {
            for (org.hl7.fhir.r4.model.CodeType codeType : src.getResource()) {
                tgt.addType((String)codeType.getValue());
            }
        }
        if (src.hasInstanceElement()) {
            tgt.setInstanceElement(VersionConvertor_14_40.convertBoolean(src.getInstanceElement()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getParameter()) {
            tgt.addParameter(OperationDefinition14_40.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionContactComponent convertOperationDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionContactComponent tgt = new OperationDefinition.OperationDefinitionContactComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertOperationDefinitionContactComponent(OperationDefinition.OperationDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_40.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        Type t;
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_14_40.convertBindingStrength(src.getStrengthElement()));
        }
        if ((t = VersionConvertor_14_40.convertType(src.getValueSet())) != null) {
            if (t instanceof Reference) {
                tgt.setValueSet(((Reference)t).getReference());
            } else {
                tgt.setValueSet(t.primitiveValue());
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_14_40.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet(new org.hl7.fhir.dstu2016may.model.UriType(vsr));
            } else {
                tgt.setValueSet(new org.hl7.fhir.dstu2016may.model.Reference(src.getValueSet()));
            }
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_40.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(OperationDefinition14_40.convertOperationParameterUse(src.getUseElement()));
        }
        if (src.hasMinElement()) {
            tgt.setMinElement(VersionConvertor_14_40.convertInteger(src.getMinElement()));
        }
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_14_40.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_40.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_40.convertCode(src.getTypeElement()));
        }
        if (src.hasSearchType()) {
            tgt.setSearchTypeElement(VersionConvertor_14_40.convertSearchParamType(src.getSearchTypeElement()));
        }
        tgt.addTargetProfile(src.getProfile().getReference());
        if (src.hasBinding()) {
            tgt.setBinding(OperationDefinition14_40.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent t : src.getPart()) {
            tgt.addPart(OperationDefinition14_40.convertOperationDefinitionParameterComponent(t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_40.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(OperationDefinition14_40.convertOperationParameterUse(src.getUseElement()));
        }
        if (src.hasMinElement()) {
            tgt.setMinElement(VersionConvertor_14_40.convertInteger(src.getMinElement()));
        }
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_14_40.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_40.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_40.convertCode(src.getTypeElement()));
        }
        if (src.hasSearchType()) {
            tgt.setSearchTypeElement(VersionConvertor_14_40.convertSearchParamType(src.getSearchTypeElement()));
        }
        for (UriType uriType : src.getTargetProfile()) {
            tgt.setProfile(new org.hl7.fhir.dstu2016may.model.Reference((String)uriType.getValue()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(OperationDefinition14_40.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getPart()) {
            tgt.addPart(OperationDefinition14_40.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationKind> convertOperationKind(Enumeration<OperationDefinition.OperationKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationKind> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationKind>(new OperationDefinition.OperationKindEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationKind)((Object)src.getValue())) {
            case OPERATION: {
                tgt.setValue((Object)OperationDefinition.OperationKind.OPERATION);
                break;
            }
            case QUERY: {
                tgt.setValue((Object)OperationDefinition.OperationKind.QUERY);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationDefinition.OperationKind> convertOperationKind(org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<OperationDefinition.OperationKind> tgt = new Enumeration<OperationDefinition.OperationKind>(new OperationDefinition.OperationKindEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationKind)((Object)src.getValue())) {
            case OPERATION: {
                tgt.setValue((Object)OperationDefinition.OperationKind.OPERATION);
                break;
            }
            case QUERY: {
                tgt.setValue((Object)OperationDefinition.OperationKind.QUERY);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationParameterUse> convertOperationParameterUse(Enumeration<OperationDefinition.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationParameterUse> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationParameterUse>(new OperationDefinition.OperationParameterUseEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationDefinition.OperationParameterUse> convertOperationParameterUse(org.hl7.fhir.dstu2016may.model.Enumeration<OperationDefinition.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<OperationDefinition.OperationParameterUse> tgt = new Enumeration<OperationDefinition.OperationParameterUse>(new OperationDefinition.OperationParameterUseEnumFactory());
        VersionConvertor_14_40.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.NULL);
            }
        }
        return tgt;
    }
}

