/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_30;

import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class StructureDefinition14_30 {
    public static Enumeration<StructureDefinition.ExtensionContext> convertExtensionContext(org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.ExtensionContext> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.ExtensionContext> tgt = new Enumeration<StructureDefinition.ExtensionContext>(new StructureDefinition.ExtensionContextEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.ExtensionContext)((Object)src.getValue())) {
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.RESOURCE);
                break;
            }
            case DATATYPE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.DATATYPE);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.ExtensionContext> convertExtensionContext(Enumeration<StructureDefinition.ExtensionContext> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.ExtensionContext> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.ExtensionContext>(new StructureDefinition.ExtensionContextEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.ExtensionContext)((Object)src.getValue())) {
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.RESOURCE);
                break;
            }
            case DATATYPE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.DATATYPE);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.NULL);
            }
        }
        return tgt;
    }

    public static StructureDefinition convertStructureDefinition(org.hl7.fhir.dstu3.model.StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        VersionConvertor_14_30.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_30.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setDisplayElement(VersionConvertor_14_30.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(StructureDefinition14_30.convertStructureDefinitionContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Coding coding : src.getKeyword()) {
            tgt.addCode(VersionConvertor_14_30.convertCoding(coding));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersionElement(VersionConvertor_14_30.convertId(src.getFhirVersionElement()));
        }
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(StructureDefinition14_30.convertStructureDefinitionMappingComponent(structureDefinitionMappingComponent));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition14_30.convertStructureDefinitionKind(src.getKindElement()));
        }
        if (src.hasAbstractElement()) {
            tgt.setAbstractElement(VersionConvertor_14_30.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasContextType()) {
            tgt.setContextTypeElement(StructureDefinition14_30.convertExtensionContext(src.getContextTypeElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getContext()) {
            tgt.addContext((String)stringType.getValue());
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinitionElement(VersionConvertor_14_30.convertUri(src.getBaseDefinitionElement()));
        }
        if (src.hasType() && src.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            tgt.setBaseTypeElement(VersionConvertor_14_30.convertCode(src.getTypeElement()));
        }
        if (src.hasDerivation()) {
            tgt.setDerivationElement(StructureDefinition14_30.convertTypeDerivationRule(src.getDerivationElement()));
        }
        if (src.hasSnapshot()) {
            tgt.setSnapshot(StructureDefinition14_30.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(StructureDefinition14_30.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.StructureDefinition convertStructureDefinition(StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.StructureDefinition tgt = new org.hl7.fhir.dstu3.model.StructureDefinition();
        VersionConvertor_14_30.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_30.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDisplay()) {
            tgt.setTitleElement(VersionConvertor_14_30.convertString(src.getDisplayElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (StructureDefinition.StructureDefinitionContactComponent structureDefinitionContactComponent : src.getContact()) {
            tgt.addContact(StructureDefinition14_30.convertStructureDefinitionContactComponent(structureDefinitionContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_14_30.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (org.hl7.fhir.dstu2016may.model.Coding coding : src.getCode()) {
            tgt.addKeyword(VersionConvertor_14_30.convertCoding(coding));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersionElement(VersionConvertor_14_30.convertId(src.getFhirVersionElement()));
        }
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(StructureDefinition14_30.convertStructureDefinitionMappingComponent(structureDefinitionMappingComponent));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition14_30.convertStructureDefinitionKind(src.getKindElement()));
        }
        if (src.hasAbstractElement()) {
            tgt.setAbstractElement(VersionConvertor_14_30.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasContextType()) {
            tgt.setContextTypeElement(StructureDefinition14_30.convertExtensionContext(src.getContextTypeElement()));
        }
        for (StringType stringType : src.getContext()) {
            tgt.addContext((String)stringType.getValue());
        }
        if (src.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            tgt.setTypeElement(VersionConvertor_14_30.convertCode(src.getBaseTypeElement()));
        } else {
            tgt.setType(src.getId());
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinitionElement(VersionConvertor_14_30.convertUri(src.getBaseDefinitionElement()));
        }
        if (src.hasDerivation()) {
            tgt.setDerivationElement(StructureDefinition14_30.convertTypeDerivationRule(src.getDerivationElement()));
        }
        if (src.hasSnapshot()) {
            if (src.hasSnapshot()) {
                tgt.setSnapshot(StructureDefinition14_30.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
            }
            tgt.getSnapshot().getElementFirstRep().getType().clear();
        }
        if (src.hasDifferential()) {
            if (src.hasDifferential()) {
                tgt.setDifferential(StructureDefinition14_30.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
            }
            tgt.getDifferential().getElementFirstRep().getType().clear();
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionContactComponent convertStructureDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionContactComponent tgt = new StructureDefinition.StructureDefinitionContactComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertStructureDefinitionContactComponent(StructureDefinition.StructureDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_30.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2016may.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_30.convertElementDefinition(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(Enumeration<StructureDefinition.StructureDefinitionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.StructureDefinitionKind> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.StructureDefinitionKind>(new StructureDefinition.StructureDefinitionKindEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.StructureDefinitionKind)((Object)src.getValue())) {
            case PRIMITIVETYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.DATATYPE);
                break;
            }
            case COMPLEXTYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.DATATYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.StructureDefinitionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.StructureDefinitionKind> tgt = new Enumeration<StructureDefinition.StructureDefinitionKind>(new StructureDefinition.StructureDefinitionKindEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.StructureDefinitionKind)((Object)src.getValue())) {
            case DATATYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_14_30.convertId(src.getIdentityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_14_30.convertUri(src.getUriElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasComments()) {
            tgt.setCommentElement(VersionConvertor_14_30.convertString(src.getCommentsElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_14_30.convertId(src.getIdentityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_14_30.convertUri(src.getUriElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentsElement(VersionConvertor_14_30.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2016may.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_30.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_30.convertElementDefinition(t));
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.TypeDerivationRule> convertTypeDerivationRule(org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.TypeDerivationRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.TypeDerivationRule> tgt = new Enumeration<StructureDefinition.TypeDerivationRule>(new StructureDefinition.TypeDerivationRuleEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.TypeDerivationRule)((Object)src.getValue())) {
            case SPECIALIZATION: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.SPECIALIZATION);
                break;
            }
            case CONSTRAINT: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.CONSTRAINT);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.TypeDerivationRule> convertTypeDerivationRule(Enumeration<StructureDefinition.TypeDerivationRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.TypeDerivationRule> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<StructureDefinition.TypeDerivationRule>(new StructureDefinition.TypeDerivationRuleEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.TypeDerivationRule)((Object)src.getValue())) {
            case SPECIALIZATION: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.SPECIALIZATION);
                break;
            }
            case CONSTRAINT: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.CONSTRAINT);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.NULL);
            }
        }
        return tgt;
    }
}

