/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_30;

import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.Questionnaire;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class Questionnaire14_30 {
    public static Questionnaire convertQuestionnaire(org.hl7.fhir.dstu3.model.Questionnaire src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire tgt = new Questionnaire();
        VersionConvertor_14_30.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_30.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Questionnaire14_30.convertQuestionnaireStatus(src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            for (org.hl7.fhir.dstu3.model.ContactPoint t1 : contactDetail.getTelecom()) {
                tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t1));
            }
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_14_30.convertString(src.getTitleElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addConcept(VersionConvertor_14_30.convertCoding(coding));
        }
        for (org.hl7.fhir.dstu3.model.CodeType codeType : src.getSubjectType()) {
            tgt.addSubjectType((String)codeType.getValue());
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire14_30.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Questionnaire convertQuestionnaire(Questionnaire src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Questionnaire tgt = new org.hl7.fhir.dstu3.model.Questionnaire();
        VersionConvertor_14_30.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_30.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Questionnaire14_30.convertQuestionnaireStatus(src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addContact(Questionnaire14_30.convertQuestionnaireContactComponent(contactPoint));
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_14_30.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_14_30.convertString(src.getTitleElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.Coding coding : src.getConcept()) {
            tgt.addCode(VersionConvertor_14_30.convertCoding(coding));
        }
        for (CodeType codeType : src.getSubjectType()) {
            tgt.addSubjectType((String)codeType.getValue());
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire14_30.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static ContactDetail convertQuestionnaireContactComponent(ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(src));
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(VersionConvertor_14_30.convertString(src.getLinkIdElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.Coding coding : src.getConcept()) {
            tgt.addCode(VersionConvertor_14_30.convertCoding(coding));
        }
        if (src.hasPrefix()) {
            tgt.setPrefixElement(VersionConvertor_14_30.convertString(src.getPrefixElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_30.convertString(src.getTextElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Questionnaire14_30.convertQuestionnaireItemType(src.getTypeElement()));
        }
        for (Questionnaire.QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : src.getEnableWhen()) {
            tgt.addEnableWhen(Questionnaire14_30.convertQuestionnaireItemEnableWhenComponent(questionnaireItemEnableWhenComponent));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(VersionConvertor_14_30.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeats()) {
            tgt.setRepeatsElement(VersionConvertor_14_30.convertBoolean(src.getRepeatsElement()));
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnlyElement(VersionConvertor_14_30.convertBoolean(src.getReadOnlyElement()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_14_30.convertInteger(src.getMaxLengthElement()));
        }
        if (src.hasOptions()) {
            tgt.setOptions(VersionConvertor_14_30.convertReference(src.getOptions()));
        }
        for (Questionnaire.QuestionnaireItemOptionComponent questionnaireItemOptionComponent : src.getOption()) {
            tgt.addOption(Questionnaire14_30.convertQuestionnaireItemOptionComponent(questionnaireItemOptionComponent));
        }
        if (src.hasInitial()) {
            tgt.setInitial(VersionConvertor_14_30.convertType(src.getInitial()));
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire14_30.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(VersionConvertor_14_30.convertString(src.getLinkIdElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addConcept(VersionConvertor_14_30.convertCoding(coding));
        }
        if (src.hasPrefix()) {
            tgt.setPrefixElement(VersionConvertor_14_30.convertString(src.getPrefixElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_14_30.convertString(src.getTextElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Questionnaire14_30.convertQuestionnaireItemType(src.getTypeElement()));
        }
        for (Questionnaire.QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : src.getEnableWhen()) {
            tgt.addEnableWhen(Questionnaire14_30.convertQuestionnaireItemEnableWhenComponent(questionnaireItemEnableWhenComponent));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(VersionConvertor_14_30.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeats()) {
            tgt.setRepeatsElement(VersionConvertor_14_30.convertBoolean(src.getRepeatsElement()));
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnlyElement(VersionConvertor_14_30.convertBoolean(src.getReadOnlyElement()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_14_30.convertInteger(src.getMaxLengthElement()));
        }
        if (src.hasOptions()) {
            tgt.setOptions(VersionConvertor_14_30.convertReference(src.getOptions()));
        }
        for (Questionnaire.QuestionnaireItemOptionComponent questionnaireItemOptionComponent : src.getOption()) {
            tgt.addOption(Questionnaire14_30.convertQuestionnaireItemOptionComponent(questionnaireItemOptionComponent));
        }
        if (src.hasInitial()) {
            tgt.setInitial(VersionConvertor_14_30.convertType(src.getInitial()));
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire14_30.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasQuestionElement()) {
            tgt.setQuestionElement(VersionConvertor_14_30.convertString(src.getQuestionElement()));
        }
        if (src.hasHasAnswer()) {
            tgt.setAnsweredElement(VersionConvertor_14_30.convertBoolean(src.getHasAnswerElement()));
        }
        if (src.hasAnswer()) {
            tgt.setAnswer(VersionConvertor_14_30.convertType(src.getAnswer()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasQuestionElement()) {
            tgt.setQuestionElement(VersionConvertor_14_30.convertString(src.getQuestionElement()));
        }
        if (src.hasAnswered()) {
            tgt.setHasAnswerElement(VersionConvertor_14_30.convertBoolean(src.getAnsweredElement()));
        }
        if (src.hasAnswer()) {
            tgt.setAnswer(VersionConvertor_14_30.convertType(src.getAnswer()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemOptionComponent convertQuestionnaireItemOptionComponent(Questionnaire.QuestionnaireItemOptionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemOptionComponent tgt = new Questionnaire.QuestionnaireItemOptionComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_30.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemOptionComponent convertQuestionnaireItemOptionComponent(Questionnaire.QuestionnaireItemOptionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemOptionComponent tgt = new Questionnaire.QuestionnaireItemOptionComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_30.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Enumeration<Questionnaire.QuestionnaireItemType> convertQuestionnaireItemType(org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireItemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Questionnaire.QuestionnaireItemType> tgt = new Enumeration<Questionnaire.QuestionnaireItemType>(new Questionnaire.QuestionnaireItemTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireItemType)((Object)src.getValue())) {
            case GROUP: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.GROUP);
                break;
            }
            case DISPLAY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DISPLAY);
                break;
            }
            case QUESTION: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUESTION);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.BOOLEAN);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DECIMAL);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.INTEGER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATE);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case INSTANT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case TIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TIME);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.STRING);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TEXT);
                break;
            }
            case URL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.URL);
                break;
            }
            case CHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.CHOICE);
                break;
            }
            case OPENCHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.OPENCHOICE);
                break;
            }
            case ATTACHMENT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.ATTACHMENT);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.REFERENCE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUANTITY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireItemType> convertQuestionnaireItemType(Enumeration<Questionnaire.QuestionnaireItemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireItemType> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireItemType>(new Questionnaire.QuestionnaireItemTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireItemType)((Object)src.getValue())) {
            case GROUP: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.GROUP);
                break;
            }
            case DISPLAY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DISPLAY);
                break;
            }
            case QUESTION: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUESTION);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.BOOLEAN);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DECIMAL);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.INTEGER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATE);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case TIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TIME);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.STRING);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TEXT);
                break;
            }
            case URL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.URL);
                break;
            }
            case CHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.CHOICE);
                break;
            }
            case OPENCHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.OPENCHOICE);
                break;
            }
            case ATTACHMENT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.ATTACHMENT);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.REFERENCE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUANTITY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireStatus> convertQuestionnaireStatus(Enumeration<Enumerations.PublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireStatus> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireStatus>(new Questionnaire.QuestionnaireStatusEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.PublicationStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.PUBLISHED);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.PublicationStatus> convertQuestionnaireStatus(org.hl7.fhir.dstu2016may.model.Enumeration<Questionnaire.QuestionnaireStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.PublicationStatus> tgt = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.PublicationStatus.DRAFT);
                break;
            }
            case PUBLISHED: {
                tgt.setValue((Object)Enumerations.PublicationStatus.ACTIVE);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Enumerations.PublicationStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
            }
        }
        return tgt;
    }
}

