/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_30;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class ConceptMap14_30 {
    public static ConceptMap convertConceptMap(org.hl7.fhir.dstu3.model.ConceptMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap tgt = new ConceptMap();
        VersionConvertor_14_30.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_14_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ConceptMap14_30.convertConceptMapContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_14_30.convertType(src.getSource()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_14_30.convertType(src.getTarget()));
        }
        for (ConceptMap.ConceptMapGroupComponent conceptMapGroupComponent : src.getGroup()) {
            for (ConceptMap.SourceElementComponent t : conceptMapGroupComponent.getElement()) {
                tgt.addElement(ConceptMap14_30.convertSourceElementComponent(t, conceptMapGroupComponent));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ConceptMap convertConceptMap(ConceptMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ConceptMap tgt = new org.hl7.fhir.dstu3.model.ConceptMap();
        VersionConvertor_14_30.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_14_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (ConceptMap.ConceptMapContactComponent conceptMapContactComponent : src.getContact()) {
            tgt.addContact(ConceptMap14_30.convertConceptMapContactComponent(conceptMapContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_14_30.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_14_30.convertType(src.getSource()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_14_30.convertType(src.getTarget()));
        }
        for (ConceptMap.SourceElementComponent sourceElementComponent : src.getElement()) {
            List<VersionConvertor_14_30.SourceElementComponentWrapper> ws = ConceptMap14_30.convertSourceElementComponent(sourceElementComponent);
            for (VersionConvertor_14_30.SourceElementComponentWrapper w : ws) {
                ConceptMap14_30.getGroup(tgt, w.source, w.target).addElement(w.comp);
            }
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapContactComponent convertConceptMapContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.ConceptMapContactComponent tgt = new ConceptMap.ConceptMapContactComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertConceptMapContactComponent(ConceptMap.ConceptMapContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConceptMapEquivalence> convertConceptMapEquivalence(Enumeration<Enumerations.ConceptMapEquivalence> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConceptMapEquivalence> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ConceptMapEquivalence)((Object)src.getValue())) {
            case EQUIVALENT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUIVALENT);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUAL);
                break;
            }
            case WIDER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.WIDER);
                break;
            }
            case SUBSUMES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SUBSUMES);
                break;
            }
            case NARROWER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NARROWER);
                break;
            }
            case SPECIALIZES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SPECIALIZES);
                break;
            }
            case INEXACT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.INEXACT);
                break;
            }
            case UNMATCHED: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.UNMATCHED);
                break;
            }
            case DISJOINT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.DISJOINT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ConceptMapEquivalence> convertConceptMapEquivalence(org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConceptMapEquivalence> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ConceptMapEquivalence> tgt = new Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ConceptMapEquivalence)((Object)src.getValue())) {
            case EQUIVALENT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUIVALENT);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUAL);
                break;
            }
            case WIDER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.WIDER);
                break;
            }
            case SUBSUMES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SUBSUMES);
                break;
            }
            case NARROWER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NARROWER);
                break;
            }
            case SPECIALIZES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SPECIALIZES);
                break;
            }
            case INEXACT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.INEXACT);
                break;
            }
            case UNMATCHED: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.UNMATCHED);
                break;
            }
            case DISJOINT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.DISJOINT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NULL);
            }
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasPropertyElement()) {
            tgt.setElementElement(VersionConvertor_14_30.convertUri(src.getPropertyElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertString(src.getCodeElement()));
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasElementElement()) {
            tgt.setPropertyElement(VersionConvertor_14_30.convertUri(src.getElementElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_14_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertString(src.getCodeElement()));
        }
        return tgt;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src, ConceptMap.ConceptMapGroupComponent g2) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (g2.hasSource()) {
            tgt.setSystem(g2.getSource());
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            tgt.addTarget(ConceptMap14_30.convertTargetElementComponent(t, g2));
        }
        return tgt;
    }

    public static List<VersionConvertor_14_30.SourceElementComponentWrapper> convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        ArrayList<VersionConvertor_14_30.SourceElementComponentWrapper> res = new ArrayList<VersionConvertor_14_30.SourceElementComponentWrapper>();
        if (src == null || src.isEmpty()) {
            return res;
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
            VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
            if (src.hasCode()) {
                tgt.setCode(src.getCode());
            }
            tgt.addTarget(ConceptMap14_30.convertTargetElementComponent(t));
            res.add(new VersionConvertor_14_30.SourceElementComponentWrapper(tgt, src.getSystem(), t.getSystem()));
        }
        return res;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src, ConceptMap.ConceptMapGroupComponent g2) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (g2.hasTarget()) {
            tgt.setSystem(g2.getTarget());
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasEquivalence()) {
            tgt.setEquivalenceElement(ConceptMap14_30.convertConceptMapEquivalence(src.getEquivalenceElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentsElement(VersionConvertor_14_30.convertString(src.getCommentElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap14_30.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap14_30.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasEquivalence()) {
            tgt.setEquivalenceElement(ConceptMap14_30.convertConceptMapEquivalence(src.getEquivalenceElement()));
        }
        if (src.hasComments()) {
            tgt.setCommentElement(VersionConvertor_14_30.convertString(src.getCommentsElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap14_30.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap14_30.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupComponent getGroup(org.hl7.fhir.dstu3.model.ConceptMap map, String srcs, String tgts) {
        for (ConceptMap.ConceptMapGroupComponent grp : map.getGroup()) {
            if (!grp.getSource().equals(srcs) || !grp.getTarget().equals(tgts)) continue;
            return grp;
        }
        ConceptMap.ConceptMapGroupComponent grp = map.addGroup();
        grp.setSource(srcs);
        grp.setTarget(tgts);
        return grp;
    }
}

