/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_30;

import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class CodeSystem14_30 {
    public static org.hl7.fhir.dstu3.model.CodeSystem convertCodeSystem(CodeSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.CodeSystem tgt = new org.hl7.fhir.dstu3.model.CodeSystem();
        VersionConvertor_14_30.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_14_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (CodeSystem.CodeSystemContactComponent codeSystemContactComponent : src.getContact()) {
            tgt.addContact(CodeSystem14_30.convertCodeSystemContactComponent(codeSystemContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_14_30.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasCaseSensitive()) {
            tgt.setCaseSensitiveElement(VersionConvertor_14_30.convertBoolean(src.getCaseSensitiveElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSetElement(VersionConvertor_14_30.convertUri(src.getValueSetElement()));
        }
        if (src.hasCompositional()) {
            tgt.setCompositionalElement(VersionConvertor_14_30.convertBoolean(src.getCompositionalElement()));
        }
        if (src.hasVersionNeeded()) {
            tgt.setVersionNeededElement(VersionConvertor_14_30.convertBoolean(src.getVersionNeededElement()));
        }
        if (src.hasContent()) {
            tgt.setContentElement(CodeSystem14_30.convertCodeSystemContentMode(src.getContentElement()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(VersionConvertor_14_30.convertUnsignedInt(src.getCountElement()));
        }
        for (CodeSystem.CodeSystemFilterComponent codeSystemFilterComponent : src.getFilter()) {
            tgt.addFilter(CodeSystem14_30.convertCodeSystemFilterComponent(codeSystemFilterComponent));
        }
        for (CodeSystem.CodeSystemPropertyComponent codeSystemPropertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem14_30.convertPropertyComponent(codeSystemPropertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem14_30.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static CodeSystem convertCodeSystem(org.hl7.fhir.dstu3.model.CodeSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem tgt = new CodeSystem();
        VersionConvertor_14_30.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_14_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(CodeSystem14_30.convertCodeSystemContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasCaseSensitive()) {
            tgt.setCaseSensitiveElement(VersionConvertor_14_30.convertBoolean(src.getCaseSensitiveElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSetElement(VersionConvertor_14_30.convertUri(src.getValueSetElement()));
        }
        if (src.hasCompositional()) {
            tgt.setCompositionalElement(VersionConvertor_14_30.convertBoolean(src.getCompositionalElement()));
        }
        if (src.hasVersionNeeded()) {
            tgt.setVersionNeededElement(VersionConvertor_14_30.convertBoolean(src.getVersionNeededElement()));
        }
        if (src.hasContent()) {
            tgt.setContentElement(CodeSystem14_30.convertCodeSystemContentMode(src.getContentElement()));
        }
        if (src.hasCount()) {
            tgt.setCountElement(VersionConvertor_14_30.convertUnsignedInt(src.getCountElement()));
        }
        for (CodeSystem.CodeSystemFilterComponent codeSystemFilterComponent : src.getFilter()) {
            tgt.addFilter(CodeSystem14_30.convertCodeSystemFilterComponent(codeSystemFilterComponent));
        }
        for (CodeSystem.PropertyComponent propertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem14_30.convertPropertyComponent(propertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem14_30.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static CodeSystem.CodeSystemContactComponent convertCodeSystemContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.CodeSystemContactComponent tgt = new CodeSystem.CodeSystemContactComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertCodeSystemContactComponent(CodeSystem.CodeSystemContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<CodeSystem.CodeSystemContentMode> convertCodeSystemContentMode(Enumeration<CodeSystem.CodeSystemContentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<CodeSystem.CodeSystemContentMode> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<CodeSystem.CodeSystemContentMode>(new CodeSystem.CodeSystemContentModeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.CodeSystemContentMode)((Object)src.getValue())) {
            case NOTPRESENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NOTPRESENT);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.EXAMPLAR);
                break;
            }
            case FRAGMENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.FRAGMENT);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.COMPLETE);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CodeSystem.CodeSystemContentMode> convertCodeSystemContentMode(org.hl7.fhir.dstu2016may.model.Enumeration<CodeSystem.CodeSystemContentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CodeSystem.CodeSystemContentMode> tgt = new Enumeration<CodeSystem.CodeSystemContentMode>(new CodeSystem.CodeSystemContentModeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.CodeSystemContentMode)((Object)src.getValue())) {
            case NOTPRESENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NOTPRESENT);
                break;
            }
            case EXAMPLAR: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.EXAMPLE);
                break;
            }
            case FRAGMENT: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.FRAGMENT);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.COMPLETE);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.CodeSystemContentMode.NULL);
            }
        }
        return tgt;
    }

    public static CodeSystem.CodeSystemFilterComponent convertCodeSystemFilterComponent(CodeSystem.CodeSystemFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.CodeSystemFilterComponent tgt = new CodeSystem.CodeSystemFilterComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        for (CodeType t : src.getOperator()) {
            try {
                tgt.addOperator(CodeSystem.FilterOperator.fromCode((String)t.getValue()));
            }
            catch (FHIRException e) {
                throw new FHIRException(e);
            }
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static CodeSystem.CodeSystemFilterComponent convertCodeSystemFilterComponent(CodeSystem.CodeSystemFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.CodeSystemFilterComponent tgt = new CodeSystem.CodeSystemFilterComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        for (Enumeration<CodeSystem.FilterOperator> t : src.getOperator()) {
            tgt.addOperator(((CodeSystem.FilterOperator)((Object)t.getValue())).toCode());
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionComponent convertConceptDefinitionComponent(CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent tgt = new CodeSystem.ConceptDefinitionComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_30.convertString(src.getDisplayElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_14_30.convertString(src.getDefinitionElement()));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(CodeSystem14_30.convertConceptDefinitionDesignationComponent(conceptDefinitionDesignationComponent));
        }
        for (CodeSystem.ConceptPropertyComponent conceptPropertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem14_30.convertConceptPropertyComponent(conceptPropertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem14_30.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionComponent convertConceptDefinitionComponent(CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent tgt = new CodeSystem.ConceptDefinitionComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_14_30.convertString(src.getDisplayElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_14_30.convertString(src.getDefinitionElement()));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(CodeSystem14_30.convertConceptDefinitionDesignationComponent(conceptDefinitionDesignationComponent));
        }
        for (CodeSystem.ConceptDefinitionPropertyComponent conceptDefinitionPropertyComponent : src.getProperty()) {
            tgt.addProperty(CodeSystem14_30.convertConceptPropertyComponent(conceptDefinitionPropertyComponent));
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(CodeSystem14_30.convertConceptDefinitionComponent(conceptDefinitionComponent));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionDesignationComponent convertConceptDefinitionDesignationComponent(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptDefinitionDesignationComponent tgt = new CodeSystem.ConceptDefinitionDesignationComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_30.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_14_30.convertCoding(src.getUse()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionDesignationComponent convertConceptDefinitionDesignationComponent(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptDefinitionDesignationComponent tgt = new CodeSystem.ConceptDefinitionDesignationComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_14_30.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_14_30.convertCoding(src.getUse()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_14_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionPropertyComponent convertConceptPropertyComponent(CodeSystem.ConceptPropertyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptDefinitionPropertyComponent tgt = new CodeSystem.ConceptDefinitionPropertyComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_30.convertType(src.getValue()));
        }
        return tgt;
    }

    public static CodeSystem.ConceptPropertyComponent convertConceptPropertyComponent(CodeSystem.ConceptDefinitionPropertyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptPropertyComponent tgt = new CodeSystem.ConceptPropertyComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_14_30.convertType(src.getValue()));
        }
        return tgt;
    }

    public static CodeSystem.PropertyComponent convertPropertyComponent(CodeSystem.CodeSystemPropertyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.PropertyComponent tgt = new CodeSystem.PropertyComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(CodeSystem14_30.convertPropertyType(src.getTypeElement()));
        }
        return tgt;
    }

    public static CodeSystem.CodeSystemPropertyComponent convertPropertyComponent(CodeSystem.PropertyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.CodeSystemPropertyComponent tgt = new CodeSystem.CodeSystemPropertyComponent();
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_30.convertCode(src.getCodeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(CodeSystem14_30.convertPropertyType(src.getTypeElement()));
        }
        return tgt;
    }

    public static Enumeration<CodeSystem.PropertyType> convertPropertyType(org.hl7.fhir.dstu2016may.model.Enumeration<CodeSystem.PropertyType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CodeSystem.PropertyType> tgt = new Enumeration<CodeSystem.PropertyType>(new CodeSystem.PropertyTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.PropertyType)((Object)src.getValue())) {
            case CODE: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODE);
                break;
            }
            case CODING: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODING);
                break;
            }
            case STRING: {
                tgt.setValue((Object)CodeSystem.PropertyType.STRING);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)CodeSystem.PropertyType.INTEGER);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)CodeSystem.PropertyType.BOOLEAN);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)CodeSystem.PropertyType.DATETIME);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.PropertyType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<CodeSystem.PropertyType> convertPropertyType(Enumeration<CodeSystem.PropertyType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration<CodeSystem.PropertyType> tgt = new org.hl7.fhir.dstu2016may.model.Enumeration<CodeSystem.PropertyType>(new CodeSystem.PropertyTypeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((CodeSystem.PropertyType)((Object)src.getValue())) {
            case CODE: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODE);
                break;
            }
            case CODING: {
                tgt.setValue((Object)CodeSystem.PropertyType.CODING);
                break;
            }
            case STRING: {
                tgt.setValue((Object)CodeSystem.PropertyType.STRING);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)CodeSystem.PropertyType.INTEGER);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)CodeSystem.PropertyType.BOOLEAN);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)CodeSystem.PropertyType.DATETIME);
                break;
            }
            default: {
                tgt.setValue((Object)CodeSystem.PropertyType.NULL);
            }
        }
        return tgt;
    }
}

