/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Schedule;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;

public class Schedule10_50 {
    public static Schedule convertSchedule(org.hl7.fhir.r5.model.Schedule src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Schedule tgt = new Schedule();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        for (CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addType(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_50.convertReference(src.getActorFirstRep()));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(VersionConvertor_10_50.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Schedule convertSchedule(Schedule src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Schedule tgt = new org.hl7.fhir.r5.model.Schedule();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addServiceType(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActor()) {
            tgt.addActor(VersionConvertor_10_50.convertReference(src.getActor()));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(VersionConvertor_10_50.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }
}

