/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.MedicationStatement;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.Reference;

public class MedicationStatement10_50 {
    public static MedicationStatement convertMedicationStatement(MedicationUsage src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationStatement tgt = new MedicationStatement();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationStatement10_50.convertMedicationStatementStatus(src.getStatusElement()));
        }
        if (src.getMedication().hasConcept()) {
            tgt.setMedication(VersionConvertor_10_50.convertType(src.getMedication().getConcept()));
        }
        if (src.getMedication().hasReference()) {
            tgt.setMedication(VersionConvertor_10_50.convertType(src.getMedication().getReference()));
        }
        if (src.hasSubject()) {
            tgt.setPatient(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_10_50.convertType(src.getEffective()));
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(VersionConvertor_10_50.convertReference(src.getInformationSource()));
        }
        for (Reference reference : src.getDerivedFrom()) {
            tgt.addSupportingInformation(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAssertedElement(VersionConvertor_10_50.convertDateTime(src.getDateAssertedElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.setNote(annotation.getText());
        }
        for (Dosage dosage : src.getDosage()) {
            tgt.addDosage(MedicationStatement10_50.convertMedicationStatementDosageComponent(dosage));
        }
        return tgt;
    }

    public static MedicationUsage convertMedicationStatement(MedicationStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationUsage tgt = new MedicationUsage();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationStatement10_50.convertMedicationStatementStatus(src.getStatusElement()));
        }
        if (src.hasMedicationCodeableConcept()) {
            tgt.getMedication().setConcept(VersionConvertor_10_50.convertCodeableConcept(src.getMedicationCodeableConcept()));
        }
        if (src.hasMedicationReference()) {
            tgt.getMedication().setReference(VersionConvertor_10_50.convertReference(src.getMedicationReference()));
        }
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getPatient()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_10_50.convertType(src.getEffective()));
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(VersionConvertor_10_50.convertReference(src.getInformationSource()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getSupportingInformation()) {
            tgt.addDerivedFrom(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAssertedElement(VersionConvertor_10_50.convertDateTime(src.getDateAssertedElement()));
        }
        if (src.hasNote()) {
            tgt.addNote().setText(src.getNote());
        }
        for (MedicationStatement.MedicationStatementDosageComponent medicationStatementDosageComponent : src.getDosage()) {
            tgt.addDosage(MedicationStatement10_50.convertMedicationStatementDosageComponent(medicationStatementDosageComponent));
        }
        return tgt;
    }

    public static Dosage convertMedicationStatementDosageComponent(MedicationStatement.MedicationStatementDosageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Dosage tgt = new Dosage();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_50.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_50.convertType(src.getAsNeeded()));
        }
        if (src.hasSiteCodeableConcept()) {
            tgt.setSite(VersionConvertor_10_50.convertCodeableConcept(src.getSiteCodeableConcept()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasRate()) {
            Dosage.DosageDoseAndRateComponent dr = tgt.addDoseAndRate();
            if (src.hasRate()) {
                dr.setRate(VersionConvertor_10_50.convertType(src.getRate()));
            }
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_50.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    public static MedicationStatement.MedicationStatementDosageComponent convertMedicationStatementDosageComponent(Dosage src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationStatement.MedicationStatementDosageComponent tgt = new MedicationStatement.MedicationStatementDosageComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_50.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_50.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_10_50.convertType(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDoseAndRate() && src.getDoseAndRate().get(0).hasRate()) {
            tgt.setRate(VersionConvertor_10_50.convertType(src.getDoseAndRate().get(0).getRate()));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_50.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes> convertMedicationStatementStatus(Enumeration<MedicationStatement.MedicationStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes>(new MedicationUsage.MedicationUsageStatusCodesEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationStatement.MedicationStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.INTENDED);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationStatement.MedicationStatementStatus> convertMedicationStatementStatus(org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationStatement.MedicationStatementStatus> tgt = new Enumeration<MedicationStatement.MedicationStatementStatus>(new MedicationStatement.MedicationStatementStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationUsage.MedicationUsageStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.INTENDED);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.NULL);
            }
        }
        return tgt;
    }
}

