/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Reference;

public class Encounter10_50 {
    public static org.hl7.fhir.dstu2.model.Encounter convertEncounter(Encounter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Encounter tgt = new org.hl7.fhir.dstu2.model.Encounter();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Encounter10_50.convertEncounterState(src.getStatusElement()));
        }
        if (src.hasClass_()) {
            tgt.setClass_(Encounter10_50.convertEncounterClass(src.getClass_()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_10_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasSubject()) {
            tgt.setPatient(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getEpisodeOfCare()) {
            tgt.addEpisodeOfCare(VersionConvertor_10_50.convertReference(reference));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addIncomingReferral(VersionConvertor_10_50.convertReference(reference));
        }
        for (Encounter.EncounterParticipantComponent encounterParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Encounter10_50.convertEncounterParticipantComponent(encounterParticipantComponent));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(VersionConvertor_10_50.convertReference(src.getAppointmentFirstRep()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasLength()) {
            tgt.setLength(VersionConvertor_10_50.convertDuration(src.getLength()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReason(VersionConvertor_10_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        if (src.hasHospitalization()) {
            tgt.setHospitalization(Encounter10_50.convertEncounterHospitalizationComponent(src.getHospitalization()));
        }
        for (Encounter.EncounterLocationComponent encounterLocationComponent : src.getLocation()) {
            tgt.addLocation(Encounter10_50.convertEncounterLocationComponent(encounterLocationComponent));
        }
        if (src.hasServiceProvider()) {
            tgt.setServiceProvider(VersionConvertor_10_50.convertReference(src.getServiceProvider()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_10_50.convertReference(src.getPartOf()));
        }
        return tgt;
    }

    public static Encounter convertEncounter(org.hl7.fhir.dstu2.model.Encounter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter tgt = new Encounter();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Encounter10_50.convertEncounterState(src.getStatusElement()));
        }
        if (src.hasClass_()) {
            tgt.setClass_(Encounter10_50.convertEncounterClass(src.getClass_()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_10_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getPatient()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getEpisodeOfCare()) {
            tgt.addEpisodeOfCare(VersionConvertor_10_50.convertReference(reference));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getIncomingReferral()) {
            tgt.addBasedOn(VersionConvertor_10_50.convertReference(reference));
        }
        for (Encounter.EncounterParticipantComponent encounterParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Encounter10_50.convertEncounterParticipantComponent(encounterParticipantComponent));
        }
        if (src.hasAppointment()) {
            tgt.addAppointment(VersionConvertor_10_50.convertReference(src.getAppointment()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasLength()) {
            tgt.setLength(VersionConvertor_10_50.convertDuration(src.getLength()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(VersionConvertor_10_50.convertCodeableConceptToCodableReference(codeableConcept));
        }
        if (src.hasHospitalization()) {
            tgt.setHospitalization(Encounter10_50.convertEncounterHospitalizationComponent(src.getHospitalization()));
        }
        for (Encounter.EncounterLocationComponent encounterLocationComponent : src.getLocation()) {
            tgt.addLocation(Encounter10_50.convertEncounterLocationComponent(encounterLocationComponent));
        }
        if (src.hasServiceProvider()) {
            tgt.setServiceProvider(VersionConvertor_10_50.convertReference(src.getServiceProvider()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_10_50.convertReference(src.getPartOf()));
        }
        return tgt;
    }

    public static Encounter.EncounterClass convertEncounterClass(Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src.getSystem().equals("http://terminology.hl7.org/v3/ActCode")) {
            if (src.getCode().equals("IMP")) {
                return Encounter.EncounterClass.INPATIENT;
            }
            if (src.getCode().equals("AMB")) {
                return Encounter.EncounterClass.AMBULATORY;
            }
            if (src.getCode().equals("EMER")) {
                return Encounter.EncounterClass.EMERGENCY;
            }
            if (src.getCode().equals("HH")) {
                return Encounter.EncounterClass.HOME;
            }
            if (src.getCode().equals("FLD")) {
                return Encounter.EncounterClass.FIELD;
            }
            if (src.getCode().equals("")) {
                return Encounter.EncounterClass.DAYTIME;
            }
            if (src.getCode().equals("VR")) {
                return Encounter.EncounterClass.VIRTUAL;
            }
        }
        return Encounter.EncounterClass.NULL;
    }

    public static Coding convertEncounterClass(Encounter.EncounterClass src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPATIENT: {
                return new Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("IMP");
            }
            case OUTPATIENT: {
                return new Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("AMB");
            }
            case AMBULATORY: {
                return new Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("AMB");
            }
            case EMERGENCY: {
                return new Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("EMER");
            }
            case HOME: {
                return new Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("HH");
            }
            case FIELD: {
                return new Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("FLD");
            }
            case DAYTIME: {
                return new Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("SS");
            }
            case VIRTUAL: {
                return new Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("VR");
            }
        }
        return null;
    }

    public static Encounter.EncounterHospitalizationComponent convertEncounterHospitalizationComponent(Encounter.EncounterHospitalizationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterHospitalizationComponent tgt = new Encounter.EncounterHospitalizationComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasPreAdmissionIdentifier()) {
            tgt.setPreAdmissionIdentifier(VersionConvertor_10_50.convertIdentifier(src.getPreAdmissionIdentifier()));
        }
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_10_50.convertReference(src.getOrigin()));
        }
        if (src.hasAdmitSource()) {
            tgt.setAdmitSource(VersionConvertor_10_50.convertCodeableConcept(src.getAdmitSource()));
        }
        if (src.hasReAdmission()) {
            tgt.setReAdmission(VersionConvertor_10_50.convertCodeableConcept(src.getReAdmission()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getDietPreference()) {
            tgt.addDietPreference(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getSpecialCourtesy()) {
            tgt.addSpecialCourtesy(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getSpecialArrangement()) {
            tgt.addSpecialArrangement(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_10_50.convertReference(src.getDestination()));
        }
        if (src.hasDischargeDisposition()) {
            tgt.setDischargeDisposition(VersionConvertor_10_50.convertCodeableConcept(src.getDischargeDisposition()));
        }
        return tgt;
    }

    public static Encounter.EncounterHospitalizationComponent convertEncounterHospitalizationComponent(Encounter.EncounterHospitalizationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterHospitalizationComponent tgt = new Encounter.EncounterHospitalizationComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasPreAdmissionIdentifier()) {
            tgt.setPreAdmissionIdentifier(VersionConvertor_10_50.convertIdentifier(src.getPreAdmissionIdentifier()));
        }
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_10_50.convertReference(src.getOrigin()));
        }
        if (src.hasAdmitSource()) {
            tgt.setAdmitSource(VersionConvertor_10_50.convertCodeableConcept(src.getAdmitSource()));
        }
        if (src.hasReAdmission()) {
            tgt.setReAdmission(VersionConvertor_10_50.convertCodeableConcept(src.getReAdmission()));
        }
        for (CodeableConcept t : src.getDietPreference()) {
            tgt.addDietPreference(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getSpecialCourtesy()) {
            tgt.addSpecialCourtesy(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getSpecialArrangement()) {
            tgt.addSpecialArrangement(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_10_50.convertReference(src.getDestination()));
        }
        if (src.hasDischargeDisposition()) {
            tgt.setDischargeDisposition(VersionConvertor_10_50.convertCodeableConcept(src.getDischargeDisposition()));
        }
        return tgt;
    }

    public static Encounter.EncounterLocationComponent convertEncounterLocationComponent(Encounter.EncounterLocationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterLocationComponent tgt = new Encounter.EncounterLocationComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_50.convertReference(src.getLocation()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Encounter10_50.convertEncounterLocationStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Encounter.EncounterLocationComponent convertEncounterLocationComponent(Encounter.EncounterLocationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterLocationComponent tgt = new Encounter.EncounterLocationComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_50.convertReference(src.getLocation()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Encounter10_50.convertEncounterLocationStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Encounter.EncounterLocationStatus> convertEncounterLocationStatus(Enumeration<Encounter.EncounterLocationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Encounter.EncounterLocationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Encounter.EncounterLocationStatus>(new Encounter.EncounterLocationStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Encounter.EncounterLocationStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.PLANNED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.ACTIVE);
                break;
            }
            case RESERVED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.RESERVED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.COMPLETED);
                break;
            }
            default: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Encounter.EncounterLocationStatus> convertEncounterLocationStatus(org.hl7.fhir.r5.model.Enumeration<Encounter.EncounterLocationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Encounter.EncounterLocationStatus> tgt = new Enumeration<Encounter.EncounterLocationStatus>(new Encounter.EncounterLocationStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Encounter.EncounterLocationStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.PLANNED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.ACTIVE);
                break;
            }
            case RESERVED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.RESERVED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.COMPLETED);
                break;
            }
            default: {
                tgt.setValue((Object)Encounter.EncounterLocationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Encounter.EncounterParticipantComponent convertEncounterParticipantComponent(Encounter.EncounterParticipantComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterParticipantComponent tgt = new Encounter.EncounterParticipantComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasIndividual()) {
            tgt.setIndividual(VersionConvertor_10_50.convertReference(src.getIndividual()));
        }
        return tgt;
    }

    public static Encounter.EncounterParticipantComponent convertEncounterParticipantComponent(Encounter.EncounterParticipantComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterParticipantComponent tgt = new Encounter.EncounterParticipantComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        for (CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasIndividual()) {
            tgt.setIndividual(VersionConvertor_10_50.convertReference(src.getIndividual()));
        }
        return tgt;
    }

    public static Enumeration<Encounter.EncounterState> convertEncounterState(org.hl7.fhir.r5.model.Enumeration<Encounter.EncounterStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Encounter.EncounterState> tgt = new Enumeration<Encounter.EncounterState>(new Encounter.EncounterStateEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Encounter.EncounterStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)Encounter.EncounterState.PLANNED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Encounter.EncounterState.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Encounter.EncounterState.FINISHED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Encounter.EncounterState.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)Encounter.EncounterState.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Encounter.EncounterStatus> convertEncounterState(Enumeration<Encounter.EncounterState> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Encounter.EncounterStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Encounter.EncounterStatus>(new Encounter.EncounterStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Encounter.EncounterState)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)Encounter.EncounterStatus.PLANNED);
                break;
            }
            case ARRIVED: {
                tgt.setValue((Object)Encounter.EncounterStatus.INPROGRESS);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Encounter.EncounterStatus.INPROGRESS);
                break;
            }
            case ONLEAVE: {
                tgt.setValue((Object)Encounter.EncounterStatus.INPROGRESS);
                break;
            }
            case FINISHED: {
                tgt.setValue((Object)Encounter.EncounterStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Encounter.EncounterStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)Encounter.EncounterStatus.NULL);
            }
        }
        return tgt;
    }
}

