/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Appointment;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class Appointment10_50 {
    public static org.hl7.fhir.dstu2.model.Appointment convertAppointment(Appointment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Appointment tgt = new org.hl7.fhir.dstu2.model.Appointment();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment10_50.convertAppointmentStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriorityElement()) {
            tgt.setPriorityElement(VersionConvertor_10_50.convertUnsignedInt(src.getPriorityElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_50.convertInstant(src.getEndElement()));
        }
        if (src.hasMinutesDurationElement()) {
            tgt.setMinutesDurationElement(VersionConvertor_10_50.convertPositiveInt(src.getMinutesDurationElement()));
        }
        for (Reference reference : src.getSlot()) {
            tgt.addSlot(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_50.convertString(src.getCommentElement()));
        }
        for (Appointment.AppointmentParticipantComponent appointmentParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Appointment10_50.convertAppointmentParticipantComponent(appointmentParticipantComponent));
        }
        return tgt;
    }

    public static Appointment convertAppointment(org.hl7.fhir.dstu2.model.Appointment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Appointment tgt = new Appointment();
        VersionConvertor_10_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment10_50.convertAppointmentStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.addServiceType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasPriorityElement()) {
            tgt.setPriorityElement(VersionConvertor_10_50.convertUnsignedInt(src.getPriorityElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_50.convertInstant(src.getEndElement()));
        }
        if (src.hasMinutesDurationElement()) {
            tgt.setMinutesDurationElement(VersionConvertor_10_50.convertPositiveInt(src.getMinutesDurationElement()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getSlot()) {
            tgt.addSlot(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_50.convertString(src.getCommentElement()));
        }
        for (Appointment.AppointmentParticipantComponent appointmentParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(Appointment10_50.convertAppointmentParticipantComponent(appointmentParticipantComponent));
        }
        return tgt;
    }

    public static Appointment.AppointmentParticipantComponent convertAppointmentParticipantComponent(Appointment.AppointmentParticipantComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Appointment.AppointmentParticipantComponent tgt = new Appointment.AppointmentParticipantComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        for (CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_50.convertReference(src.getActor()));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(Appointment10_50.convertParticipantRequired(src.getRequiredElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment10_50.convertParticipationStatus(src.getStatusElement()));
        }
        return tgt;
    }

    public static Appointment.AppointmentParticipantComponent convertAppointmentParticipantComponent(Appointment.AppointmentParticipantComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Appointment.AppointmentParticipantComponent tgt = new Appointment.AppointmentParticipantComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_50.convertReference(src.getActor()));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(Appointment10_50.convertParticipantRequired(src.getRequiredElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Appointment10_50.convertParticipationStatus(src.getStatusElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Appointment.AppointmentStatus> convertAppointmentStatus(Enumeration<Appointment.AppointmentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Appointment.AppointmentStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Appointment.AppointmentStatus>(new Appointment.AppointmentStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Appointment.AppointmentStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PROPOSED);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PENDING);
                break;
            }
            case BOOKED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.BOOKED);
                break;
            }
            case ARRIVED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.ARRIVED);
                break;
            }
            case FULFILLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.FULFILLED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.CANCELLED);
                break;
            }
            case NOSHOW: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NOSHOW);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Appointment.AppointmentStatus> convertAppointmentStatus(org.hl7.fhir.r5.model.Enumeration<Appointment.AppointmentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Appointment.AppointmentStatus> tgt = new Enumeration<Appointment.AppointmentStatus>(new Appointment.AppointmentStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Appointment.AppointmentStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PROPOSED);
                break;
            }
            case PENDING: {
                tgt.setValue((Object)Appointment.AppointmentStatus.PENDING);
                break;
            }
            case BOOKED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.BOOKED);
                break;
            }
            case ARRIVED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.ARRIVED);
                break;
            }
            case FULFILLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.FULFILLED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Appointment.AppointmentStatus.CANCELLED);
                break;
            }
            case NOSHOW: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NOSHOW);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.AppointmentStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Appointment.ParticipantRequired> convertParticipantRequired(org.hl7.fhir.r5.model.Enumeration<Appointment.ParticipantRequired> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Appointment.ParticipantRequired> tgt = new Enumeration<Appointment.ParticipantRequired>(new Appointment.ParticipantRequiredEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Appointment.ParticipantRequired)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Appointment.ParticipantRequired.REQUIRED);
                break;
            }
            case OPTIONAL: {
                tgt.setValue((Object)Appointment.ParticipantRequired.OPTIONAL);
                break;
            }
            case INFORMATIONONLY: {
                tgt.setValue((Object)Appointment.ParticipantRequired.INFORMATIONONLY);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.ParticipantRequired.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Appointment.ParticipantRequired> convertParticipantRequired(Enumeration<Appointment.ParticipantRequired> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Appointment.ParticipantRequired> tgt = new org.hl7.fhir.r5.model.Enumeration<Appointment.ParticipantRequired>(new Appointment.ParticipantRequiredEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Appointment.ParticipantRequired)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Appointment.ParticipantRequired.REQUIRED);
                break;
            }
            case OPTIONAL: {
                tgt.setValue((Object)Appointment.ParticipantRequired.OPTIONAL);
                break;
            }
            case INFORMATIONONLY: {
                tgt.setValue((Object)Appointment.ParticipantRequired.INFORMATIONONLY);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.ParticipantRequired.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> convertParticipationStatus(Enumeration<Appointment.ParticipationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus>(new Enumerations.ParticipationStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Appointment.ParticipationStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Appointment.ParticipationStatus> convertParticipationStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Appointment.ParticipationStatus> tgt = new Enumeration<Appointment.ParticipationStatus>(new Appointment.ParticipationStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ParticipationStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)Appointment.ParticipationStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)Appointment.ParticipationStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)Appointment.ParticipationStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)Appointment.ParticipationStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)Appointment.ParticipationStatus.NULL);
            }
        }
        return tgt;
    }
}

