/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import java.util.ArrayList;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

public class StructureDefinition10_40 {
    public static Enumeration<StructureDefinition.ExtensionContextType> convertExtensionContext(org.hl7.fhir.dstu2.model.Enumeration<StructureDefinition.ExtensionContext> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.ExtensionContextType> tgt = new Enumeration<StructureDefinition.ExtensionContextType>(new StructureDefinition.ExtensionContextTypeEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((StructureDefinition.ExtensionContext)((Object)src.getValue())) {
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.ELEMENT);
                break;
            }
            case DATATYPE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.ELEMENT);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<StructureDefinition.ExtensionContext> convertExtensionContext(Enumeration<StructureDefinition.ExtensionContextType> src, String expression) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration<StructureDefinition.ExtensionContext> tgt = new org.hl7.fhir.dstu2.model.Enumeration<StructureDefinition.ExtensionContext>(new StructureDefinition.ExtensionContextEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((StructureDefinition.ExtensionContextType)((Object)src.getValue())) {
            case FHIRPATH: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.RESOURCE);
                break;
            }
            case ELEMENT: {
                String tn;
                String string = tn = expression.contains(".") ? expression.substring(0, expression.indexOf(".")) : expression;
                if (StructureDefinition10_40.isResource102(tn)) {
                    tgt.setValue((Object)StructureDefinition.ExtensionContext.RESOURCE);
                    break;
                }
                tgt.setValue((Object)StructureDefinition.ExtensionContext.DATATYPE);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.NULL);
            }
        }
        return tgt;
    }

    public static StructureDefinition convertStructureDefinition(org.hl7.fhir.dstu2.model.StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_40.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasDisplayElement()) {
            tgt.setTitleElement(VersionConvertor_10_40.convertString(src.getDisplayElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_10_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_40.convertString(src.getPublisherElement()));
        }
        for (StructureDefinition.StructureDefinitionContactComponent structureDefinitionContactComponent : src.getContact()) {
            tgt.addContact(StructureDefinition10_40.convertStructureDefinitionContactComponent(structureDefinitionContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (org.hl7.fhir.dstu2.model.Coding coding : src.getCode()) {
            tgt.addKeyword(VersionConvertor_10_40.convertCoding(coding));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(Enumerations.FHIRVersion.fromCode(src.getFhirVersion()));
        }
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(StructureDefinition10_40.convertStructureDefinitionMappingComponent(structureDefinitionMappingComponent));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition10_40.convertStructureDefinitionKind(src.getKindElement(), tgt.getId()));
        }
        if (src.hasAbstractElement()) {
            tgt.setAbstractElement(VersionConvertor_10_40.convertBoolean(src.getAbstractElement()));
        }
        for (StringType stringType : src.getContext()) {
            StructureDefinition.StructureDefinitionContextComponent ec = tgt.addContext();
            ec.setTypeElement(StructureDefinition10_40.convertExtensionContext(src.getContextTypeElement()));
            ec.setExpression("*".equals(stringType.getValue()) ? "Element" : (String)stringType.getValue());
        }
        if (src.hasConstrainedType()) {
            tgt.setType(src.getConstrainedType());
        } else if (src.getSnapshot().hasElement()) {
            tgt.setType(src.getSnapshot().getElement().get(0).getPath());
        } else if (src.getDifferential().hasElement() && !src.getDifferential().getElement().get(0).getPath().contains(".")) {
            tgt.setType(src.getDifferential().getElement().get(0).getPath());
        } else {
            tgt.setType(src.getDifferential().getElement().get(0).getPath().substring(0, src.getDifferential().getElement().get(0).getPath().indexOf(".")));
        }
        if (src.hasBase()) {
            tgt.setBaseDefinition(src.getBase());
        }
        tgt.setDerivation(src.hasConstrainedType() ? StructureDefinition.TypeDerivationRule.CONSTRAINT : StructureDefinition.TypeDerivationRule.SPECIALIZATION);
        if (src.hasSnapshot()) {
            tgt.setSnapshot(StructureDefinition10_40.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(StructureDefinition10_40.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        if (tgt.hasSnapshot()) {
            tgt.getSnapshot().getElementFirstRep().getType().clear();
        }
        if (tgt.hasDifferential()) {
            tgt.getDifferential().getElementFirstRep().getType().clear();
        }
        if (tgt.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE && !tgt.getType().equals(tgt.getId())) {
            tgt.setDerivation(StructureDefinition.TypeDerivationRule.SPECIALIZATION);
            tgt.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/" + tgt.getType());
            tgt.setType(tgt.getId());
        }
        if (tgt.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
            for (ElementDefinition elementDefinition : tgt.getSnapshot().getElement()) {
                if (elementDefinition.hasBase()) continue;
                elementDefinition.getBase().setPath(elementDefinition.getPath()).setMin(elementDefinition.getMin()).setMax(elementDefinition.getMax());
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.StructureDefinition convertStructureDefinition(StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.StructureDefinition tgt = new org.hl7.fhir.dstu2.model.StructureDefinition();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_40.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasTitleElement()) {
            tgt.setDisplayElement(VersionConvertor_10_40.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(StructureDefinition10_40.convertStructureDefinitionContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Coding coding : src.getKeyword()) {
            tgt.addCode(VersionConvertor_10_40.convertCoding(coding));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion().toCode());
        }
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(StructureDefinition10_40.convertStructureDefinitionMappingComponent(structureDefinitionMappingComponent));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition10_40.convertStructureDefinitionKind(src.getKindElement()));
        }
        if (src.hasAbstractElement()) {
            tgt.setAbstractElement(VersionConvertor_10_40.convertBoolean(src.getAbstractElement()));
        }
        for (StructureDefinition.StructureDefinitionContextComponent structureDefinitionContextComponent : src.getContext()) {
            if (!tgt.hasContextType()) {
                tgt.setContextTypeElement(StructureDefinition10_40.convertExtensionContext(structureDefinitionContextComponent.getTypeElement(), structureDefinitionContextComponent.getExpression()));
            }
            tgt.addContext("Element".equals(structureDefinitionContextComponent.getExpression()) ? "*" : structureDefinitionContextComponent.getExpression());
        }
        if (src.hasType()) {
            tgt.setConstrainedType(src.getType());
        }
        if (src.hasBaseDefinition()) {
            tgt.setBase(src.getBaseDefinition());
        }
        if (src.hasSnapshot()) {
            tgt.setSnapshot(StructureDefinition10_40.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(StructureDefinition10_40.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        if (tgt.hasBase()) {
            if (tgt.hasDifferential()) {
                tgt.getDifferential().getElement().get(0).addType().setCode(StructureDefinition10_40.tail(tgt.getBase()));
            }
            if (tgt.hasSnapshot()) {
                tgt.getSnapshot().getElement().get(0).addType().setCode(StructureDefinition10_40.tail(tgt.getBase()));
            }
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionContactComponent convertStructureDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionContactComponent tgt = new StructureDefinition.StructureDefinitionContactComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertStructureDefinitionContactComponent(StructureDefinition.StructureDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        ArrayList<String> slicePaths = new ArrayList<String>();
        for (org.hl7.fhir.dstu2.model.ElementDefinition t : src.getElement()) {
            if (t.hasSlicing()) {
                slicePaths.add(t.getPath());
            }
            tgt.addElement(VersionConvertor_10_40.convertElementDefinition(t, slicePaths, src.getElement(), src.getElement().indexOf(t)));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_10_40.convertElementDefinition(t));
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(org.hl7.fhir.dstu2.model.Enumeration<StructureDefinition.StructureDefinitionKind> src, String dtName) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.StructureDefinitionKind> tgt = new Enumeration<StructureDefinition.StructureDefinitionKind>(new StructureDefinition.StructureDefinitionKindEnumFactory());
        switch ((StructureDefinition.StructureDefinitionKind)((Object)src.getValue())) {
            case DATATYPE: {
                if (Utilities.existsInList(dtName, "boolean", "integer", "decimal", "base64Binary", "instant", "string", "uri", "date", "dateTime", "time", "code", "oid", "uuid", "id", "unsignedInt", "positiveInt", "markdown", "xhtml", "url", "canonical")) {
                    tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE);
                    break;
                }
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(Enumeration<StructureDefinition.StructureDefinitionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration<StructureDefinition.StructureDefinitionKind> tgt = new org.hl7.fhir.dstu2.model.Enumeration<StructureDefinition.StructureDefinitionKind>(new StructureDefinition.StructureDefinitionKindEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((StructureDefinition.StructureDefinitionKind)((Object)src.getValue())) {
            case PRIMITIVETYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.DATATYPE);
                break;
            }
            case COMPLEXTYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.DATATYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_40.convertId(src.getIdentityElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_10_40.convertUri(src.getUriElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentsElement(VersionConvertor_10_40.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_40.convertId(src.getIdentityElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_10_40.convertUri(src.getUriElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasCommentsElement()) {
            tgt.setCommentElement(VersionConvertor_10_40.convertString(src.getCommentsElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        ArrayList<String> slicePaths = new ArrayList<String>();
        for (org.hl7.fhir.dstu2.model.ElementDefinition t : src.getElement()) {
            if (t.hasSlicing()) {
                slicePaths.add(t.getPath());
            }
            tgt.addElement(VersionConvertor_10_40.convertElementDefinition(t, slicePaths, src.getElement(), src.getElement().indexOf(t)));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_10_40.convertElementDefinition(t));
        }
        return tgt;
    }

    public static boolean isResource102(String tn) {
        return Utilities.existsInList(tn, "AllergyIntolerance", "Appointment", "AppointmentResponse", "AuditEvent", "Basic", "Binary", "BodySite", "Bundle", "CarePlan", "Claim", "ClaimResponse", "ClinicalImpression", "Communication", "CommunicationRequest", "Composition", "ConceptMap", "Condition", "Conformance", "Contract", "DetectedIssue", "Coverage", "DataElement", "Device", "DeviceComponent", "DeviceMetric", "DeviceUseRequest", "DeviceUseStatement", "DiagnosticOrder", "DiagnosticReport", "DocumentManifest", "DocumentReference", "EligibilityRequest", "EligibilityResponse", "Encounter", "EnrollmentRequest", "EnrollmentResponse", "EpisodeOfCare", "ExplanationOfBenefit", "FamilyMemberHistory", "Flag", "Goal", "Group", "HealthcareService", "ImagingObjectSelection", "ImagingStudy", "Immunization", "ImmunizationRecommendation", "ImplementationGuide", "List", "Location", "Media", "Medication", "MedicationAdministration", "MedicationDispense", "MedicationOrder", "MedicationStatement", "MessageHeader", "NamingSystem", "NutritionOrder", "Observation", "OperationDefinition", "OperationOutcome", "Order", "OrderResponse", "Organization", "Parameters", "Patient", "PaymentNotice", "PaymentReconciliation", "Person", "Practitioner", "Procedure", "ProcessRequest", "ProcessResponse", "ProcedureRequest", "Provenance", "Questionnaire", "QuestionnaireResponse", "ReferralRequest", "RelatedPerson", "RiskAssessment", "Schedule", "SearchParameter", "Slot", "Specimen", "StructureDefinition", "Subscription", "Substance", "SupplyRequest", "SupplyDelivery", "TestScript", "ValueSet", "VisionPrescription");
    }

    public static String tail(String base) {
        return base.substring(base.lastIndexOf("/") + 1);
    }
}

