/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Slot;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;

public class Slot10_40 {
    public static org.hl7.fhir.r4.model.Slot convertSlot(Slot src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Slot tgt = new org.hl7.fhir.r4.model.Slot();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        if (src.hasType()) {
            tgt.addServiceType(VersionConvertor_10_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSchedule()) {
            tgt.setSchedule(VersionConvertor_10_40.convertReference(src.getSchedule()));
        }
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_40.convertInstant(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_40.convertInstant(src.getEndElement()));
        }
        if (src.hasOverbookedElement()) {
            tgt.setOverbookedElement(VersionConvertor_10_40.convertBoolean(src.getOverbookedElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_40.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static Slot convertSlot(org.hl7.fhir.r4.model.Slot src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Slot tgt = new Slot();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        for (CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.setType(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSchedule()) {
            tgt.setSchedule(VersionConvertor_10_40.convertReference(src.getSchedule()));
        }
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_40.convertInstant(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_40.convertInstant(src.getEndElement()));
        }
        if (src.hasOverbookedElement()) {
            tgt.setOverbookedElement(VersionConvertor_10_40.convertBoolean(src.getOverbookedElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_40.convertString(src.getCommentElement()));
        }
        return tgt;
    }
}

