/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.List_;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.ListResource;

public class List10_40 {
    public static ListResource convertList(List_ src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ListResource tgt = new ListResource();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_40.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_40.convertReference(src.getSource()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_40.convertReference(src.getEncounter()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(List10_40.convertListStatus(src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_10_40.convertCodeableConcept(src.getOrderedBy()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(List10_40.convertListMode(src.getModeElement()));
        }
        if (src.hasNote()) {
            tgt.addNote(new Annotation().setText(src.getNote()));
        }
        for (List_.ListEntryComponent listEntryComponent : src.getEntry()) {
            tgt.addEntry(List10_40.convertListEntry(listEntryComponent));
        }
        return tgt;
    }

    public static List_ convertList(ListResource src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        List_ tgt = new List_();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_40.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_40.convertReference(src.getSource()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_40.convertReference(src.getEncounter()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(List10_40.convertListStatus(src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_10_40.convertCodeableConcept(src.getOrderedBy()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(List10_40.convertListMode(src.getModeElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.setNote(annotation.getText());
        }
        for (ListResource.ListEntryComponent listEntryComponent : src.getEntry()) {
            tgt.addEntry(List10_40.convertListEntry(listEntryComponent));
        }
        return tgt;
    }

    public static ListResource.ListEntryComponent convertListEntry(List_.ListEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ListResource.ListEntryComponent tgt = new ListResource.ListEntryComponent();
        List10_40.copyBackboneElement(src, tgt);
        if (src.hasFlag()) {
            tgt.setFlag(VersionConvertor_10_40.convertCodeableConcept(src.getFlag()));
        }
        if (src.hasDeletedElement()) {
            tgt.setDeletedElement(VersionConvertor_10_40.convertBoolean(src.getDeletedElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_10_40.convertReference(src.getItem()));
        }
        return tgt;
    }

    public static List_.ListEntryComponent convertListEntry(ListResource.ListEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        List_.ListEntryComponent tgt = new List_.ListEntryComponent();
        List10_40.copyBackboneElement(src, tgt);
        if (src.hasFlag()) {
            tgt.setFlag(VersionConvertor_10_40.convertCodeableConcept(src.getFlag()));
        }
        if (src.hasDeletedElement()) {
            tgt.setDeletedElement(VersionConvertor_10_40.convertBoolean(src.getDeletedElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_10_40.convertReference(src.getItem()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<List_.ListMode> convertListMode(Enumeration<ListResource.ListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration<List_.ListMode> tgt = new org.hl7.fhir.dstu2.model.Enumeration<List_.ListMode>(new List_.ListModeEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((ListResource.ListMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)List_.ListMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)List_.ListMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)List_.ListMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)List_.ListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ListResource.ListMode> convertListMode(org.hl7.fhir.dstu2.model.Enumeration<List_.ListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ListResource.ListMode> tgt = new Enumeration<ListResource.ListMode>(new ListResource.ListModeEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((List_.ListMode)((Object)src.getValue())) {
            case WORKING: {
                tgt.setValue((Object)ListResource.ListMode.WORKING);
                break;
            }
            case SNAPSHOT: {
                tgt.setValue((Object)ListResource.ListMode.SNAPSHOT);
                break;
            }
            case CHANGES: {
                tgt.setValue((Object)ListResource.ListMode.CHANGES);
                break;
            }
            default: {
                tgt.setValue((Object)ListResource.ListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ListResource.ListStatus> convertListStatus(org.hl7.fhir.dstu2.model.Enumeration<List_.ListStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ListResource.ListStatus> tgt = new Enumeration<ListResource.ListStatus>(new ListResource.ListStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((List_.ListStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)ListResource.ListStatus.CURRENT);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)ListResource.ListStatus.RETIRED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ListResource.ListStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ListResource.ListStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<List_.ListStatus> convertListStatus(Enumeration<ListResource.ListStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration<List_.ListStatus> tgt = new org.hl7.fhir.dstu2.model.Enumeration<List_.ListStatus>(new List_.ListStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((ListResource.ListStatus)((Object)src.getValue())) {
            case CURRENT: {
                tgt.setValue((Object)List_.ListStatus.CURRENT);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)List_.ListStatus.RETIRED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)List_.ListStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)List_.ListStatus.NULL);
            }
        }
        return tgt;
    }

    public static void copyBackboneElement(org.hl7.fhir.r4.model.BackboneElement src, BackboneElement tgt) throws FHIRException {
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        for (Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_10_40.convertExtension(e));
        }
    }

    public static void copyBackboneElement(BackboneElement src, org.hl7.fhir.r4.model.BackboneElement tgt) throws FHIRException {
        VersionConvertor_10_40.copyElement(src, tgt);
        for (org.hl7.fhir.dstu2.model.Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_10_40.convertExtension(e));
        }
    }
}

