/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.ImplementationGuide;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;

public class ImplementationGuide10_40 {
    public static ImplementationGuide convertImplementationGuide(org.hl7.fhir.dstu2.model.ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide tgt = new ImplementationGuide();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_40.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_10_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_40.convertString(src.getPublisherElement()));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent implementationGuideContactComponent : src.getContact()) {
            tgt.addContact(ImplementationGuide10_40.convertImplementationGuideContactComponent(implementationGuideContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasFhirVersion()) {
            tgt.addFhirVersion(Enumerations.FHIRVersion.fromCode(src.getFhirVersion()));
        }
        for (ImplementationGuide.ImplementationGuideDependencyComponent implementationGuideDependencyComponent : src.getDependency()) {
            tgt.addDependsOn(ImplementationGuide10_40.convertImplementationGuideDependencyComponent(implementationGuideDependencyComponent));
        }
        for (ImplementationGuide.ImplementationGuidePackageComponent implementationGuidePackageComponent : src.getPackage()) {
            tgt.getDefinition().addGrouping(ImplementationGuide10_40.convertImplementationGuidePackageComponent(tgt.getDefinition(), implementationGuidePackageComponent));
        }
        for (ImplementationGuide.ImplementationGuideGlobalComponent implementationGuideGlobalComponent : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide10_40.convertImplementationGuideGlobalComponent(implementationGuideGlobalComponent));
        }
        tgt.getDefinition().setPage(ImplementationGuide10_40.convertImplementationGuidePageComponent(src.getPage()));
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.ImplementationGuide convertImplementationGuide(ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.ImplementationGuide tgt = new org.hl7.fhir.dstu2.model.ImplementationGuide();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_40.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ImplementationGuide10_40.convertImplementationGuideContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Enumeration enumeration : src.getFhirVersion()) {
            tgt.setFhirVersion(enumeration.asStringValue());
        }
        for (ImplementationGuide.ImplementationGuideDependsOnComponent implementationGuideDependsOnComponent : src.getDependsOn()) {
            tgt.addDependency(ImplementationGuide10_40.convertImplementationGuideDependencyComponent(implementationGuideDependsOnComponent));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionGroupingComponent implementationGuideDefinitionGroupingComponent : src.getDefinition().getGrouping()) {
            tgt.addPackage(ImplementationGuide10_40.convertImplementationGuidePackageComponent(implementationGuideDefinitionGroupingComponent));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionResourceComponent implementationGuideDefinitionResourceComponent : src.getDefinition().getResource()) {
            ImplementationGuide10_40.findPackage(tgt.getPackage(), implementationGuideDefinitionResourceComponent.getGroupingId()).addResource(ImplementationGuide10_40.convertImplementationGuidePackageResourceComponent(implementationGuideDefinitionResourceComponent));
        }
        for (ImplementationGuide.ImplementationGuideGlobalComponent implementationGuideGlobalComponent : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide10_40.convertImplementationGuideGlobalComponent(implementationGuideGlobalComponent));
        }
        tgt.setPage(ImplementationGuide10_40.convertImplementationGuidePageComponent(src.getDefinition().getPage()));
        return tgt;
    }

    public static ContactDetail convertImplementationGuideContactComponent(ImplementationGuide.ImplementationGuideContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideContactComponent convertImplementationGuideContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideContactComponent tgt = new ImplementationGuide.ImplementationGuideContactComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependsOnComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependencyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependsOnComponent tgt = new ImplementationGuide.ImplementationGuideDependsOnComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependencyComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependsOnComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependencyComponent tgt = new ImplementationGuide.ImplementationGuideDependencyComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        tgt.setType(ImplementationGuide.GuideDependencyType.REFERENCE);
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_10_40.convertCode(src.getTypeElement()));
        }
        if (src.hasProfileElement()) {
            tgt.setProfile(VersionConvertor_10_40.convertCanonicalToReference(src.getProfileElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_10_40.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_10_40.convertReferenceToCanonical(src.getProfile()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionGroupingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageComponent tgt = new ImplementationGuide.ImplementationGuidePackageComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        tgt.setId(src.getId());
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionGroupingComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionComponent context, ImplementationGuide.ImplementationGuidePackageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionGroupingComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
        tgt.setId("p" + (context.getGrouping().size() + 1));
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        for (ImplementationGuide.ImplementationGuidePackageResourceComponent t : src.getResource()) {
            ImplementationGuide.ImplementationGuideDefinitionResourceComponent tn = ImplementationGuide10_40.convertImplementationGuidePackageResourceComponent(t);
            tn.setGroupingId(tgt.getId());
            context.addResource(tn);
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuideDefinitionResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageResourceComponent tgt = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasExampleCanonicalType()) {
            tgt.setExampleFor(VersionConvertor_10_40.convertCanonicalToReference(src.getExampleCanonicalType()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasReference()) {
            tgt.setSource(VersionConvertor_10_40.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuidePackageResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionResourceComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasExampleFor()) {
            tgt.setExample(VersionConvertor_10_40.convertReferenceToCanonical(src.getExampleFor()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasSourceReference()) {
            tgt.setReference(VersionConvertor_10_40.convertReference(src.getSourceReference()));
        } else if (src.hasSourceUriType()) {
            tgt.setReference(new Reference((String)src.getSourceUriType().getValue()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionPageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuidePageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionPageComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasSource() && src.hasSourceElement()) {
            tgt.setName(ImplementationGuide10_40.convertUriToUrl(src.getSourceElement()));
        }
        if (src.hasNameElement()) {
            tgt.setTitleElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasKind()) {
            tgt.setGeneration(ImplementationGuide10_40.convertPageGeneration(src.getKind()));
        }
        for (ImplementationGuide.ImplementationGuidePageComponent t : src.getPage()) {
            tgt.addPage(ImplementationGuide10_40.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuideDefinitionPageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePageComponent tgt = new ImplementationGuide.ImplementationGuidePageComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasNameUrlType()) {
            tgt.setSource((String)src.getNameUrlType().getValue());
        }
        if (src.hasTitleElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getTitleElement()));
        }
        if (src.hasGeneration()) {
            tgt.setKind(ImplementationGuide10_40.convertPageGeneration(src.getGeneration()));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionPageComponent t : src.getPage()) {
            tgt.addPage(ImplementationGuide10_40.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    public static ImplementationGuide.GuidePageKind convertPageGeneration(ImplementationGuide.GuidePageGeneration generation) {
        switch (generation) {
            case HTML: {
                return ImplementationGuide.GuidePageKind.PAGE;
            }
        }
        return ImplementationGuide.GuidePageKind.RESOURCE;
    }

    public static ImplementationGuide.GuidePageGeneration convertPageGeneration(ImplementationGuide.GuidePageKind kind) {
        switch (kind) {
            case PAGE: {
                return ImplementationGuide.GuidePageGeneration.HTML;
            }
        }
        return ImplementationGuide.GuidePageGeneration.GENERATED;
    }

    public static UrlType convertUriToUrl(UriType src) throws FHIRException {
        UrlType tgt = new UrlType((String)src.getValue());
        VersionConvertor_10_40.copyElement(src, tgt);
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent findPackage(List<ImplementationGuide.ImplementationGuidePackageComponent> definition, String id) {
        if (id != null) {
            for (ImplementationGuide.ImplementationGuidePackageComponent t : definition) {
                if (!id.equals(t.getId())) continue;
                return t;
            }
        }
        ImplementationGuide.ImplementationGuidePackageComponent t = new ImplementationGuide.ImplementationGuidePackageComponent();
        t.setName("Default Package");
        t.setId(id);
        return t;
    }
}

