/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.HealthcareService;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Reference;

public class HealthcareService10_40 {
    public static Enumeration<HealthcareService.DaysOfWeek> convertDaysOfWeek(org.hl7.fhir.dstu2.model.Enumeration<HealthcareService.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<HealthcareService.DaysOfWeek> tgt = new Enumeration<HealthcareService.DaysOfWeek>(new HealthcareService.DaysOfWeekEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((HealthcareService.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<HealthcareService.DaysOfWeek> convertDaysOfWeek(Enumeration<HealthcareService.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration<HealthcareService.DaysOfWeek> tgt = new org.hl7.fhir.dstu2.model.Enumeration<HealthcareService.DaysOfWeek>(new HealthcareService.DaysOfWeekEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((HealthcareService.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static HealthcareService convertHealthcareService(org.hl7.fhir.dstu2.model.HealthcareService src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService tgt = new HealthcareService();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_10_40.convertReference(src.getProvidedBy()));
        }
        for (HealthcareService.ServiceTypeComponent serviceTypeComponent : src.getServiceType()) {
            for (CodeableConcept tj : serviceTypeComponent.getSpecialty()) {
                tgt.addSpecialty(VersionConvertor_10_40.convertCodeableConcept(tj));
            }
        }
        if (src.hasLocation()) {
            tgt.addLocation(VersionConvertor_10_40.convertReference(src.getLocation()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_40.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetails(src.getExtraDetails());
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_10_40.convertAttachment(src.getPhoto()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(contactPoint));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_10_40.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasEligibility()) {
            tgt.getEligibilityFirstRep().setCode(VersionConvertor_10_40.convertCodeableConcept(src.getEligibility()));
        }
        if (src.hasEligibilityNote()) {
            tgt.getEligibilityFirstRep().setComment(src.getEligibilityNote());
        }
        for (StringType stringType : src.getProgramName()) {
            tgt.addProgram().setText((String)stringType.getValue());
        }
        for (CodeableConcept codeableConcept : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentRequiredElement()) {
            tgt.setAppointmentRequiredElement(VersionConvertor_10_40.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (HealthcareService.HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService10_40.convertHealthcareServiceAvailableTimeComponent(healthcareServiceAvailableTimeComponent));
        }
        for (HealthcareService.HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService10_40.convertHealthcareServiceNotAvailableComponent(healthcareServiceNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptionsElement()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_10_40.convertString(src.getAvailabilityExceptionsElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.HealthcareService convertHealthcareService(HealthcareService src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.HealthcareService tgt = new org.hl7.fhir.dstu2.model.HealthcareService();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_10_40.convertReference(src.getProvidedBy()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            if (!tgt.hasServiceType()) {
                tgt.addServiceType();
            }
            tgt.getServiceType().get(0).addSpecialty(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getLocation()) {
            tgt.setLocation(VersionConvertor_10_40.convertReference(reference));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_40.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetails(src.getExtraDetails());
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_10_40.convertAttachment(src.getPhoto()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(contactPoint));
        }
        for (Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_10_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        tgt.setEligibility(VersionConvertor_10_40.convertCodeableConcept(src.getEligibilityFirstRep().getCode()));
        if (src.hasCommentElement()) {
            tgt.setEligibilityNoteElement(VersionConvertor_10_40.convertString(src.getCommentElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProgram()) {
            if (!codeableConcept.hasText()) continue;
            tgt.addProgramName(codeableConcept.getText());
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentRequiredElement()) {
            tgt.setAppointmentRequiredElement(VersionConvertor_10_40.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (HealthcareService.HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService10_40.convertHealthcareServiceAvailableTimeComponent(healthcareServiceAvailableTimeComponent));
        }
        for (HealthcareService.HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService10_40.convertHealthcareServiceNotAvailableComponent(healthcareServiceNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptionsElement()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_10_40.convertString(src.getAvailabilityExceptionsElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService10_40::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDayElement()) {
            tgt.setAllDayElement(VersionConvertor_10_40.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTimeElement()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_10_40.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTimeElement()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_10_40.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService10_40::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDayElement()) {
            tgt.setAllDayElement(VersionConvertor_10_40.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTimeElement()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_10_40.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTimeElement()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_10_40.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_10_40.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_10_40.convertPeriod(src.getDuring()));
        }
        return tgt;
    }
}

