/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import java.util.ArrayList;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DataElement;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.ElementDefinition;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.StructureDefinition;

public class DataElement10_40 {
    public static StructureDefinition convertDataElement(DataElement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl().replace("/DataElement/", "/StructureDefinition/de-"));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_10_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_40.convertString(src.getPublisherElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        for (DataElement.DataElementContactComponent dataElementContactComponent : src.getContact()) {
            tgt.addContact(DataElement10_40.convertDataElementContactComponent(dataElementContactComponent));
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (DataElement.DataElementMappingComponent dataElementMappingComponent : src.getMapping()) {
            tgt.addMapping(DataElement10_40.convertDataElementMappingComponent(dataElementMappingComponent));
        }
        ArrayList<String> slicePaths = new ArrayList<String>();
        for (ElementDefinition t : src.getElement()) {
            if (t.hasSlicing()) {
                slicePaths.add(t.getPath());
            }
            tgt.getSnapshot().addElement(VersionConvertor_10_40.convertElementDefinition(t, slicePaths, src.getElement(), src.getElement().indexOf(t)));
        }
        tgt.setKind(StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
        tgt.setAbstract(false);
        tgt.setType(tgt.getName());
        tgt.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/Element");
        tgt.setDerivation(StructureDefinition.TypeDerivationRule.SPECIALIZATION);
        return tgt;
    }

    public static DataElement.DataElementContactComponent convertDataElementContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DataElement.DataElementContactComponent tgt = new DataElement.DataElementContactComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertDataElementContactComponent(DataElement.DataElementContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertDataElementMappingComponent(DataElement.DataElementMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_40.convertId(src.getIdentityElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_10_40.convertUri(src.getUriElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasCommentsElement()) {
            tgt.setCommentElement(VersionConvertor_10_40.convertString(src.getCommentsElement()));
        }
        return tgt;
    }
}

