/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.Condition;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Reference;

public class Condition10_40 {
    public static org.hl7.fhir.dstu2.model.Condition convertCondition(Condition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Condition tgt = new org.hl7.fhir.dstu2.model.Condition();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setPatient(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_40.convertReference(src.getEncounter()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_10_40.convertReference(src.getAsserter()));
        }
        if (src.hasRecordedDate()) {
            tgt.setDateRecorded(src.getRecordedDate());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.setCategory(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(Condition10_40.convertConditionClinicalStatus(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(Condition10_40.convertConditionVerificationStatus(src.getVerificationStatus()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_10_40.convertCodeableConcept(src.getSeverity()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_10_40.convertType(src.getOnset()));
        }
        if (src.hasAbatement()) {
            tgt.setAbatement(VersionConvertor_10_40.convertType(src.getAbatement()));
        }
        if (src.hasStage()) {
            tgt.setStage(Condition10_40.convertConditionStageComponent(src.getStageFirstRep()));
        }
        for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : src.getEvidence()) {
            tgt.addEvidence(Condition10_40.convertConditionEvidenceComponent(conditionEvidenceComponent));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Condition convertCondition(org.hl7.fhir.dstu2.model.Condition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition tgt = new Condition();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_40.convertReference(src.getEncounter()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_10_40.convertReference(src.getAsserter()));
        }
        if (src.hasDateRecorded()) {
            tgt.setRecordedDate(src.getDateRecorded());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_10_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(Condition10_40.convertConditionClinicalStatus(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(Condition10_40.convertConditionVerificationStatus(src.getVerificationStatus()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_10_40.convertCodeableConcept(src.getSeverity()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_10_40.convertType(src.getOnset()));
        }
        if (src.hasAbatement()) {
            tgt.setAbatement(VersionConvertor_10_40.convertType(src.getAbatement()));
        }
        if (src.hasStage()) {
            tgt.addStage(Condition10_40.convertConditionStageComponent(src.getStage()));
        }
        for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : src.getEvidence()) {
            tgt.addEvidence(Condition10_40.convertConditionEvidenceComponent(conditionEvidenceComponent));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static CodeableConcept convertConditionClinicalStatus(String src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeableConcept cc = new CodeableConcept();
        cc.addCoding().setSystem("http://hl7.org/fhir/condition-clinical").setCode(src);
        return cc;
    }

    public static String convertConditionClinicalStatus(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        for (Coding c : src.getCoding()) {
            if (!"http://hl7.org/fhir/condition-clinical".equals(c.getSystem())) continue;
            return c.getCode();
        }
        return null;
    }

    public static Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasCode()) {
            tgt.addCode(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_10_40.convertReference(t));
        }
        return tgt;
    }

    public static Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        for (CodeableConcept cc : src.getCode()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(cc));
        }
        for (Reference t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_10_40.convertReference(t));
        }
        return tgt;
    }

    public static Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasSummary()) {
            tgt.setSummary(VersionConvertor_10_40.convertCodeableConcept(src.getSummary()));
        }
        for (Reference t : src.getAssessment()) {
            tgt.addAssessment(VersionConvertor_10_40.convertReference(t));
        }
        return tgt;
    }

    public static Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasSummary()) {
            tgt.setSummary(VersionConvertor_10_40.convertCodeableConcept(src.getSummary()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getAssessment()) {
            tgt.addAssessment(VersionConvertor_10_40.convertReference(t));
        }
        return tgt;
    }

    public static CodeableConcept convertConditionVerificationStatus(Condition.ConditionVerificationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeableConcept cc = new CodeableConcept();
        switch (src) {
            case PROVISIONAL: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("provisional");
                return cc;
            }
            case DIFFERENTIAL: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("differential");
                return cc;
            }
            case CONFIRMED: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("confirmed");
                return cc;
            }
            case REFUTED: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("refuted");
                return cc;
            }
            case ENTEREDINERROR: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("entered-in-error");
                return cc;
            }
        }
        return null;
    }

    public static Condition.ConditionVerificationStatus convertConditionVerificationStatus(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "provisional")) {
            return Condition.ConditionVerificationStatus.PROVISIONAL;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "differential")) {
            return Condition.ConditionVerificationStatus.DIFFERENTIAL;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "confirmed")) {
            return Condition.ConditionVerificationStatus.CONFIRMED;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "refuted")) {
            return Condition.ConditionVerificationStatus.REFUTED;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "entered-in-error")) {
            return Condition.ConditionVerificationStatus.ENTEREDINERROR;
        }
        return Condition.ConditionVerificationStatus.NULL;
    }
}

