/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UsageContext;

public class ConceptMap10_40 {
    public static ConceptMap convertConceptMap(org.hl7.fhir.dstu2.model.ConceptMap src) throws FHIRException {
        Type r;
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap tgt = new ConceptMap();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_40.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_10_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_40.convertString(src.getPublisherElement()));
        }
        for (ConceptMap.ConceptMapContactComponent conceptMapContactComponent : src.getContact()) {
            tgt.addContact(ConceptMap10_40.convertConceptMapContactComponent(conceptMapContactComponent));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        tgt.setSource((r = VersionConvertor_10_40.convertType(src.getSource())) instanceof Reference ? new CanonicalType(((Reference)r).getReference()) : r);
        r = VersionConvertor_10_40.convertType(src.getTarget());
        tgt.setTarget(r instanceof Reference ? new CanonicalType(((Reference)r).getReference()) : r);
        for (ConceptMap.SourceElementComponent t : src.getElement()) {
            List<VersionConvertor_10_40.SourceElementComponentWrapper> ws = ConceptMap10_40.convertSourceElementComponent(t);
            for (VersionConvertor_10_40.SourceElementComponentWrapper w : ws) {
                ConceptMap10_40.getGroup(tgt, w.source, w.target).addElement(w.comp);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.ConceptMap convertConceptMap(ConceptMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.ConceptMap tgt = new org.hl7.fhir.dstu2.model.ConceptMap();
        VersionConvertor_10_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_40.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_40.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ConceptMap10_40.convertConceptMapContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_40.convertType(src.getSource()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_40.convertType(src.getTarget()));
        }
        for (ConceptMap.ConceptMapGroupComponent conceptMapGroupComponent : src.getGroup()) {
            for (ConceptMap.SourceElementComponent t : conceptMapGroupComponent.getElement()) {
                tgt.addElement(ConceptMap10_40.convertSourceElementComponent(t, conceptMapGroupComponent));
            }
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapContactComponent convertConceptMapContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.ConceptMapContactComponent tgt = new ConceptMap.ConceptMapContactComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertConceptMapContactComponent(ConceptMap.ConceptMapContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Enumerations.ConceptMapEquivalence> convertConceptMapEquivalence(Enumeration<Enumerations.ConceptMapEquivalence> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration<Enumerations.ConceptMapEquivalence> tgt = new org.hl7.fhir.dstu2.model.Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((Enumerations.ConceptMapEquivalence)((Object)src.getValue())) {
            case EQUIVALENT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUIVALENT);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUAL);
                break;
            }
            case WIDER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.WIDER);
                break;
            }
            case SUBSUMES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SUBSUMES);
                break;
            }
            case NARROWER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NARROWER);
                break;
            }
            case SPECIALIZES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SPECIALIZES);
                break;
            }
            case INEXACT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.INEXACT);
                break;
            }
            case UNMATCHED: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.UNMATCHED);
                break;
            }
            case DISJOINT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.DISJOINT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ConceptMapEquivalence> convertConceptMapEquivalence(org.hl7.fhir.dstu2.model.Enumeration<Enumerations.ConceptMapEquivalence> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ConceptMapEquivalence> tgt = new Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((Enumerations.ConceptMapEquivalence)((Object)src.getValue())) {
            case EQUIVALENT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUIVALENT);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUAL);
                break;
            }
            case WIDER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.WIDER);
                break;
            }
            case SUBSUMES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SUBSUMES);
                break;
            }
            case NARROWER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NARROWER);
                break;
            }
            case SPECIALIZES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SPECIALIZES);
                break;
            }
            case INEXACT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.INEXACT);
                break;
            }
            case UNMATCHED: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.UNMATCHED);
                break;
            }
            case DISJOINT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.DISJOINT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NULL);
            }
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasElementElement()) {
            tgt.setPropertyElement(VersionConvertor_10_40.convertUri(src.getElementElement()));
        }
        if (src.hasCodeSystem()) {
            tgt.setSystem(src.getCodeSystem());
        }
        if (src.hasCodeElement()) {
            tgt.setValueElement(VersionConvertor_10_40.convertString(src.getCodeElement()));
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasPropertyElement()) {
            tgt.setElementElement(VersionConvertor_10_40.convertUri(src.getPropertyElement()));
        }
        if (src.hasSystem()) {
            tgt.setCodeSystem(src.getSystem());
        }
        if (src.hasValueElement()) {
            tgt.setCodeElement(VersionConvertor_10_40.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static List<VersionConvertor_10_40.SourceElementComponentWrapper> convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        ArrayList<VersionConvertor_10_40.SourceElementComponentWrapper> res = new ArrayList<VersionConvertor_10_40.SourceElementComponentWrapper>();
        if (src == null || src.isEmpty()) {
            return res;
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
            VersionConvertor_10_40.copyElement(src, tgt);
            tgt.setCode(src.getCode());
            tgt.addTarget(ConceptMap10_40.convertTargetElementComponent(t));
            res.add(new VersionConvertor_10_40.SourceElementComponentWrapper(tgt, src.getCodeSystem(), t.getCodeSystem()));
        }
        return res;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src, ConceptMap.ConceptMapGroupComponent g2) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        tgt.setCodeSystem(g2.getSource());
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_40.convertCode(src.getCodeElement()));
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            tgt.addTarget(ConceptMap10_40.convertTargetElementComponent(t, g2));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src, ConceptMap.ConceptMapGroupComponent g2) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        tgt.setCodeSystem(g2.getTarget());
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_40.convertCode(src.getCodeElement()));
        }
        if (src.hasEquivalence()) {
            tgt.setEquivalenceElement(ConceptMap10_40.convertConceptMapEquivalence(src.getEquivalenceElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentsElement(VersionConvertor_10_40.convertString(src.getCommentElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap10_40.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap10_40.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_10_40.copyElement(src, tgt);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_40.convertCode(src.getCodeElement()));
        }
        if (src.hasEquivalence()) {
            tgt.setEquivalenceElement(ConceptMap10_40.convertConceptMapEquivalence(src.getEquivalenceElement()));
        }
        if (src.hasCommentsElement()) {
            tgt.setCommentElement(VersionConvertor_10_40.convertString(src.getCommentsElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap10_40.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap10_40.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupComponent getGroup(ConceptMap map, String srcs, String tgts) {
        for (ConceptMap.ConceptMapGroupComponent grp : map.getGroup()) {
            if (!grp.getSource().equals(srcs) || !grp.getTarget().equals(tgts)) continue;
            return grp;
        }
        ConceptMap.ConceptMapGroupComponent grp = map.addGroup();
        grp.setSource(srcs);
        grp.setTarget(tgts);
        return grp;
    }
}

