/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Subscription;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.exceptions.FHIRException;

public class Subscription10_30 {
    public static Subscription convertSubscription(org.hl7.fhir.dstu2.model.Subscription src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Subscription tgt = new Subscription();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasCriteriaElement()) {
            tgt.setCriteriaElement(VersionConvertor_10_30.convertString(src.getCriteriaElement()));
        }
        for (ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasReasonElement()) {
            tgt.setReasonElement(VersionConvertor_10_30.convertString(src.getReasonElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Subscription10_30.convertSubscriptionStatus(src.getStatusElement()));
        }
        if (src.hasErrorElement()) {
            tgt.setErrorElement(VersionConvertor_10_30.convertString(src.getErrorElement()));
        }
        if (src.hasChannel()) {
            tgt.setChannel(Subscription10_30.convertSubscriptionChannelComponent(src.getChannel()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_30.convertInstant(src.getEndElement()));
        }
        for (org.hl7.fhir.dstu2.model.Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_10_30.convertCoding(coding));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Subscription convertSubscription(Subscription src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Subscription tgt = new org.hl7.fhir.dstu2.model.Subscription();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasCriteriaElement()) {
            tgt.setCriteriaElement(VersionConvertor_10_30.convertString(src.getCriteriaElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasReasonElement()) {
            tgt.setReasonElement(VersionConvertor_10_30.convertString(src.getReasonElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Subscription10_30.convertSubscriptionStatus(src.getStatusElement()));
        }
        if (src.hasErrorElement()) {
            tgt.setErrorElement(VersionConvertor_10_30.convertString(src.getErrorElement()));
        }
        if (src.hasChannel()) {
            tgt.setChannel(Subscription10_30.convertSubscriptionChannelComponent(src.getChannel()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_30.convertInstant(src.getEndElement()));
        }
        for (Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_10_30.convertCoding(coding));
        }
        return tgt;
    }

    public static Subscription.SubscriptionChannelComponent convertSubscriptionChannelComponent(Subscription.SubscriptionChannelComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Subscription.SubscriptionChannelComponent tgt = new Subscription.SubscriptionChannelComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasType()) {
            tgt.setTypeElement(Subscription10_30.convertSubscriptionChannelType(src.getTypeElement()));
        }
        if (src.hasEndpointElement()) {
            tgt.setEndpointElement(VersionConvertor_10_30.convertUri(src.getEndpointElement()));
        }
        if (src.hasPayloadElement()) {
            tgt.setPayloadElement(VersionConvertor_10_30.convertString(src.getPayloadElement()));
        }
        if (src.hasHeader()) {
            tgt.setHeaderElement(VersionConvertor_10_30.convertString(src.getHeader().get(0)));
        }
        return tgt;
    }

    public static Subscription.SubscriptionChannelComponent convertSubscriptionChannelComponent(Subscription.SubscriptionChannelComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Subscription.SubscriptionChannelComponent tgt = new Subscription.SubscriptionChannelComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasType()) {
            tgt.setTypeElement(Subscription10_30.convertSubscriptionChannelType(src.getTypeElement()));
        }
        if (src.hasEndpointElement()) {
            tgt.setEndpointElement(VersionConvertor_10_30.convertUri(src.getEndpointElement()));
        }
        if (src.hasPayloadElement()) {
            tgt.setPayloadElement(VersionConvertor_10_30.convertString(src.getPayloadElement()));
        }
        tgt.addHeader(src.getHeader());
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionChannelType> convertSubscriptionChannelType(Enumeration<Subscription.SubscriptionChannelType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionChannelType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionChannelType>(new Subscription.SubscriptionChannelTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Subscription.SubscriptionChannelType)((Object)src.getValue())) {
            case RESTHOOK: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.RESTHOOK);
                break;
            }
            case WEBSOCKET: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.WEBSOCKET);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.EMAIL);
                break;
            }
            case SMS: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.SMS);
                break;
            }
            case MESSAGE: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.MESSAGE);
                break;
            }
            default: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Subscription.SubscriptionChannelType> convertSubscriptionChannelType(org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionChannelType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Subscription.SubscriptionChannelType> tgt = new Enumeration<Subscription.SubscriptionChannelType>(new Subscription.SubscriptionChannelTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Subscription.SubscriptionChannelType)((Object)src.getValue())) {
            case RESTHOOK: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.RESTHOOK);
                break;
            }
            case WEBSOCKET: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.WEBSOCKET);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.EMAIL);
                break;
            }
            case SMS: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.SMS);
                break;
            }
            case MESSAGE: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.MESSAGE);
                break;
            }
            default: {
                tgt.setValue((Object)Subscription.SubscriptionChannelType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionStatus> convertSubscriptionStatus(Enumeration<Subscription.SubscriptionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionStatus>(new Subscription.SubscriptionStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Subscription.SubscriptionStatus)((Object)src.getValue())) {
            case REQUESTED: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.REQUESTED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.ACTIVE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.ERROR);
                break;
            }
            case OFF: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.OFF);
                break;
            }
            default: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Subscription.SubscriptionStatus> convertSubscriptionStatus(org.hl7.fhir.dstu3.model.Enumeration<Subscription.SubscriptionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Subscription.SubscriptionStatus> tgt = new Enumeration<Subscription.SubscriptionStatus>(new Subscription.SubscriptionStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Subscription.SubscriptionStatus)((Object)src.getValue())) {
            case REQUESTED: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.REQUESTED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.ACTIVE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.ERROR);
                break;
            }
            case OFF: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.OFF);
                break;
            }
            default: {
                tgt.setValue((Object)Subscription.SubscriptionStatus.NULL);
            }
        }
        return tgt;
    }
}

