/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Schedule;
import org.hl7.fhir.exceptions.FHIRException;

public class Schedule10_30 {
    public static org.hl7.fhir.dstu2.model.Schedule convertSchedule(Schedule src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Schedule tgt = new org.hl7.fhir.dstu2.model.Schedule();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addType(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_30.convertReference(src.getActorFirstRep()));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(VersionConvertor_10_30.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_30.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static Schedule convertSchedule(org.hl7.fhir.dstu2.model.Schedule src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Schedule tgt = new Schedule();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addServiceType(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActor()) {
            tgt.addActor(VersionConvertor_10_30.convertReference(src.getActor()));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(VersionConvertor_10_30.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_30.convertString(src.getCommentElement()));
        }
        return tgt;
    }
}

