/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.exceptions.FHIRException;

public class RelatedPerson10_30 {
    public static RelatedPerson convertRelatedPerson(org.hl7.fhir.dstu2.model.RelatedPerson src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        RelatedPerson tgt = new RelatedPerson();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(VersionConvertor_10_30.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasName()) {
            tgt.addName(VersionConvertor_10_30.convertHumanName(src.getName()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_30.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_30.convertDate(src.getBirthDateElement()));
        }
        for (org.hl7.fhir.dstu2.model.Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_30.convertAddress(address));
        }
        for (org.hl7.fhir.dstu2.model.Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_10_30.convertAttachment(attachment));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.RelatedPerson convertRelatedPerson(RelatedPerson src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.RelatedPerson tgt = new org.hl7.fhir.dstu2.model.RelatedPerson();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(VersionConvertor_10_30.convertCodeableConcept(src.getRelationship()));
        }
        if (!src.getName().isEmpty()) {
            tgt.setName(VersionConvertor_10_30.convertHumanName(src.getName().get(0)));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_30.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_30.convertDate(src.getBirthDateElement()));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_30.convertAddress(address));
        }
        for (Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_10_30.convertAttachment(attachment));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

