/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.exceptions.FHIRException;

public class ReferralRequest10_30 {
    public static org.hl7.fhir.dstu2.model.CodeableConcept convertReferralPriorityCode(ReferralRequest.ReferralPriority priority) {
        org.hl7.fhir.dstu2.model.CodeableConcept cc = new org.hl7.fhir.dstu2.model.CodeableConcept();
        switch (priority) {
            case ROUTINE: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("routine");
                break;
            }
            case URGENT: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("urgent");
                break;
            }
            case STAT: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("stat");
                break;
            }
            case ASAP: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("asap");
                break;
            }
            default: {
                return null;
            }
        }
        return cc;
    }

    public static ReferralRequest.ReferralPriority convertReferralPriorityCode(org.hl7.fhir.dstu2.model.CodeableConcept priority) {
        for (Coding c : priority.getCoding()) {
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "routine".equals(c.getCode())) {
                return ReferralRequest.ReferralPriority.ROUTINE;
            }
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "urgent".equals(c.getCode())) {
                return ReferralRequest.ReferralPriority.URGENT;
            }
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "stat".equals(c.getCode())) {
                return ReferralRequest.ReferralPriority.STAT;
            }
            if (!"http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) || !"asap".equals(c.getCode())) continue;
            return ReferralRequest.ReferralPriority.ASAP;
        }
        return null;
    }

    public static org.hl7.fhir.dstu2.model.ReferralRequest convertReferralRequest(ReferralRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.ReferralRequest tgt = new org.hl7.fhir.dstu2.model.ReferralRequest();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ReferralRequest10_30.convertReferralStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(ReferralRequest10_30.convertReferralPriorityCode(src.getPriority()));
        }
        if (src.hasSubject()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasOccurrencePeriod()) {
            tgt.setFulfillmentTime(VersionConvertor_10_30.convertPeriod(src.getOccurrencePeriod()));
        }
        tgt.setRequester(VersionConvertor_10_30.convertReference(src.getRequester().getAgent()));
        if (src.hasSpecialty()) {
            tgt.setSpecialty(VersionConvertor_10_30.convertCodeableConcept(src.getSpecialty()));
        }
        for (Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_30.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.setReason(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (CodeableConcept codeableConcept : src.getServiceRequested()) {
            tgt.addServiceRequested(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInformation(VersionConvertor_10_30.convertReference(reference));
        }
        return tgt;
    }

    public static ReferralRequest convertReferralRequest(org.hl7.fhir.dstu2.model.ReferralRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ReferralRequest tgt = new ReferralRequest();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ReferralRequest10_30.convertReferralStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(ReferralRequest10_30.convertReferralPriorityCode(src.getPriority()));
        }
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasFulfillmentTime()) {
            tgt.setOccurrence(VersionConvertor_10_30.convertPeriod(src.getFulfillmentTime()));
        }
        tgt.getRequester().setAgent(VersionConvertor_10_30.convertReference(src.getRequester()));
        if (src.hasSpecialty()) {
            tgt.setSpecialty(VersionConvertor_10_30.convertCodeableConcept(src.getSpecialty()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasReason()) {
            tgt.addReasonCode(VersionConvertor_10_30.convertCodeableConcept(src.getReason()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getServiceRequested()) {
            tgt.addServiceRequested(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInfo(VersionConvertor_10_30.convertReference(reference));
        }
        return tgt;
    }

    public static Enumeration<ReferralRequest.ReferralStatus> convertReferralStatus(org.hl7.fhir.dstu3.model.Enumeration<ReferralRequest.ReferralRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ReferralRequest.ReferralStatus> tgt = new Enumeration<ReferralRequest.ReferralStatus>(new ReferralRequest.ReferralStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ReferralRequest.ReferralRequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)ReferralRequest.ReferralStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)ReferralRequest.ReferralStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)ReferralRequest.ReferralStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ReferralRequest.ReferralStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ReferralRequest.ReferralStatus.REJECTED);
                break;
            }
            default: {
                tgt.setValue((Object)ReferralRequest.ReferralStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ReferralRequest.ReferralRequestStatus> convertReferralStatus(Enumeration<ReferralRequest.ReferralStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ReferralRequest.ReferralRequestStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ReferralRequest.ReferralRequestStatus>(new ReferralRequest.ReferralRequestStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ReferralRequest.ReferralStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)ReferralRequest.ReferralRequestStatus.DRAFT);
                break;
            }
            case REQUESTED: {
                tgt.setValue((Object)ReferralRequest.ReferralRequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)ReferralRequest.ReferralRequestStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)ReferralRequest.ReferralRequestStatus.CANCELLED);
                break;
            }
            case ACCEPTED: {
                tgt.setValue((Object)ReferralRequest.ReferralRequestStatus.ACTIVE);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)ReferralRequest.ReferralRequestStatus.ENTEREDINERROR);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ReferralRequest.ReferralRequestStatus.COMPLETED);
                break;
            }
            default: {
                tgt.setValue((Object)ReferralRequest.ReferralRequestStatus.NULL);
            }
        }
        return tgt;
    }
}

