/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.exceptions.FHIRException;

public class QuestionnaireResponse10_30 {
    public static QuestionnaireResponse.GroupComponent convertQuestionnaireItemToGroup(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.GroupComponent tgt = new QuestionnaireResponse.GroupComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasLinkIdElement()) {
            tgt.setLinkIdElement(VersionConvertor_10_30.convertString(src.getLinkIdElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            if (t.hasAnswer()) {
                tgt.addQuestion(QuestionnaireResponse10_30.convertQuestionnaireItemToQuestion(t));
                continue;
            }
            tgt.addGroup(QuestionnaireResponse10_30.convertQuestionnaireItemToGroup(t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionComponent convertQuestionnaireItemToQuestion(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionComponent tgt = new QuestionnaireResponse.QuestionComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasLinkIdElement()) {
            tgt.setLinkIdElement(VersionConvertor_10_30.convertString(src.getLinkIdElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getAnswer()) {
            tgt.addAnswer(QuestionnaireResponse10_30.convertQuestionnaireResponseItemAnswerComponent(t));
        }
        return tgt;
    }

    public static QuestionnaireResponse convertQuestionnaireResponse(org.hl7.fhir.dstu3.model.QuestionnaireResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse tgt = new QuestionnaireResponse();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasQuestionnaire()) {
            tgt.setQuestionnaire(VersionConvertor_10_30.convertReference(src.getQuestionnaire()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(QuestionnaireResponse10_30.convertQuestionnaireResponseStatus(src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_30.convertReference(src.getAuthor()));
        }
        if (src.hasAuthoredElement()) {
            tgt.setAuthoredElement(VersionConvertor_10_30.convertDateTime(src.getAuthoredElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_30.convertReference(src.getSource()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getContext()));
        }
        if (src.getItem().size() != 1) {
            throw new FHIRException("multiple root items not supported");
        }
        tgt.setGroup(QuestionnaireResponse10_30.convertQuestionnaireItemToGroup(src.getItem().get(0)));
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.QuestionnaireResponse convertQuestionnaireResponse(QuestionnaireResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.QuestionnaireResponse tgt = new org.hl7.fhir.dstu3.model.QuestionnaireResponse();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasQuestionnaire()) {
            tgt.setQuestionnaire(VersionConvertor_10_30.convertReference(src.getQuestionnaire()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(QuestionnaireResponse10_30.convertQuestionnaireResponseStatus(src.getStatusElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_30.convertReference(src.getAuthor()));
        }
        if (src.hasAuthoredElement()) {
            tgt.setAuthoredElement(VersionConvertor_10_30.convertDateTime(src.getAuthoredElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_30.convertReference(src.getSource()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        if (src.hasGroup()) {
            tgt.addItem(QuestionnaireResponse10_30.convertQuestionnaireResponseGroupComponent(src.getGroup()));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseGroupComponent(QuestionnaireResponse.GroupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasLinkIdElement()) {
            tgt.setLinkIdElement(VersionConvertor_10_30.convertString(src.getLinkIdElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        for (QuestionnaireResponse.GroupComponent groupComponent : src.getGroup()) {
            tgt.addItem(QuestionnaireResponse10_30.convertQuestionnaireResponseGroupComponent(groupComponent));
        }
        for (QuestionnaireResponse.QuestionComponent questionComponent : src.getQuestion()) {
            tgt.addItem(QuestionnaireResponse10_30.convertQuestionnaireResponseQuestionComponent(questionComponent));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionAnswerComponent tgt = new QuestionnaireResponse.QuestionAnswerComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_30.convertType(src.getValue()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addGroup(QuestionnaireResponse10_30.convertQuestionnaireItemToGroup(t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionAnswerComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_30.convertType(src.getValue()));
        }
        for (QuestionnaireResponse.GroupComponent t : src.getGroup()) {
            tgt.addItem(QuestionnaireResponse10_30.convertQuestionnaireResponseGroupComponent(t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseQuestionComponent(QuestionnaireResponse.QuestionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasLinkIdElement()) {
            tgt.setLinkIdElement(VersionConvertor_10_30.convertString(src.getLinkIdElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        for (QuestionnaireResponse.QuestionAnswerComponent t : src.getAnswer()) {
            tgt.addAnswer(QuestionnaireResponse10_30.convertQuestionnaireResponseItemAnswerComponent(t));
        }
        return tgt;
    }

    public static Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> convertQuestionnaireResponseStatus(org.hl7.fhir.dstu3.model.Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> tgt = new Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus>(new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((QuestionnaireResponse.QuestionnaireResponseStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED);
                break;
            }
            default: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> convertQuestionnaireResponseStatus(Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<QuestionnaireResponse.QuestionnaireResponseStatus>(new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((QuestionnaireResponse.QuestionnaireResponseStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED);
                break;
            }
            default: {
                tgt.setValue((Object)QuestionnaireResponse.QuestionnaireResponseStatus.NULL);
            }
        }
        return tgt;
    }
}

