/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.HumanName;
import org.hl7.fhir.dstu2.model.Person;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Person;
import org.hl7.fhir.exceptions.FHIRException;

public class Person10_30 {
    public static org.hl7.fhir.dstu3.model.Enumeration<Person.IdentityAssuranceLevel> convertIdentityAssuranceLevel(Enumeration<Person.IdentityAssuranceLevel> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Person.IdentityAssuranceLevel> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Person.IdentityAssuranceLevel>(new Person.IdentityAssuranceLevelEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Person.IdentityAssuranceLevel)((Object)src.getValue())) {
            case LEVEL1: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL1);
                break;
            }
            case LEVEL2: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL2);
                break;
            }
            case LEVEL3: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL3);
                break;
            }
            case LEVEL4: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL4);
                break;
            }
            default: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Person.IdentityAssuranceLevel> convertIdentityAssuranceLevel(org.hl7.fhir.dstu3.model.Enumeration<Person.IdentityAssuranceLevel> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Person.IdentityAssuranceLevel> tgt = new Enumeration<Person.IdentityAssuranceLevel>(new Person.IdentityAssuranceLevelEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Person.IdentityAssuranceLevel)((Object)src.getValue())) {
            case LEVEL1: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL1);
                break;
            }
            case LEVEL2: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL2);
                break;
            }
            case LEVEL3: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL3);
                break;
            }
            case LEVEL4: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.LEVEL4);
                break;
            }
            default: {
                tgt.setValue((Object)Person.IdentityAssuranceLevel.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Person convertPerson(Person src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Person tgt = new org.hl7.fhir.dstu3.model.Person();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        for (HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_10_30.convertHumanName(humanName));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_30.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_30.convertDate(src.getBirthDateElement()));
        }
        for (org.hl7.fhir.dstu2.model.Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_30.convertAddress(address));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_10_30.convertAttachment(src.getPhoto()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_10_30.convertReference(src.getManagingOrganization()));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_30.convertBoolean(src.getActiveElement()));
        }
        for (Person.PersonLinkComponent personLinkComponent : src.getLink()) {
            tgt.addLink(Person10_30.convertPersonLinkComponent(personLinkComponent));
        }
        return tgt;
    }

    public static Person convertPerson(org.hl7.fhir.dstu3.model.Person src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Person tgt = new Person();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.dstu3.model.HumanName humanName : src.getName()) {
            tgt.addName(VersionConvertor_10_30.convertHumanName(humanName));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_30.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_30.convertDate(src.getBirthDateElement()));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_30.convertAddress(address));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_10_30.convertAttachment(src.getPhoto()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_10_30.convertReference(src.getManagingOrganization()));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_30.convertBoolean(src.getActiveElement()));
        }
        for (Person.PersonLinkComponent personLinkComponent : src.getLink()) {
            tgt.addLink(Person10_30.convertPersonLinkComponent(personLinkComponent));
        }
        return tgt;
    }

    public static Person.PersonLinkComponent convertPersonLinkComponent(Person.PersonLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Person.PersonLinkComponent tgt = new Person.PersonLinkComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_30.convertReference(src.getTarget()));
        }
        if (src.hasAssurance()) {
            tgt.setAssuranceElement(Person10_30.convertIdentityAssuranceLevel(src.getAssuranceElement()));
        }
        return tgt;
    }

    public static Person.PersonLinkComponent convertPersonLinkComponent(Person.PersonLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Person.PersonLinkComponent tgt = new Person.PersonLinkComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_30.convertReference(src.getTarget()));
        }
        if (src.hasAssurance()) {
            tgt.setAssuranceElement(Person10_30.convertIdentityAssuranceLevel(src.getAssuranceElement()));
        }
        return tgt;
    }
}

